/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.cluster;

import ij.IJ;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mosaic.core.cluster.BatchInterface;
import mosaic.core.cluster.ClusterProfile;
import mosaic.core.cluster.JobStatus;
import mosaic.core.cluster.SecureShellSession;
import mosaic.core.utils.MosaicUtils;
import mosaic.core.utils.ShellCommand;

class LSFBatch
implements BatchInterface {
    private int AJobID = 0;
    private BatchInterface.OutputType tp;
    private JobStatus[] jb;
    private String script;
    private ClusterProfile cp;
    private int nJobs = 0;
    private String lDir;
    private int nele_parsed = 0;

    public LSFBatch(ClusterProfile cp_) {
        this.cp = cp_;
    }

    @Override
    public String getScript(String img_script_, String session_id, double ext, int njob, int ns) {
        String queue = this.cp.getQueue(ext);
        if (queue == null) {
            IJ.error((String)"Error", (String)("Error the following cluster has all the queues shorter than " + ext + " minutes"));
            return null;
        }
        this.script = session_id;
        return new String("#!/bin/bash \n#BSUB -q " + queue + "\n#BSUB -n " + ns + " \n#BSUB -J \"" + session_id + "[1-" + njob + "]\" \n#BSUB -R span[hosts=1]\n#BSUB -o " + session_id + ".out.%J \n\necho \"running " + this.script + " on index $LSB_JOBINDEX\" \n" + this.cp.getRunningDir() + "Fiji.app/ImageJ-linux64 --headless -batch " + img_script_ + " $LSB_JOBINDEX");
    }

    @Override
    public String runCommand(String tdir) {
        this.tp = BatchInterface.OutputType.LAUNCH;
        return new String("bsub < " + this.script);
    }

    @Override
    public String statusJobCommand() {
        this.tp = BatchInterface.OutputType.STATUS;
        return new String("bjobs " + this.AJobID);
    }

    @Override
    public void createJobStatus() {
        this.jb = new JobStatus[this.nJobs];
    }

    private int jobArrayID(String aID) {
        Pattern jobID = Pattern.compile("\\x5B[0-9]+\\x5D");
        Matcher matcher = jobID.matcher(aID);
        if (matcher.find()) {
            String sub = matcher.group(0);
            sub = sub.substring(1, sub.length() - 1);
            return Integer.parseInt(sub);
        }
        return 0;
    }

    private JobStatus.jobS jobArrayStatus(String aID) {
        if (aID.equals("PEND")) {
            return JobStatus.jobS.PENDING;
        }
        if (aID.equals("RUN")) {
            return JobStatus.jobS.RUNNING;
        }
        if (aID.equals("DONE")) {
            return JobStatus.jobS.COMPLETE;
        }
        if (aID.equals("EXIT")) {
            return JobStatus.jobS.FAILED;
        }
        return JobStatus.jobS.UNKNOWN;
    }

    private String parseStatus(String prs, JobStatus[] jobs) {
        int nele = 0;
        boolean unparse_last = true;
        if (prs.endsWith("\n")) {
            unparse_last = false;
        }
        String[] elements = prs.split("\n");
        nele = elements.length - 1;
        if (!unparse_last) {
            nele = elements.length;
        }
        for (int i = 0; i < nele; ++i) {
            if (elements[i].equals("Job <" + this.AJobID + "> is not found\r")) {
                this.nele_parsed = this.nJobs;
                for (int j = 0; j < jobs.length; ++j) {
                    jobs[j] = new JobStatus();
                    jobs[j].setStatus(JobStatus.jobS.UNKNOWN);
                }
                return "";
            }
            Vector<String> vt = new Vector<String>();
            String[] sub_elements = elements[i].split(" ");
            for (int j = 0; j < sub_elements.length; ++j) {
                if (sub_elements[j].length() == 0) continue;
                vt.add(sub_elements[j]);
            }
            int ja_id = 0;
            if (vt.size() > 2) {
                if (this.jobArrayStatus((String)vt.get(2)) == JobStatus.jobS.RUNNING || this.jobArrayStatus((String)vt.get(2)) == JobStatus.jobS.COMPLETE || this.jobArrayStatus((String)vt.get(2)) == JobStatus.jobS.FAILED) {
                    ja_id = this.jobArrayID((String)vt.get(6));
                    this.updateJobStatus(jobs, vt, ja_id);
                } else if (this.jobArrayStatus(vt.get(2)) == JobStatus.jobS.PENDING) {
                    ja_id = this.jobArrayID(vt.get(5));
                    this.updateJobStatus(jobs, vt, ja_id);
                } else if (this.jobArrayStatus(vt.get(2)) == JobStatus.jobS.UNKNOWN) {
                    if (vt.size() < 6) continue;
                    ja_id = this.jobArrayID(vt.get(5));
                    this.updateJobStatus(jobs, vt, ja_id);
                }
            }
            System.out.println("Parsing: [" + elements[i] + "]");
            System.out.println(" nele_parsed: " + this.nele_parsed);
        }
        if (unparse_last) {
            return elements[elements.length - 1];
        }
        return new String("");
    }

    private void updateJobStatus(JobStatus[] jobs, Vector<String> vt, int ja_id) {
        if (--ja_id >= 0) {
            jobs[ja_id] = new JobStatus();
            jobs[ja_id].setStatus(this.jobArrayStatus(vt.get(2)));
            ++this.nele_parsed;
        }
    }

    private int parseJobID(String id) {
        Pattern jobID = Pattern.compile("<[0-9]+>");
        Matcher matcher = jobID.matcher(id);
        if (matcher.find()) {
            String sub = matcher.group(0);
            sub = sub.substring(1, sub.length() - 1);
            return Integer.parseInt(sub);
        }
        return 0;
    }

    @Override
    public void setJobStatus(JobStatus[] jb_) {
        this.jb = jb_;
    }

    @Override
    public JobStatus[] getJobStatus() {
        return this.jb;
    }

    @Override
    public int getJobID() {
        return this.AJobID;
    }

    @Override
    public String Process(String str) {
        if (this.tp == BatchInterface.OutputType.STATUS) {
            return this.parseStatus(str, this.jb);
        }
        if (this.tp == BatchInterface.OutputType.LAUNCH) {
            System.out.println("ParseJobID [" + str + "]");
            int tmp = this.parseJobID(str);
            if (tmp == 0) {
                return str;
            }
            if (this.AJobID == 0) {
                this.AJobID = tmp;
            }
            System.out.println("get Job ID: " + this.AJobID);
            return "";
        }
        return "";
    }

    @Override
    public void reset() {
        this.nele_parsed = 0;
    }

    @Override
    public void waitParsing() {
        for (int ntime = 0; this.nele_parsed < this.nJobs && ntime < 100; ++ntime) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Send Command");
    }

    private boolean loadDir(String dir, SecureShellSession ss, ClusterProfile cp_, String command) {
        String tmp_dir = IJ.getDirectory((String)"temp");
        File[] fl = new File[]{new File(dir + File.separator + "JobID")};
        try {
            ShellCommand.exeCmdNoPrint("mkdir " + tmp_dir);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        File jid = new File(tmp_dir + "JobID");
        jid.delete();
        ss.download(fl, new File(tmp_dir), null, this.cp);
        if (!jid.exists()) {
            return false;
        }
        String[] s = MosaicUtils.readAndSplit(tmp_dir + File.separator + "JobID");
        String tmp = new String(command);
        if (s.length < 3 && !s[2].equals(tmp.replace(" ", "_"))) {
            return false;
        }
        this.AJobID = Integer.parseInt(s[0]);
        this.nJobs = Integer.parseInt(s[1]);
        this.tp = BatchInterface.OutputType.STATUS;
        this.cp = cp_;
        this.lDir = dir;
        return true;
    }

    @Override
    public BatchInterface[] getAllJobs(SecureShellSession ss, String command) {
        String[] dirs = ss.getDirs(this.cp.getRunningDir());
        if (dirs == null) {
            return null;
        }
        Vector<LSFBatch> bc_v = new Vector<LSFBatch>();
        for (int i = 0; i < dirs.length; ++i) {
            LSFBatch tmp = new LSFBatch(this.cp);
            if (!tmp.loadDir(this.cp.getRunningDir() + dirs[i], ss, this.cp, command)) continue;
            bc_v.add(tmp);
        }
        BatchInterface[] bc_a = new LSFBatch[bc_v.size()];
        bc_v.toArray(bc_a);
        return bc_a;
    }

    @Override
    public JobStatus[] getJobsStatus() {
        return this.jb;
    }

    @Override
    public int getNJobs() {
        return this.nJobs;
    }

    @Override
    public void clean(SecureShellSession ss) {
        String[] commands = new String[]{new String("rm -rf " + this.lDir)};
        ss.runCommands(commands);
    }

    @Override
    public String getDir() {
        return this.lDir;
    }

    @Override
    public void setJobID(int id) {
        this.AJobID = id;
    }
}

