/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.cluster;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import ij.IJ;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import mosaic.core.GUI.ProgressBarWin;
import mosaic.core.cluster.ClusterProfile;
import mosaic.core.cluster.DataCompression;
import mosaic.core.cluster.ShellProcessOutput;
import mosaic.utils.Debug;

class SecureShellSession
implements Runnable,
ShellProcessOutput,
SftpProgressMonitor {
    private ShellProcessOutput shp;
    private final PipedInputStream pinput_in = new PipedInputStream();
    private final PipedOutputStream pinput_out = new PipedOutputStream();
    private final PipedInputStream poutput_in = new PipedInputStream();
    private final PipedOutputStream poutput_out = new PipedOutputStream();
    private String tdir = null;
    private final ClusterProfile cprof;
    private JSch jsch;
    private ChannelSftp cSFTP;
    private Channel cSSH;
    private Session session;
    private String session_id;
    private boolean computed = false;
    private String waitString;
    private String doing;
    private ProgressBarWin wp_p;
    private long size_total = 0L;
    private long total = 0L;

    SecureShellSession(ClusterProfile cprof_) {
        try {
            this.poutput_out.connect(this.poutput_in);
            this.pinput_in.connect(this.pinput_out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.cprof = cprof_;
    }

    void close() throws InterruptedException, IOException {
        while (this.poutput_in.available() != 0 && this.pinput_in.available() != 0) {
            Thread.sleep(100L);
        }
        this.pinput_in.close();
        this.pinput_out.close();
        this.poutput_in.close();
        this.poutput_out.close();
        this.cSFTP.disconnect();
        this.cSSH.disconnect();
        this.session.disconnect();
    }

    void setShellProcessOutput(ShellProcessOutput prc_) {
        this.shp = prc_;
    }

    String[] getDirs(String Directory) {
        Vector<String> vs = new Vector<String>();
        try {
            if (!this.createSftpChannel()) {
                return null;
            }
            Vector list = this.cSFTP.ls(Directory);
            for (ChannelSftp.LsEntry entry : list) {
                if (!entry.getAttrs().isDir()) continue;
                vs.add(entry.getFilename());
            }
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        String[] out = new String[vs.size()];
        vs.toArray(out);
        return out;
    }

    boolean checkDirectory(String Directory) {
        try {
            if (!this.createSftpChannel()) {
                return false;
            }
            this.cSFTP.cd(Directory);
        }
        catch (JSchException e) {
            return false;
        }
        catch (SftpException e) {
            return false;
        }
        return true;
    }

    boolean checkFile(String Directory, String file_name) {
        try {
            if (!this.createSftpChannel()) {
                return false;
            }
            Vector fl = this.cSFTP.ls(Directory);
            for (ChannelSftp.LsEntry f : fl) {
                if (!f.getFilename().contains(file_name)) continue;
                return true;
            }
            return false;
        }
        catch (JSchException e) {
            return false;
        }
        catch (SftpException e) {
            return false;
        }
    }

    boolean runCommands(String[] commands) {
        Debug.print("SSH COMMANDS", commands);
        String cmd_list = new String();
        for (int i = 0; i < commands.length; ++i) {
            cmd_list = cmd_list + commands[i] + "\n";
        }
        try {
            if (!this.createSSHChannel()) {
                return false;
            }
            this.pinput_out.write(cmd_list.getBytes());
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean createSession() throws JSchException {
        if (this.jsch == null) {
            this.jsch = new JSch();
        }
        if (this.session != null && this.session.isConnected()) {
            return true;
        }
        String host = this.cprof.getAccessAddress();
        String user = this.cprof.getUsername();
        if (this.cprof.getPassword() == null || this.cprof.getPassword().length() == 0) {
            File p_key = null;
            if (IJ.isLinux()) {
                p_key = new File("/home/" + this.cprof.getUsername() + "/.ssh/id_rsa");
            } else if (IJ.isMacOSX()) {
                p_key = new File("/Users/" + this.cprof.getUsername() + "/.ssh/id_rsa");
            } else {
                throw new RuntimeException("private key location unknown!");
            }
            this.jsch.addIdentity(p_key.getAbsolutePath());
            this.session = this.jsch.getSession(user, host, 22);
        } else {
            this.session = this.jsch.getSession(user, host, 22);
            this.session.setPassword(this.cprof.getPassword());
        }
        Properties config_ = new Properties();
        config_.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config_);
        try {
            this.session.connect();
        }
        catch (JSchException e) {
            IJ.error((String)"Connection failed", (String)e.getMessage());
            return false;
        }
        return true;
    }

    private boolean createSSHChannel() throws JSchException {
        if (this.jsch == null) {
            this.jsch = new JSch();
        }
        if (this.cSSH != null && this.cSSH.isConnected()) {
            return true;
        }
        if (!this.createSession()) {
            return false;
        }
        this.cSSH = this.session.openChannel("shell");
        this.cSSH.setInputStream((InputStream)this.pinput_in);
        this.cSSH.setOutputStream((OutputStream)this.poutput_out);
        new Thread(this).start();
        this.cSSH.connect();
        return true;
    }

    private boolean createSftpChannel() throws JSchException {
        if (this.jsch == null) {
            this.jsch = new JSch();
        }
        if (this.cSFTP != null && this.cSFTP.isConnected()) {
            return true;
        }
        if (!this.createSession()) {
            return false;
        }
        this.cSFTP = (ChannelSftp)this.session.openChannel("sftp");
        this.cSFTP.connect();
        return true;
    }

    boolean download(File[] files, File dir, ProgressBarWin wp, ClusterProfile cp) {
        boolean ret = true;
        try {
            if (!this.createSftpChannel()) {
                return false;
            }
            DataCompression cmp = new DataCompression();
            if (cp != null) {
                cmp.selectCompressor();
                while (!cp.hasCompressor(cmp.getCompressor())) {
                    cmp.nextCompressor();
                }
            }
            for (int i = 0; i < files.length; ++i) {
                try {
                    String absolutePath = files[i].getPath();
                    String filePath = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
                    this.tdir = filePath + File.separator;
                    this.cSFTP.cd(this.tdir);
                    if (cmp.getCompressor() == null) {
                        if (wp != null) {
                            wp.SetProgress(100 * i / files.length);
                        }
                        this.cSFTP.get(files[i].getName(), dir.getAbsolutePath() + File.separator + files[i].getName());
                        continue;
                    }
                    if (wp != null) {
                        wp.SetStatusMessage("Compressing data on cluster");
                    }
                    if (!this.createSSHChannel()) {
                        return false;
                    }
                    String s = new String("cd " + this.tdir + " ; ");
                    File start_dir = this.findCommonPathAndDelete(files);
                    s = s + cmp.compressCommand(files, new File(start_dir + File.separator + files[0].getName() + "_compressed"));
                    s = s + " ; echo \"JSCH REMOTE COMMAND\"; echo \"COMPRESSION END\"; \n";
                    this.waitString = new String("JSCH REMOTE COMMAND\r\nCOMPRESSION END");
                    this.wp_p = wp;
                    ShellProcessOutput stmp = this.shp;
                    this.setShellProcessOutput(this);
                    this.doing = new String("Compressing on cluster");
                    this.computed = false;
                    this.pinput_out.write(s.getBytes());
                    while (!this.computed) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            ret = false;
                        }
                    }
                    this.setShellProcessOutput(stmp);
                    if (wp != null) {
                        wp.SetProgress(33);
                        wp.SetStatusMessage("Downloading");
                    }
                    this.cSFTP.ls(this.tdir);
                    this.total = 0L;
                    this.cSFTP.get(files[0].getName() + "_compressed", dir.getAbsolutePath() + File.separator + files[0].getName() + "_compressed", (SftpProgressMonitor)this);
                    this.cSFTP.rm(files[0].getName() + "_compressed");
                    if (wp != null) {
                        wp.SetProgress(66);
                        wp.SetStatusMessage("Decompressing Data");
                    }
                    cmp.unCompress(new File(dir.getAbsolutePath() + File.separator + files[0].getName() + "_compressed"), new File(dir.getAbsolutePath()));
                    break;
                }
                catch (SftpException e) {
                    e.printStackTrace();
                    ret = false;
                }
            }
        }
        catch (JSchException e) {
            e.printStackTrace();
            ret = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            ret = false;
        }
        return ret;
    }

    private File findCommonPathAndDelete(File[] f) {
        File common = this.findCommonPath(f);
        int l = common.getAbsolutePath().length() + 1;
        for (int i = 0; i < f.length; ++i) {
            f[i] = new File(f[i].getAbsolutePath().substring(l, f[i].getAbsolutePath().length()));
        }
        return common;
    }

    private File findCommonPath(File[] f) {
        String common = f[0].getAbsolutePath();
        for (int i = 1; i < f.length; ++i) {
            int j;
            int minLength = Math.min(common.length(), f[i].getAbsolutePath().length());
            for (j = 0; j < minLength && common.charAt(j) == f[i].getAbsolutePath().charAt(j); ++j) {
            }
            common = common.substring(0, j);
        }
        common = common.substring(0, common.lastIndexOf("/") + 1);
        return new File(common);
    }

    boolean upload(File[] files, ProgressBarWin wp, ClusterProfile cp) {
        return this.upload(files, null, wp, cp);
    }

    boolean upload(File[] files, File dir, ProgressBarWin wp, ClusterProfile cp) {
        try {
            if (!this.createSftpChannel()) {
                return false;
            }
            DataCompression cmp = new DataCompression();
            if (cp != null) {
                cmp.selectCompressor();
                while (!cp.hasCompressor(cmp.getCompressor())) {
                    cmp.nextCompressor();
                }
            }
            if (this.tdir == null) {
                String ss;
                this.tdir = new String(this.cprof.getRunningDir() + "/");
                this.cSFTP.cd(this.cprof.getRunningDir() + "/");
                this.session_id = ss = "session" + Long.toString(new Date().getTime());
                this.tdir = this.tdir + ss + "/";
                this.cSFTP.mkdir(ss);
                this.cSFTP.cd(ss);
            } else {
                this.cSFTP.cd(this.tdir);
            }
            if (dir != null) {
                this.cSFTP.mkdir(dir.getPath());
                this.cSFTP.cd(dir.getPath());
            }
            if (cmp.getCompressor() == null) {
                for (int i = 0; i < files.length; ++i) {
                    if (wp != null) {
                        wp.SetProgress(100 * i / files.length);
                    }
                    this.cSFTP.put(files[i].getAbsolutePath(), files[i].getName());
                }
            } else {
                wp.SetStatusMessage("Compressing data");
                File start_dir = this.findCommonPathAndDelete(files);
                this.wp_p = wp;
                this.waitString = new String("COMPRESSION END");
                this.doing = new String("Compressing ");
                cmp.Compress(start_dir, files, new File(start_dir + File.separator + files[0].getPath() + "_compressed"), this);
                wp.SetProgress(33);
                wp.SetStatusMessage("Uploading");
                this.cSFTP.put(start_dir + File.separator + files[0].getPath() + "_compressed", files[0].getName() + "_compressed", (SftpProgressMonitor)this);
                wp.SetProgress(66);
                wp.SetStatusMessage("Decompressing Data on cluster");
                if (!this.createSSHChannel()) {
                    return false;
                }
                String s = new String();
                if (dir == null) {
                    s = s + "cd " + this.tdir + " ; ";
                    s = s + cmp.unCompressCommand(new File(this.tdir + files[0].getName() + "_compressed"));
                } else {
                    s = s + "cd " + this.tdir + File.separator + dir.getPath() + File.separator + " ; ";
                    s = s + cmp.unCompressCommand(new File(this.tdir + File.separator + dir.getName() + File.separator + files[0].getName() + "_compressed"));
                }
                s = s + " ; echo \"JSCH REMOTE COMMAND\"; echo \"COMPRESSION END\"; \n";
                this.waitString = new String("JSCH REMOTE COMMAND\r\nCOMPRESSION END");
                this.wp_p = wp;
                ShellProcessOutput stmp = this.shp;
                this.setShellProcessOutput(this);
                this.doing = new String("Decompressing on cluster");
                this.computed = false;
                this.pinput_out.write(s.getBytes());
                while (!this.computed) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.cSFTP.rm(files[0].getName() + "_compressed");
                this.setShellProcessOutput(stmp);
            }
        }
        catch (JSchException e) {
            e.printStackTrace();
            return false;
        }
        catch (SftpException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    String getSession_id() {
        return this.session_id;
    }

    String getTransfertDir() {
        return this.tdir;
    }

    @Override
    public void run() {
        byte[] out = null;
        out = new byte[1025];
        String sout = new String();
        System.out.println("");
        System.out.println("--------------------------- SecureShell output: -----------------------------");
        while (true) {
            try {
                int len = this.poutput_in.available();
                if (len == 0) {
                    this.poutput_in.read(out, 0, 1);
                    if (out[0] != 0) {
                        sout = sout + new String(out, 0, 1, "UTF-8");
                    }
                    System.out.print(new String(out, 0, 1, "UTF-8"));
                } else {
                    for (int i = 0; i < out.length; ++i) {
                        out[i] = 0;
                    }
                    if (len >= out.length - 1) {
                        len = out.length - 1;
                    }
                    this.poutput_in.read(out, 0, len);
                    String tmp = new String(out, 0, len, "UTF-8");
                    System.out.print(tmp);
                    sout = sout + tmp;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("--------------------------- SecureShell output [END] ------------------------");
                return;
            }
            if (this.shp == null) continue;
            sout = this.shp.Process(sout);
        }
    }

    @Override
    public String Process(String str) {
        int lidx;
        int lidx2 = lidx = str.lastIndexOf("\n") - 1;
        String print_out = new String();
        while (lidx >= 0 && str.charAt(lidx) != '\n') {
            --lidx;
        }
        if (lidx >= 0 && lidx2 >= 0) {
            print_out = str.substring(lidx + 1, lidx2);
        }
        if (this.wp_p != null) {
            this.wp_p.SetStatusMessage(this.doing + " " + print_out);
        }
        if (str.contains(this.waitString)) {
            this.computed = true;
            return "";
        }
        return str;
    }

    public boolean count(long arg0) {
        this.total += arg0;
        if (this.wp_p != null) {
            this.wp_p.SetStatusMessage("Transfert... " + this.total);
            this.wp_p.SetProgress((int)(this.total * 100L / this.size_total));
        }
        return true;
    }

    public void end() {
    }

    public void init(int arg0, String arg1, String arg2, long max) {
        this.size_total = max;
    }
}

