/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.detection;

import ij.IJ;
import ij.measure.Calibration;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mosaic.core.detection.Particle;
import mosaic.core.imageUtils.MaskOnSpaceMapper;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.masks.SphereMask;
import mosaic.core.utils.MosaicUtils;
import mosaic.particleTracker.Trajectory;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class MyFrame {
    private Vector<Particle> iParticles;
    public int iFrameNumber;
    private StringBuffer iParticleInfoBeforeDiscrimination;
    private int iRadius = -1;

    public MyFrame(int aFrameNumber) {
        this.iFrameNumber = aFrameNumber;
    }

    public MyFrame(Vector<Particle> aParticles, int aFrameNumber) {
        this.iFrameNumber = aFrameNumber;
        this.iParticles = aParticles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MyFrame(String aTextFilePath) {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(aTextFilePath));
            this.loadParticlesFromFile(r, aTextFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setParticleRadius(int aRadius) {
        this.iRadius = aRadius;
    }

    private StringBuffer getFrameInfoAfterDiscrimination() {
        DecimalFormat nf = new DecimalFormat("#####0.000000");
        nf.setGroupingUsed(false);
        StringBuffer info = new StringBuffer("%\tParticles after non-particle discrimination (");
        info.append(this.iParticles.size());
        info.append(" particles):\n");
        for (int i = 0; i < this.iParticles.size(); ++i) {
            info.append("%\t\t");
            info.append(nf.format(this.iParticles.elementAt((int)i).iX));
            info.append(" ");
            info.append(nf.format(this.iParticles.elementAt((int)i).iY));
            info.append(" ");
            info.append(nf.format(this.iParticles.elementAt((int)i).iZ));
            info.append("\n");
        }
        return info;
    }

    private void generateFrameInfoBeforeDiscrimination() {
        int i;
        DecimalFormat nf = new DecimalFormat("#####0.000000");
        nf.setGroupingUsed(false);
        StringBuffer info = new StringBuffer("% Frame ");
        info.append(this.iFrameNumber);
        info.append(":\n");
        info.append("%\t");
        info.append(this.iParticles.size());
        info.append(" particles found\n");
        info.append("%\tDetected particle positions:\n");
        for (i = 0; i < this.iParticles.size(); ++i) {
            info.append("%\t\t");
            info.append(nf.format(this.iParticles.elementAt((int)i).original_x));
            info.append(" ");
            info.append(nf.format(this.iParticles.elementAt((int)i).original_y));
            info.append(" ");
            info.append(nf.format(this.iParticles.elementAt((int)i).original_z));
            info.append("\n");
        }
        info.append("%\tParticles after position refinement:\n");
        for (i = 0; i < this.iParticles.size(); ++i) {
            info.append("%\t\t");
            info.append(nf.format(this.iParticles.elementAt((int)i).iX));
            info.append(" ");
            info.append(nf.format(this.iParticles.elementAt((int)i).iY));
            info.append(" ");
            info.append(nf.format(this.iParticles.elementAt((int)i).iZ));
            info.append("\n");
        }
        this.iParticleInfoBeforeDiscrimination = info;
    }

    public StringBuffer getFullFrameInfo() {
        StringBuffer info = new StringBuffer();
        info.append(this.iParticleInfoBeforeDiscrimination);
        info.append(this.getFrameInfoAfterDiscrimination());
        return info;
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    public StringBuffer toStringBuffer() {
        DecimalFormat nf = new DecimalFormat("#####0.000000");
        nf.setGroupingUsed(false);
        StringBuffer sb = new StringBuffer("% Frame ");
        sb.append(this.iFrameNumber);
        sb.append("\n");
        for (int j = 0; j < this.iParticles.size(); ++j) {
            sb.append("%\tParticle ");
            sb.append(j);
            sb.append(" (");
            sb.append(nf.format(this.iParticles.elementAt((int)j).iX));
            sb.append(", ");
            sb.append(nf.format(this.iParticles.elementAt((int)j).iY));
            sb.append(", ");
            sb.append(nf.format(this.iParticles.elementAt((int)j).iZ));
            sb.append(")\n");
            if (this.iParticles.elementAt((int)j).next != null) {
                for (int k = 0; k < this.iParticles.elementAt((int)j).next.length; ++k) {
                    sb.append("%\t\tlinked to particle ");
                    sb.append(this.iParticles.elementAt((int)j).next[k]);
                    sb.append(" in frame ");
                    sb.append(this.iFrameNumber + k + 1);
                    sb.append("\n");
                }
                continue;
            }
            sb.append("%\t\thas empty link container\n");
        }
        return sb;
    }

    public Vector<Particle> getParticles() {
        return this.iParticles;
    }

    public StringBuffer frameDetectedParticlesForSave(boolean with_momentum) {
        DecimalFormat nf = new DecimalFormat("#####0.000000");
        nf.setGroupingUsed(false);
        StringBuffer info1 = new StringBuffer("frame ");
        info1.append(this.iFrameNumber);
        info1.append("\n");
        for (int i = 0; i < this.iParticles.size(); ++i) {
            info1.append(nf.format(this.iParticles.elementAt((int)i).iX));
            info1.append(" ");
            info1.append(nf.format(this.iParticles.elementAt((int)i).iY));
            info1.append(" ");
            info1.append(nf.format(this.iParticles.elementAt((int)i).iZ));
            if (with_momentum) {
                info1.append(" ");
                info1.append(nf.format(this.iParticles.elementAt((int)i).m0));
                info1.append(" ");
                info1.append(nf.format(this.iParticles.elementAt((int)i).m2));
            }
            info1.append("\n");
        }
        return info1;
    }

    public void setParticles(Vector<Particle> aParticles) {
        this.iParticles = aParticles;
        for (int i = this.iParticles.size() - 1; i >= 0; --i) {
            this.iParticles.elementAt(i).setFrame(this.iFrameNumber);
        }
        this.generateFrameInfoBeforeDiscrimination();
        this.removeNonParticle();
    }

    private Vector<Particle> removeNonParticle() {
        for (int i = this.iParticles.size() - 1; i >= 0; --i) {
            if (this.iParticles.elementAt((int)i).special) continue;
            this.iParticles.removeElementAt(i);
        }
        return this.iParticles;
    }

    private static float[] getScaling(int dim, Calibration cal) {
        float[] scaling = new float[dim];
        float[] scaling_ = new float[dim];
        if (cal != null) {
            scaling[0] = (float)cal.pixelWidth;
            scaling[1] = (float)cal.pixelHeight;
            if (scaling.length >= 3) {
                scaling[2] = (float)cal.pixelDepth;
            }
        } else {
            scaling[0] = 1.0f;
            scaling[1] = 1.0f;
            if (scaling.length >= 3) {
                scaling[2] = 1.0f;
            }
        }
        float min_s = MyFrame.minScaling(scaling);
        scaling_[0] = scaling[0] / min_s;
        scaling_[1] = scaling[1] / min_s;
        if (scaling.length >= 3) {
            scaling_[2] = scaling[2] / min_s;
        }
        return scaling_;
    }

    private static void drawParticlesWithRadius(RandomAccessibleInterval<ARGBType> out, List<Particle> pt, Calibration cal, float scaling, int col, int aRadius) {
        HashMap<Integer, MaskOnSpaceMapper> CircleCache = new HashMap<Integer, MaskOnSpaceMapper>();
        RandomAccess out_a = out.randomAccess();
        int[] sz = new int[out_a.numDimensions()];
        for (int d = 0; d < out_a.numDimensions(); ++d) {
            sz[d] = (int)out.dimension(d);
        }
        double radius = aRadius;
        float[] scaling_ = MyFrame.getScaling(out_a.numDimensions(), cal);
        int i = 0;
        while (i < scaling_.length) {
            int n = i++;
            scaling_[n] = scaling_[n] / scaling;
        }
        int rc = (int)radius;
        MaskOnSpaceMapper rg_m = null;
        rg_m = (MaskOnSpaceMapper)CircleCache.get(rc);
        if (rg_m == null) {
            SphereMask cm = new SphereMask(rc, (int)((float)(2 * rc) * scaling + 1.0f), scaling_);
            rg_m = new MaskOnSpaceMapper(cm, sz);
            CircleCache.put(rc, rg_m);
        }
        for (Particle ptt : pt) {
            Point p_c = null;
            p_c = out_a.numDimensions() == 2 ? new Point((int)(ptt.iX / scaling_[0]), (int)(ptt.iY / scaling_[1])) : new Point((int)(ptt.iX / scaling_[0]), (int)(ptt.iY / scaling_[1]), (int)(ptt.iZ / scaling_[2]));
            rg_m.setMiddlePoint(p_c);
            while (rg_m.hasNext()) {
                Point p = rg_m.nextPoint();
                if (!p.isInside(sz)) continue;
                out_a.setPosition(p.iCoords);
                ((ARGBType)out_a.get()).set(col);
            }
        }
    }

    private static float minScaling(float[] s) {
        float min = Float.MAX_VALUE;
        for (int i = 0; i < s.length; ++i) {
            if (!(s[i] < min)) continue;
            min = s[i];
        }
        return min;
    }

    private static void drawParticles(RandomAccessibleInterval<ARGBType> out, List<Particle> pt, Calibration cal, float scaling, int col) {
        HashMap<Integer, MaskOnSpaceMapper> CircleCache = new HashMap<Integer, MaskOnSpaceMapper>();
        RandomAccess out_a = out.randomAccess();
        int[] sz = new int[out_a.numDimensions()];
        for (int d = 0; d < out_a.numDimensions(); ++d) {
            sz[d] = (int)out.dimension(d);
        }
        while (pt.size() != 0) {
            double radius = out_a.numDimensions() == 2 ? Math.sqrt((double)pt.get((int)0).m0 / Math.PI) : Math.cbrt((double)pt.get((int)0).m0 * 3.0 / 4.0 / Math.PI);
            if (radius < 1.0) {
                radius = 1.0;
            }
            float[] scaling_ = MyFrame.getScaling(out_a.numDimensions(), cal);
            int i = 0;
            while (i < scaling_.length) {
                int n = i++;
                scaling_[n] = scaling_[n] / scaling;
            }
            MaskOnSpaceMapper rg_m = null;
            int rc = (int)radius;
            rg_m = (MaskOnSpaceMapper)CircleCache.get(rc);
            if (rg_m == null) {
                if (rc < 1) {
                    rc = 1;
                }
                SphereMask cm = new SphereMask(rc, (int)((float)(2 * rc) * scaling + 1.0f), scaling_);
                rg_m = new MaskOnSpaceMapper(cm, sz);
                CircleCache.put(rc, rg_m);
            }
            Iterator<Particle> pt_it = pt.iterator();
            while (pt_it.hasNext()) {
                Particle ptt = pt_it.next();
                double radius_r = out_a.numDimensions() == 2 ? Math.sqrt((double)pt.get((int)0).m0 / Math.PI) : Math.cbrt((double)pt.get((int)0).m0 * 3.0 / 4.0 / Math.PI);
                if (radius_r <= 1.0) {
                    radius_r = 1.0;
                }
                if (radius_r != radius) continue;
                Point p_c = null;
                p_c = out_a.numDimensions() == 2 ? new Point((int)(ptt.iX / scaling_[0]), (int)(ptt.iY / scaling_[1])) : new Point((int)(ptt.iX / scaling_[0]), (int)(ptt.iY / scaling_[1]), (int)(ptt.iZ / scaling_[2]));
                rg_m.setMiddlePoint(p_c);
                while (rg_m.hasNext()) {
                    Point p = rg_m.nextPoint();
                    if (!p.isInside(sz)) continue;
                    out_a.setPosition(p.iCoords);
                    ((ARGBType)out_a.get()).set(col);
                }
                pt_it.remove();
            }
        }
    }

    private static void drawLine(RandomAccessibleInterval<ARGBType> out, Particle p1, Particle p2, int col) {
        int k;
        boolean out_pix;
        int i;
        int err_2;
        int err_1;
        long[] dims = new long[out.numDimensions()];
        out.dimensions(dims);
        RandomAccess out_a = out.randomAccess();
        long[] pixel = new long[]{(int)p1.iX, (int)p1.iY, (int)p1.iZ};
        int dx = (int)(p2.iX - p1.iX);
        int dy = (int)(p2.iY - p1.iY);
        int dz = (int)(p2.iZ - p1.iZ);
        int x_inc = dx < 0 ? -1 : 1;
        int l = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int m = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int n = Math.abs(dz);
        int dx2 = l << 1;
        int dy2 = m << 1;
        int dz2 = n << 1;
        if (l >= m && l >= n) {
            err_1 = dy2 - l;
            err_2 = dz2 - l;
            for (i = 0; i < l; ++i) {
                out_pix = false;
                for (k = 0; k < out_a.numDimensions(); ++k) {
                    if (pixel[k] < dims[k]) continue;
                    out_pix = true;
                    break;
                }
                if (out_pix) continue;
                out_a.setPosition(pixel);
                ((ARGBType)out_a.get()).set(col);
                if (err_1 > 0) {
                    pixel[1] = pixel[1] + (long)y_inc;
                    err_1 -= dx2;
                }
                if (err_2 > 0) {
                    pixel[2] = pixel[2] + (long)z_inc;
                    err_2 -= dx2;
                }
                err_1 += dy2;
                err_2 += dz2;
                pixel[0] = pixel[0] + (long)x_inc;
            }
        } else if (m >= l && m >= n) {
            err_1 = dx2 - m;
            err_2 = dz2 - m;
            for (i = 0; i < m; ++i) {
                out_pix = false;
                for (k = 0; k < out_a.numDimensions(); ++k) {
                    if (pixel[k] < dims[k]) continue;
                    out_pix = true;
                    break;
                }
                if (out_pix) continue;
                out_a.setPosition(pixel);
                ((ARGBType)out_a.get()).set(col);
                if (err_1 > 0) {
                    pixel[0] = pixel[0] + (long)x_inc;
                    err_1 -= dy2;
                }
                if (err_2 > 0) {
                    pixel[2] = pixel[2] + (long)z_inc;
                    err_2 -= dy2;
                }
                err_1 += dx2;
                err_2 += dz2;
                pixel[1] = pixel[1] + (long)y_inc;
            }
        } else {
            err_1 = dy2 - n;
            err_2 = dx2 - n;
            for (i = 0; i < n; ++i) {
                out_pix = false;
                for (k = 0; k < out_a.numDimensions(); ++k) {
                    if (pixel[k] < dims[k]) continue;
                    out_pix = true;
                    break;
                }
                if (out_pix) continue;
                out_a.setPosition(pixel);
                ((ARGBType)out_a.get()).set(col);
                if (err_1 > 0) {
                    pixel[1] = pixel[1] + (long)y_inc;
                    err_1 -= dz2;
                }
                if (err_2 > 0) {
                    pixel[0] = pixel[0] + (long)x_inc;
                    err_2 -= dz2;
                }
                err_1 += dy2;
                err_2 += dx2;
                pixel[2] = pixel[2] + (long)z_inc;
            }
        }
        out_pix = false;
        for (k = 0; k < out_a.numDimensions(); ++k) {
            if (pixel[k] < dims[k]) continue;
            out_pix = true;
            break;
        }
        if (!out_pix) {
            out_a.setPosition(pixel);
            ((ARGBType)out_a.get()).set(col);
        }
    }

    private static void drawLines(RandomAccessibleInterval<ARGBType> out, List<pParticle> lines, Calibration cal, float scale, int col) {
        if (cal == null) {
            cal = new Calibration();
            cal.pixelDepth = 1.0;
            cal.pixelHeight = 1.0;
            cal.pixelWidth = 1.0;
        }
        RandomAccess out_a = out.randomAccess();
        int[] sz = new int[out_a.numDimensions()];
        for (int d = 0; d < out_a.numDimensions(); ++d) {
            sz[d] = (int)out.dimension(d);
        }
        for (pParticle ptt : lines) {
            Particle p_end = new Particle(ptt.p1);
            Particle p_ini = new Particle(ptt.p2);
            float[] scaling = new float[out_a.numDimensions()];
            float[] scaling_ = MyFrame.getScaling(out_a.numDimensions(), cal);
            int i = 0;
            while (i < scaling.length) {
                int n = i++;
                scaling_[n] = scaling_[n] / scale;
            }
            p_ini.iX /= scaling_[0];
            p_ini.iY /= scaling_[1];
            if (out_a.numDimensions() > 2) {
                p_ini.iZ /= scaling_[2];
            }
            p_end.iX /= scaling_[0];
            p_end.iY /= scaling_[1];
            if (out_a.numDimensions() > 2) {
                p_end.iZ /= scaling_[2];
            }
            MyFrame.drawLine(out, p_ini, p_end, col);
            double radius = Math.cbrt(ptt.p1.m0 / 3.0f * 4.0f);
            int rc = (int)radius;
            for (int i2 = 1; i2 <= rc; ++i2) {
                if (ptt.p1.iZ / (float)cal.pixelDepth - (float)i2 >= 0.0f && ptt.p2.iZ / (float)cal.pixelDepth - (float)i2 >= 0.0f) {
                    p_end = new Particle(ptt.p1);
                    p_ini = new Particle(ptt.p2);
                    p_ini.iX /= scaling_[0];
                    p_ini.iY /= scaling_[1];
                    if (out_a.numDimensions() > 2) {
                        p_ini.iZ = p_ini.iZ / scaling[2] - (float)i2;
                    }
                    p_end.iX /= scaling_[0];
                    p_end.iY /= scaling_[1];
                    if (out_a.numDimensions() > 2) {
                        p_end.iZ = p_end.iZ / scaling_[2] - (float)i2;
                    }
                    MyFrame.drawLine(out, p_ini, p_end, col);
                }
                if (!(ptt.p2.iX / (float)cal.pixelDepth + (float)i2 < (float)out.dimension(out.numDimensions() - 1)) || !(ptt.p1.iZ / (float)cal.pixelDepth + (float)i2 < (float)out.dimension(out.numDimensions() - 1))) continue;
                p_end = new Particle(ptt.p1);
                p_ini = new Particle(ptt.p2);
                p_ini.iX /= scaling_[0];
                p_ini.iY /= scaling_[1];
                if (out_a.numDimensions() > 2) {
                    p_ini.iZ = p_ini.iZ / scaling_[2] + (float)i2;
                }
                p_end.iX /= scaling_[0];
                p_end.iY /= scaling_[1];
                if (out_a.numDimensions() > 2) {
                    p_end.iZ = p_end.iZ / scaling_[2] + (float)i2;
                }
                MyFrame.drawLine(out, p_ini, p_end, col);
            }
        }
    }

    private void drawParticles(Img<ARGBType> out, Calibration cal, float scale, int col) {
        ArrayList<Particle> pt = new ArrayList<Particle>();
        for (int i = 0; i < this.iParticles.size(); ++i) {
            pt.add(this.iParticles.get(i));
        }
        if (this.iRadius == -1) {
            MyFrame.drawParticles(out, pt, cal, scale, col);
        } else {
            MyFrame.drawParticlesWithRadius(out, pt, cal, scale, col, this.iRadius);
        }
    }

    public <T extends RealType<T>> Img<ARGBType> createImage(Img<T> background, Calibration cal) {
        try {
            background.firstElement();
        }
        catch (ClassCastException e) {
            IJ.error((String)"Error unsupported format, please convert your image into 8-bit, 16-bit or float");
            return null;
        }
        int numDimensions = background.numDimensions();
        long[] dims = new long[numDimensions];
        background.dimensions(dims);
        ArrayImgFactory imgFactory = new ArrayImgFactory();
        Img out = imgFactory.create(dims, (Object)new ARGBType());
        Cursor curOut = out.cursor();
        Cursor curBack = background.cursor();
        MosaicUtils.ToARGB conv = null;
        try {
            conv = MosaicUtils.getConversion(curBack.get(), background.cursor());
        }
        catch (ClassCastException e) {
            IJ.error((String)"Error unsupported format, please convert your image into 8-bit, 16-bit or float");
            return null;
        }
        while (curBack.hasNext()) {
            curOut.fwd();
            curBack.fwd();
            ((ARGBType)curOut.get()).set(conv.toARGB(curBack.get()));
        }
        this.drawParticles((Img<ARGBType>)out, cal, 1.0f, ARGBType.rgba((int)255, (int)0, (int)0, (int)255));
        return out;
    }

    private static void TrajectoriesDraw(RandomAccessibleInterval<ARGBType> out, int nframe, Vector<Trajectory> tr, int start_frame, Rectangle focus, Calibration cal_, float scaling, DrawType typ, int aRadius) {
        Vector<Particle> vp = new Vector<Particle>();
        Vector<pParticle> lines = new Vector<pParticle>();
        Vector<pParticle> lines_jmp = new Vector<pParticle>();
        for (int frame = 0; frame < nframe; ++frame) {
            for (int t = 0; t < tr.size(); ++t) {
                if (!tr.get(t).toDisplay()) continue;
                if (!tr.get(t).drawParticle()) {
                    aRadius = 0;
                }
                vp.clear();
                lines.clear();
                lines_jmp.clear();
                if (frame + start_frame >= tr.get(t).getStartFrame() && frame + start_frame <= tr.get(t).getStopFrame()) {
                    int i;
                    int j = 0;
                    for (j = 0; j < tr.get((int)t).iParticles.length && (tr.get((int)t).iParticles[j].getFrame() > frame + start_frame || j + 1 < tr.get((int)t).iParticles.length && tr.get((int)t).iParticles[j + 1].getFrame() <= frame + start_frame); ++j) {
                    }
                    Particle p = new Particle(tr.get((int)t).iParticles[j]);
                    if (focus != null) {
                        p.translate(focus);
                    }
                    vp.add(p);
                    if (typ == DrawType.NEXT) {
                        if (j + 1 < tr.get((int)t).iParticles.length) {
                            MyFrame.crateNewLine(tr, focus, lines, lines_jmp, t, j);
                        }
                    } else if (typ == DrawType.PREV) {
                        if (j - 1 >= 0) {
                            MyFrame.createNewLine2(tr, focus, lines, lines_jmp, t, j);
                        }
                    } else if (typ == DrawType.PREV_NEXT) {
                        if (j + 1 < tr.get((int)t).iParticles.length) {
                            MyFrame.crateNewLine(tr, focus, lines, lines_jmp, t, j);
                        }
                        if (j - 1 >= 0) {
                            MyFrame.createNewLine2(tr, focus, lines, lines_jmp, t, j);
                        }
                    } else if (typ == DrawType.TRAJECTORY_HISTORY) {
                        for (i = j; i >= 1; --i) {
                            MyFrame.createNewLine3(tr, focus, lines, lines_jmp, t, i);
                        }
                    } else if (typ == DrawType.TRAJECTORY_HISTORY_WITH_NEXT) {
                        for (i = j + 1; i >= 1; --i) {
                            MyFrame.createNewLine3(tr, focus, lines, lines_jmp, t, i);
                        }
                        if (j + 1 < tr.get((int)t).iParticles.length) {
                            MyFrame.crateNewLine(tr, focus, lines, lines_jmp, t, j);
                        }
                    }
                }
                IntervalView view = null;
                view = nframe != 1 ? Views.hyperSlice(out, (int)(out.numDimensions() - 1), (long)frame) : out;
                if (aRadius == -1) {
                    MyFrame.drawParticles((RandomAccessibleInterval<ARGBType>)view, vp, cal_, scaling, ARGBType.rgba((int)tr.get((int)t).color.getRed(), (int)tr.get((int)t).color.getGreen(), (int)tr.get((int)t).color.getBlue(), (int)tr.get((int)t).color.getTransparency()));
                } else {
                    MyFrame.drawParticlesWithRadius((RandomAccessibleInterval<ARGBType>)view, vp, cal_, scaling, ARGBType.rgba((int)tr.get((int)t).color.getRed(), (int)tr.get((int)t).color.getGreen(), (int)tr.get((int)t).color.getBlue(), (int)tr.get((int)t).color.getTransparency()), aRadius);
                }
                MyFrame.drawLines((RandomAccessibleInterval<ARGBType>)view, lines, cal_, scaling, ARGBType.rgba((int)tr.get((int)t).color.getRed(), (int)tr.get((int)t).color.getGreen(), (int)tr.get((int)t).color.getBlue(), (int)tr.get((int)t).color.getTransparency()));
                MyFrame.drawLines((RandomAccessibleInterval<ARGBType>)view, lines_jmp, cal_, scaling, ARGBType.rgba((double)255.0, (double)0.0, (double)0.0, (double)0.0));
            }
        }
    }

    private static void createNewLine3(Vector<Trajectory> tr, Rectangle focus, Vector<pParticle> lines, Vector<pParticle> lines_jmp, int t, int j) {
        boolean jump;
        pParticle l1 = new pParticle(new Particle(tr.get((int)t).iParticles[j]), new Particle(tr.get((int)t).iParticles[j - 1]));
        if (focus != null) {
            l1.translate(focus);
        }
        boolean bl = jump = tr.get((int)t).iParticles[j].getFrame() - tr.get((int)t).iParticles[j - 1].getFrame() != 1;
        if (!jump) {
            lines.add(l1);
        } else {
            lines_jmp.add(l1);
        }
    }

    private static void createNewLine2(Vector<Trajectory> tr, Rectangle focus, Vector<pParticle> lines, Vector<pParticle> lines_jmp, int t, int j) {
        boolean jump;
        pParticle l1 = new pParticle(new Particle(tr.get((int)t).iParticles[j]), new Particle(tr.get((int)t).iParticles[j + 1]));
        if (focus != null) {
            l1.translate(focus);
        }
        boolean bl = jump = tr.get((int)t).iParticles[j].getFrame() - tr.get((int)t).iParticles[j - 1].getFrame() != 1;
        if (!jump) {
            lines.add(l1);
        } else {
            lines_jmp.add(l1);
        }
    }

    private static void crateNewLine(Vector<Trajectory> tr, Rectangle focus, Vector<pParticle> lines, Vector<pParticle> lines_jmp, int t, int j) {
        boolean jump;
        pParticle l1 = new pParticle(new Particle(tr.get((int)t).iParticles[j]), new Particle(tr.get((int)t).iParticles[j + 1]));
        if (focus != null) {
            l1.translate(focus);
        }
        boolean bl = jump = tr.get((int)t).iParticles[j + 1].getFrame() - tr.get((int)t).iParticles[j].getFrame() != 1;
        if (!jump) {
            lines.add(l1);
        } else {
            lines_jmp.add(l1);
        }
    }

    public static void updateImage(RandomAccessibleInterval<ARGBType> out, Rectangle focus, int start_frame, Vector<Trajectory> tr, Calibration cal, DrawType typ, int aRadius) {
        int scale_x = (int)(out.dimension(0) / (long)focus.width);
        int nframe = (int)out.dimension(out.numDimensions() - 1);
        MyFrame.TrajectoriesDraw(out, nframe, tr, start_frame, focus, cal, scale_x, typ, aRadius);
    }

    public static void updateImage(Img<ARGBType> out, Vector<Trajectory> tr, Calibration cal, DrawType typ, int p_radius) {
        for (int i = 0; i < tr.size(); ++i) {
            int nframe = (int)out.dimension(out.numDimensions() - 1);
            MyFrame.TrajectoriesDraw(out, nframe, tr, 0, null, cal, 1.0f, typ, p_radius);
        }
    }

    public <T extends RealType<T>> Img<ARGBType> createImage(Img<T> background, Vector<Trajectory> tr, Calibration cal, int frame, DrawType typ) {
        if (tr == null) {
            return this.createImage(background, cal);
        }
        int numDimensions = background.numDimensions();
        long[] dims = new long[numDimensions];
        background.dimensions(dims);
        ArrayImgFactory imgFactory = new ArrayImgFactory();
        Img out = imgFactory.create(dims, (Object)new ARGBType());
        Cursor curOut = out.cursor();
        Cursor curBack = background.cursor();
        MosaicUtils.ToARGB conv = null;
        try {
            conv = MosaicUtils.getConversion(curBack.get(), background.cursor());
        }
        catch (ClassCastException e) {
            IJ.error((String)"Error unsupported format, please convert your image into 8-bit, 16-bit or float");
            return null;
        }
        while (curBack.hasNext()) {
            curOut.fwd();
            curBack.fwd();
            ((ARGBType)curOut.get()).set(conv.toARGB(curBack.get()));
        }
        MyFrame.TrajectoriesDraw((RandomAccessibleInterval<ARGBType>)out, 1, tr, frame, null, cal, 1.0f, typ, this.iRadius);
        return out;
    }

    public Img<ARGBType> createImage(int[] aImgDimensions, Vector<Trajectory> aTrajectories, int aFrameNumber, DrawType aType) {
        Img out = new ArrayImgFactory().create(aImgDimensions, (Object)new ARGBType());
        if (aTrajectories == null) {
            this.drawParticles((Img<ARGBType>)out, null, 1.0f, ARGBType.rgba((int)255, (int)0, (int)0, (int)255));
        } else {
            MyFrame.TrajectoriesDraw((RandomAccessibleInterval<ARGBType>)out, 1, aTrajectories, aFrameNumber, null, null, 1.0f, aType, this.iRadius);
        }
        return out;
    }

    public void removeDuplicatedParticles() {
        block0: for (int i = this.iParticles.size() - 1; i > 0; --i) {
            for (int j = i - 1; j >= 0; --j) {
                if (!this.iParticles.get(i).match(this.iParticles.get(j))) continue;
                this.iParticles.remove(i);
                continue block0;
            }
        }
    }

    private boolean loadParticlesFromFile(BufferedReader aInputStream, String aInputInfo) throws IOException {
        String line = aInputStream.readLine();
        if ((line = line.trim()) == null || !line.startsWith("frame")) {
            IJ.error((String)("File [" + aInputInfo + "] doesn't have the string 'frame' in the begining of the first line!"));
            return false;
        }
        String[] frameNumberInfo = line.split("\\s+");
        if (frameNumberInfo.length < 2 || frameNumberInfo[1] == null) {
            IJ.error((String)("Malformed line, expacting \"frame x\", founded [" + line + "]"));
            return false;
        }
        this.iFrameNumber = Integer.parseInt(frameNumberInfo[1]);
        Vector<String[]> particlesInfo = new Vector<String[]>();
        while ((line = aInputStream.readLine()) != null) {
            if ((line = line.trim()).startsWith("%")) {
                line = line.substring(1);
            }
            line = line.trim();
            particlesInfo.addElement(line.split("\\s+"));
        }
        this.iParticles = new Vector();
        for (String[] pInfo : particlesInfo) {
            if (pInfo.length < 2) {
                IJ.error((String)("Malformed line, expacting 2 floats but got " + pInfo.length));
                return false;
            }
            float x = Float.parseFloat(pInfo[0]);
            float y = Float.parseFloat(pInfo[1]);
            float z = pInfo.length == 2 ? 0.0f : Float.parseFloat(pInfo[2]);
            Particle p = new Particle(x, y, z, this.iFrameNumber);
            if (pInfo.length >= 8 && pInfo[3] != null && pInfo[4] != null && pInfo[5] != null && pInfo[6] != null && pInfo[7] != null) {
                p.m0 = Float.parseFloat(pInfo[3]);
                p.m1 = Float.parseFloat(pInfo[4]);
                p.m2 = Float.parseFloat(pInfo[5]);
                p.m3 = Float.parseFloat(pInfo[6]);
                p.m4 = Float.parseFloat(pInfo[7]);
            }
            this.iParticles.add(p);
        }
        return true;
    }

    public static enum DrawType {
        TRAJECTORY_HISTORY,
        PREV,
        NEXT,
        PREV_NEXT,
        TRAJECTORY_HISTORY_WITH_NEXT;

    }

    private static class pParticle {
        Particle p1;
        Particle p2;

        pParticle(Particle p1, Particle p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        void translate(Rectangle focus) {
            this.p1.translate(focus);
            this.p2.translate(focus);
        }
    }
}

