/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.detection;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import mosaic.core.detection.MyFrame;
import mosaic.core.detection.Particle;

public class PreviewCanvas
extends ImageCanvas {
    private static final long serialVersionUID = 1L;
    private MyFrame preview_frame = null;
    private int magnificationFactor = 1;
    private int preview_slice_calculated;
    private int radius;

    PreviewCanvas(ImagePlus aimp, double mag) {
        super(aimp);
        this.magnificationFactor = (int)mag;
    }

    public void setPreviewFrame(MyFrame aPreviewFrame) {
        this.preview_frame = aPreviewFrame;
    }

    public void setPreviewParticleRadius(int radius) {
        this.radius = radius;
    }

    public void setPreviewSliceCalculated(int slice_calculated) {
        this.preview_slice_calculated = slice_calculated;
    }

    public void paint(Graphics g) {
        super.paint(g);
        int frameToDisplay = this.getFrameNumberFromSlice(this.imp.getCurrentSlice());
        Vector<Particle> particlesToDisplay = null;
        if (frameToDisplay == this.getFrameNumberFromSlice(this.preview_slice_calculated)) {
            g.setColor(Color.red);
            if (this.preview_frame != null) {
                particlesToDisplay = this.preview_frame.getParticles();
                this.circleParticles(g, particlesToDisplay);
            }
        }
    }

    private void circleParticles(Graphics g, Vector<Particle> particlesToDisplay) {
        if (particlesToDisplay == null || g == null) {
            return;
        }
        int c_slice = this.imp.getCurrentSlice() % this.imp.getNSlices();
        this.magnificationFactor = (int)Math.round(this.imp.getWindow().getCanvas().getMagnification());
        for (int i = 0; i < particlesToDisplay.size(); ++i) {
            double z = particlesToDisplay.elementAt((int)i).iZ + 1.0f;
            if (!(z <= (double)(c_slice + 1)) || !(z >= (double)(c_slice - 1))) continue;
            g.drawOval(this.screenXD(particlesToDisplay.elementAt((int)i).iY), this.screenYD(particlesToDisplay.elementAt((int)i).iX), 0, 0);
            g.drawOval(this.screenXD((double)particlesToDisplay.elementAt((int)i).iY - (double)this.radius / 1.0), this.screenYD((double)particlesToDisplay.elementAt((int)i).iX - (double)this.radius / 1.0), 2 * this.radius * this.magnificationFactor - 1, 2 * this.radius * this.magnificationFactor - 1);
        }
    }

    private int getFrameNumberFromSlice(int sliceIndex) {
        return (sliceIndex - 1) / this.imp.getNSlices() + 1;
    }
}

