/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils.convolution;

import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mosaic.core.imageUtils.convolution.Kernel1D;
import mosaic.core.imageUtils.convolution.Kernel2D;
import mosaic.core.imageUtils.convolution.Kernel3D;
import mosaic.core.imageUtils.images.IntensityImage;

public class Convolver {
    private double[][][] iData;
    private int iDepth;
    private int iHeight;
    private int iWidth;

    public Convolver(int aWidth, int aHeight, int aDepth) {
        this.iWidth = aWidth;
        this.iHeight = aHeight;
        this.iDepth = aDepth;
        this.iData = new double[this.iDepth][this.iHeight][this.iWidth];
    }

    public Convolver(double[][][] aData) {
        this(aData[0][0].length, aData[0].length, aData.length);
        this.copyData(aData);
    }

    public Convolver(double[][] aData) {
        this(new double[][][]{aData});
    }

    public Convolver(Convolver aConvolver) {
        this(aConvolver.iData);
    }

    private void copyData(double[][][] aData) {
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    this.iData[z][y][x] = aData[z][y][x];
                }
            }
        }
    }

    public ImageStack getImageStack() {
        ImageStack is = new ImageStack(this.iWidth, this.iHeight);
        for (int z = 0; z < this.iDepth; ++z) {
            FloatProcessor fp = new FloatProcessor(this.iWidth, this.iHeight);
            float[] p = (float[])fp.getPixels();
            int offset = 0;
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    p[offset++] = (float)this.iData[z][y][x];
                }
            }
            is.addSlice("slice" + z, (ImageProcessor)fp);
        }
        return is;
    }

    public void initFromImageStack(ImageStack aStack) {
        for (int z = 0; z < aStack.getSize(); ++z) {
            float[] p = (float[])aStack.getPixels(z + 1);
            int offset = 0;
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    this.iData[z][y][x] = p[offset++];
                }
            }
        }
    }

    public void getIntensityImage(IntensityImage aImg) {
        float[] p = aImg.getDataIntensity();
        for (int z = 0; z < aImg.getDepth(); ++z) {
            int offset = 0;
            int sliceOffset = z * this.iHeight * this.iWidth;
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    p[sliceOffset + offset++] = (float)this.iData[z][y][x];
                }
            }
        }
    }

    public void initFromIntensityImage(IntensityImage aImg) {
        float[] p = aImg.getDataIntensity();
        for (int z = 0; z < aImg.getDepth(); ++z) {
            int offset = 0;
            int sliceOffset = z * this.iHeight * this.iWidth;
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    this.iData[z][y][x] = p[sliceOffset + offset++];
                }
            }
        }
    }

    public Convolver add(Convolver aConvolver) {
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    double[] dArray = this.iData[z][y];
                    int n = x;
                    dArray[n] = dArray[n] + aConvolver.iData[z][y][x];
                }
            }
        }
        return this;
    }

    public Convolver sub(Convolver aConvolver) {
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    double[] dArray = this.iData[z][y];
                    int n = x;
                    dArray[n] = dArray[n] - aConvolver.iData[z][y][x];
                }
            }
        }
        return this;
    }

    public Convolver mul(Convolver aConvolver) {
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    double[] dArray = this.iData[z][y];
                    int n = x;
                    dArray[n] = dArray[n] * aConvolver.iData[z][y][x];
                }
            }
        }
        return this;
    }

    public Convolver div(Convolver aConvolver) {
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    double[] dArray = this.iData[z][y];
                    int n = x;
                    dArray[n] = dArray[n] / aConvolver.iData[z][y][x];
                }
            }
        }
        return this;
    }

    public Convolver mul(double aConst) {
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                int x = 0;
                while (x < this.iWidth) {
                    double[] dArray = this.iData[z][y];
                    int n = x++;
                    dArray[n] = dArray[n] * aConst;
                }
            }
        }
        return this;
    }

    public Convolver sqrt() {
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    this.iData[z][y][x] = Math.sqrt(this.iData[z][y][x]);
                }
            }
        }
        return this;
    }

    public Convolver pow(double aPower) {
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    this.iData[z][y][x] = Math.pow(this.iData[z][y][x], aPower);
                }
            }
        }
        return this;
    }

    public Convolver div(double aConst) {
        this.mul(1.0 / aConst);
        return this;
    }

    public void x1D(Kernel1D aKernel) {
        this.x1D(new Convolver(this), aKernel);
    }

    public void y1D(Kernel1D aKernel) {
        this.y1D(new Convolver(this), aKernel);
    }

    public void z1D(Kernel1D aKernel) {
        this.z1D(new Convolver(this), aKernel);
    }

    public void xy2D(Kernel2D aKernel) {
        this.xy2D(new Convolver(this), aKernel);
    }

    public void xyz3D(Kernel3D aKernel) {
        this.xyz3D(new Convolver(this), aKernel);
    }

    public void sobel2D() {
        this.sobel2D(new Convolver(this));
    }

    public void sobel3D() {
        this.sobel3D(new Convolver(this));
    }

    public void x1D(Convolver aSrcConv, Kernel1D aKernel) {
        int hw2 = aKernel.iHalfWidth;
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    this.iData[z][y][x] = 0.0;
                    for (int k = -hw2; k <= hw2; ++k) {
                        int xc = x + k;
                        if (xc < 0) {
                            xc = 0;
                        } else if (xc >= this.iWidth) {
                            xc = this.iWidth - 1;
                        }
                        double[] dArray = this.iData[z][y];
                        int n = x;
                        dArray[n] = dArray[n] + aSrcConv.iData[z][y][xc] * aKernel.k[k + hw2];
                    }
                }
            }
        }
    }

    public void y1D(Convolver aSrcConv, Kernel1D aKernel) {
        int hw2 = aKernel.iHalfWidth;
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    this.iData[z][y][x] = 0.0;
                    for (int k = -hw2; k <= hw2; ++k) {
                        int yc = y + k;
                        if (yc < 0) {
                            yc = 0;
                        } else if (yc >= this.iHeight) {
                            yc = this.iHeight - 1;
                        }
                        double[] dArray = this.iData[z][y];
                        int n = x;
                        dArray[n] = dArray[n] + aSrcConv.iData[z][yc][x] * aKernel.k[k + hw2];
                    }
                }
            }
        }
    }

    public void z1D(Convolver aSrcConv, Kernel1D aKernel) {
        int hw2 = aKernel.iHalfWidth;
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    this.iData[z][y][x] = 0.0;
                    for (int k = -hw2; k <= hw2; ++k) {
                        int zc = z + k;
                        if (zc < 0) {
                            zc = 0;
                        } else if (zc >= this.iDepth) {
                            zc = this.iDepth - 1;
                        }
                        double[] dArray = this.iData[z][y];
                        int n = x;
                        dArray[n] = dArray[n] + aSrcConv.iData[zc][y][x] * aKernel.k[k + hw2];
                    }
                }
            }
        }
    }

    public void xy2D(Convolver aSrcConv, Kernel2D aKernel) {
        int hw2 = aKernel.iHalfWidth;
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    this.iData[z][y][x] = 0.0;
                    for (int m = -hw2; m <= hw2; ++m) {
                        int yc = y + m;
                        if (yc < 0) {
                            yc = 0;
                        } else if (yc >= this.iHeight) {
                            yc = this.iHeight - 1;
                        }
                        for (int k = -hw2; k <= hw2; ++k) {
                            int xc = x + k;
                            if (xc < 0) {
                                xc = 0;
                            } else if (xc >= this.iWidth) {
                                xc = this.iWidth - 1;
                            }
                            double[] dArray = this.iData[z][y];
                            int n = x;
                            dArray[n] = dArray[n] + aSrcConv.iData[z][yc][xc] * aKernel.k[m + hw2][k + hw2];
                        }
                    }
                }
            }
        }
    }

    public void xyz3D(Convolver aSrcConv, Kernel3D aKernel) {
        int hw2 = aKernel.iHalfWidth;
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    this.iData[z][y][x] = 0.0;
                    for (int n = -hw2; n <= hw2; ++n) {
                        int zc = z + n;
                        if (zc < 0) {
                            zc = 0;
                        } else if (zc >= this.iDepth) {
                            zc = this.iDepth - 1;
                        }
                        for (int m = -hw2; m <= hw2; ++m) {
                            int yc = y + m;
                            if (yc < 0) {
                                yc = 0;
                            } else if (yc >= this.iHeight) {
                                yc = this.iHeight - 1;
                            }
                            for (int k = -hw2; k <= hw2; ++k) {
                                int xc = x + k;
                                if (xc < 0) {
                                    xc = 0;
                                } else if (xc >= this.iWidth) {
                                    xc = this.iWidth - 1;
                                }
                                double[] dArray = this.iData[z][y];
                                int n2 = x;
                                dArray[n2] = dArray[n2] + aSrcConv.iData[zc][yc][xc] * aKernel.k[n + hw2][m + hw2][k + hw2];
                            }
                        }
                    }
                }
            }
        }
    }

    public int getWidth() {
        return this.iWidth;
    }

    public int getHeight() {
        return this.iHeight;
    }

    public int getDepth() {
        return this.iDepth;
    }

    public double[][][] getData() {
        return this.iData;
    }

    public void sobel2D(Convolver aSrcConv) {
        Kernel2D aKernel = new Kernel2D(){
            {
                int width = 3;
                this.iHalfWidth = width / 2;
                this.k = new double[3][3];
                this.k[0][0] = -0.1111111111111111;
                this.k[0][1] = 0.0;
                this.k[0][2] = 0.1111111111111111;
                this.k[1][0] = -0.2222222222222222;
                this.k[1][1] = 0.0;
                this.k[1][2] = 0.2222222222222222;
                this.k[2][0] = -0.1111111111111111;
                this.k[2][1] = 0.0;
                this.k[2][2] = 0.1111111111111111;
            }
        };
        double[][][] volume = aSrcConv.iData;
        double[][] kernel = aKernel.k;
        int kw = aKernel.iHalfWidth;
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    if (x >= kw && y >= kw && x < this.iWidth - kw && y < this.iHeight - kw) {
                        double dx = 0.0;
                        double dy = 0.0;
                        for (int l = -kw; l <= kw; ++l) {
                            int kx = l + kw;
                            int vy = y + l;
                            for (int k = -kw; k <= kw; ++k) {
                                int ky = k + kw;
                                int vx = x + k;
                                double val = volume[z][vy][vx];
                                dx += val * kernel[kx][ky];
                                dy += val * kernel[ky][kx];
                            }
                        }
                        this.iData[z][y][x] = (float)Math.sqrt(dx * dx + dy * dy);
                        continue;
                    }
                    this.iData[z][y][x] = 0.0;
                }
            }
        }
    }

    public void sobel3D(Convolver aSrcConv) {
        Kernel3D aKernel = new Kernel3D(){
            {
                int width = 3;
                this.iHalfWidth = width / 2;
                this.k = new double[3][3][3];
                this.k[0][0][0] = -0.07407407407407407;
                this.k[0][0][1] = 0.0;
                this.k[0][0][2] = 0.07407407407407407;
                this.k[0][1][0] = -0.1111111111111111;
                this.k[0][1][1] = 0.0;
                this.k[0][1][2] = 0.1111111111111111;
                this.k[0][2][0] = -0.07407407407407407;
                this.k[0][2][1] = 0.0;
                this.k[0][2][2] = 0.07407407407407407;
                this.k[1][0][0] = -0.1111111111111111;
                this.k[1][0][1] = 0.0;
                this.k[1][0][2] = 0.1111111111111111;
                this.k[1][1][0] = -0.2222222222222222;
                this.k[1][1][1] = 0.0;
                this.k[1][1][2] = 0.2222222222222222;
                this.k[1][2][0] = -0.1111111111111111;
                this.k[1][2][1] = 0.0;
                this.k[1][2][2] = 0.1111111111111111;
                this.k[2][0][0] = -0.07407407407407407;
                this.k[2][0][1] = 0.0;
                this.k[2][0][2] = 0.07407407407407407;
                this.k[2][1][0] = -0.1111111111111111;
                this.k[2][1][1] = 0.0;
                this.k[2][1][2] = 0.1111111111111111;
                this.k[2][2][0] = -0.07407407407407407;
                this.k[2][2][1] = 0.0;
                this.k[2][2][2] = 0.07407407407407407;
            }
        };
        double[][][] volume = aSrcConv.iData;
        double[][][] kernel = aKernel.k;
        int kernelWidth = aKernel.iHalfWidth;
        for (int z = 0; z < this.iDepth; ++z) {
            for (int y = 0; y < this.iHeight; ++y) {
                for (int x = 0; x < this.iWidth; ++x) {
                    if (x >= kernelWidth && y >= kernelWidth && z >= kernelWidth && x < this.iWidth - kernelWidth && y < this.iHeight - kernelWidth && z < this.iDepth - kernelWidth) {
                        double dx = 0.0;
                        double dy = 0.0;
                        double dz = 0.0;
                        for (int m = -kernelWidth; m <= kernelWidth; ++m) {
                            int kx = m + kernelWidth;
                            int vz = z + m;
                            for (int l = -kernelWidth; l <= kernelWidth; ++l) {
                                int ky = l + kernelWidth;
                                int vy = y + l;
                                for (int k = -kernelWidth; k <= kernelWidth; ++k) {
                                    int kz = k + kernelWidth;
                                    int vx = x + k;
                                    double val = volume[vz][vy][vx];
                                    dx += val * kernel[kx][ky][kz];
                                    dy += val * kernel[kx][kz][ky];
                                    dz += val * kernel[kz][ky][kx];
                                }
                            }
                        }
                        this.iData[z][y][x] = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                        continue;
                    }
                    this.iData[z][y][x] = 0.0;
                }
            }
        }
    }
}

