/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils.images;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mosaic.core.binarize.BinarizedIntervalLabelImage;
import mosaic.core.imageUtils.Connectivity;
import mosaic.core.imageUtils.FloodFill;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.BaseImage;
import mosaic.core.imageUtils.iterators.SpaceIterator;
import mosaic.core.utils.MosaicUtils;
import mosaic.utils.ConvertArray;
import mosaic.utils.ImgUtils;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.IntegerType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;

public class LabelImage
extends BaseImage {
    private static final Logger logger = Logger.getLogger(LabelImage.class);
    public static final int BGLabel = 0;
    public static final int BorderLabel = Integer.MAX_VALUE;
    private int[] iDataLabel;
    private Connectivity iConnectivityFG;
    private Connectivity iConnectivityBG;
    protected Point[] iNeighbourPoints;
    protected int[] iNeighbourIndices;
    protected Point[] iNeighbourBgPoints;
    protected int[] iNeighbourBgIndices;

    public <T extends IntegerType<T>> LabelImage(Img<T> aLabelImg) {
        super(MosaicUtils.getImageIntDimensions(aLabelImg), 3);
        this.initConnectivities();
        this.initDataLabel(aLabelImg);
    }

    public LabelImage(LabelImage aLabelImg) {
        super(aLabelImg.getDimensions(), aLabelImg.getNumOfDimensions());
        this.initConnectivities();
        this.iDataLabel = ArrayUtils.clone((int[])aLabelImg.iDataLabel);
    }

    public LabelImage(int[] aDimensions) {
        super(aDimensions, 3);
        this.initConnectivities();
        this.iDataLabel = new int[this.getSize()];
    }

    public LabelImage(int[] aData, int[] aDimensions) {
        super(aDimensions, 3);
        if (aData.length != this.getSize()) {
            throw new RuntimeException("Provided image data size is not compatibile with given dimensions! " + aData.length + " vs. " + super.toString() + " (" + this.getSize() + ")");
        }
        this.initConnectivities();
        this.iDataLabel = aData;
    }

    public LabelImage(short[][][] img) {
        super(new int[]{img[0].length, img[0][0].length, img.length}, 3);
        this.initConnectivities();
        this.initDataLabel(img);
    }

    public LabelImage(ImagePlus aInputImg) {
        this(aInputImg, true);
    }

    public LabelImage(ImagePlus aInputImg, boolean aShouldNormalize) {
        super(LabelImage.getDimensions(aInputImg), 3);
        this.initConnectivities();
        if (aShouldNormalize) {
            aInputImg = ImgUtils.convertToNormalizedGloballyFloatType(aInputImg);
        }
        this.initWithImg(aInputImg);
    }

    private <T extends IntegerType<T>> void initDataLabel(Img<T> aImage) {
        this.iDataLabel = new int[this.getSize()];
        SpaceIterator indexIterator = new SpaceIterator(MosaicUtils.getImageIntDimensions(aImage));
        Iterator<Integer> rg = indexIterator.getIndexIterator();
        RandomAccess ra = aImage.randomAccess();
        while (rg.hasNext()) {
            int idx = rg.next();
            Point p = indexIterator.indexToPoint(idx);
            ra.setPosition(p.iCoords);
            this.iDataLabel[idx] = ((IntegerType)ra.get()).getInteger();
        }
    }

    private void initDataLabel(short[][][] aArray) {
        this.iDataLabel = new int[this.getSize()];
        int width = this.getWidth();
        int height = this.getHeight();
        for (int z = 0; z < aArray.length; ++z) {
            for (int x = 0; x < aArray[0].length; ++x) {
                for (int y = 0; y < aArray[0][0].length; ++y) {
                    this.iDataLabel[x + y * width + z * height * width] = aArray[z][x][y];
                }
            }
        }
    }

    private void initConnectivities() {
        int numOfDimensions = this.getNumOfDimensions();
        this.iConnectivityFG = new Connectivity(numOfDimensions, numOfDimensions - 1);
        this.iConnectivityBG = this.iConnectivityFG.getComplementaryConnectivity();
        this.iNeighbourPoints = new Point[this.iConnectivityFG.getNumOfNeighbors()];
        this.iNeighbourIndices = new int[this.iConnectivityFG.getNumOfNeighbors()];
        int idx = 0;
        for (Point p : this.iConnectivityFG.iterator()) {
            this.iNeighbourIndices[idx] = this.pointToIndex(p);
            this.iNeighbourPoints[idx++] = p;
        }
        this.iNeighbourBgPoints = new Point[this.iConnectivityBG.getNumOfNeighbors()];
        this.iNeighbourBgIndices = new int[this.iConnectivityBG.getNumOfNeighbors()];
        idx = 0;
        for (Point p : this.iConnectivityBG.iterator()) {
            this.iNeighbourBgIndices[idx] = this.pointToIndex(p);
            this.iNeighbourBgPoints[idx++] = p;
        }
    }

    public void initZero() {
        for (int i = 0; i < this.iDataLabel.length; ++i) {
            this.setLabel(i, 0);
        }
    }

    public void deleteParticles() {
        for (int i = 0; i < this.iDataLabel.length; ++i) {
            this.setLabel(i, this.getLabelAbs(i));
        }
    }

    public void setLabel(int aIndex, int aLabel) {
        this.iDataLabel[aIndex] = aLabel;
    }

    public void setLabel(Point aPoint, int aLabel) {
        this.iDataLabel[this.pointToIndex((Point)aPoint)] = aLabel;
    }

    public int getLabel(int aIndex) {
        return this.iDataLabel[aIndex];
    }

    public int getLabel(Point aPoint) {
        return this.iDataLabel[this.pointToIndex(aPoint)];
    }

    public int getLabelAbs(Point aPoint) {
        return Math.abs(this.iDataLabel[this.pointToIndex(aPoint)]);
    }

    public int getLabelAbs(int aIndex) {
        return Math.abs(this.iDataLabel[aIndex]);
    }

    public int[] getDataLabel() {
        return this.iDataLabel;
    }

    public boolean isBorderLabel(int aLabel) {
        return aLabel == Integer.MAX_VALUE;
    }

    public boolean isInnerLabel(int aLabel) {
        return !this.isSpecialLabel(aLabel) && !this.isContourLabel(aLabel);
    }

    public boolean isSpecialLabel(int aLabel) {
        return aLabel == 0 || aLabel == Integer.MAX_VALUE;
    }

    public boolean isContourLabel(int aLabel) {
        return aLabel < 0;
    }

    public int labelToAbs(int aLabel) {
        return Math.abs(aLabel);
    }

    public int labelToNeg(int aLabel) {
        if (!this.isInnerLabel(aLabel)) {
            return aLabel;
        }
        return -aLabel;
    }

    public Connectivity getConnFG() {
        return this.iConnectivityFG;
    }

    public Connectivity getConnBG() {
        return this.iConnectivityBG;
    }

    public Set<Integer> connectedComponents() {
        HashSet<Integer> oldLabels = new HashSet<Integer>();
        int size = this.getSize();
        int minLabel = Integer.MAX_VALUE;
        int maxLabel = Integer.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            int l = this.getLabel(i);
            if (this.isSpecialLabel(l)) continue;
            if (l < minLabel) {
                minLabel = l;
            }
            if (l > maxLabel) {
                maxLabel = l;
            }
            oldLabels.add(l);
        }
        HashSet<Integer> newLabels = new HashSet<Integer>();
        BinarizedIntervalLabelImage aMultiThsFunctionPtr = new BinarizedIntervalLabelImage(this);
        if (minLabel < 0 && maxLabel > 0) {
            aMultiThsFunctionPtr.AddThresholdBetween(1, maxLabel);
            aMultiThsFunctionPtr.AddThresholdBetween(minLabel, -1);
        } else {
            aMultiThsFunctionPtr.AddThresholdBetween(minLabel, maxLabel);
        }
        int newLabel = Math.max(maxLabel + 1, 1);
        for (int idx = 0; idx < size; ++idx) {
            int label = this.getLabel(idx);
            if (!oldLabels.contains(label)) continue;
            FloodFill ff = new FloodFill(this, aMultiThsFunctionPtr, this.indexToPoint(idx));
            for (int p : ff) {
                this.setLabel(p, newLabel);
            }
            newLabels.add(newLabel);
            ++newLabel;
        }
        return newLabels;
    }

    public boolean isBoundaryPoint(Point aPoint) {
        int inLabel = this.getLabel(aPoint);
        return !this.isEnclosedByLabel(aPoint, inLabel);
    }

    public boolean isBoundaryPoint(int aIndex) {
        int inLabel = this.getLabel(aIndex);
        return !this.isEnclosedByLabel(aIndex, inLabel);
    }

    public boolean isEnclosedByLabel(Point aPoint, int aLabel) {
        return this.isEnclosedByLabel(this.pointToIndex(aPoint), aLabel);
    }

    public boolean isEnclosedByLabel(Integer aIndex, int aLabel) {
        int absLabel = this.labelToAbs(aLabel);
        for (int idx : this.iterateNeighbours(aIndex)) {
            if (this.getLabelAbs(idx) == absLabel) continue;
            return false;
        }
        return true;
    }

    public boolean isSingleFgPoint(Integer aIndex, int aLabel) {
        int absLabel = this.labelToAbs(aLabel);
        for (int idx : this.iterateNeighbours(aIndex)) {
            if (this.getLabelAbs(idx) != absLabel) continue;
            return false;
        }
        return true;
    }

    public boolean isEnclosedByLabelBgConnectivity(Integer aIndex, int aLabel) {
        int absLabel = this.labelToAbs(aLabel);
        for (int idx : this.iterateBgNeighbours(aIndex)) {
            if (this.getLabelAbs(idx) == absLabel) continue;
            return false;
        }
        return true;
    }

    public void initBorder() {
        block0: for (int idx : this.iIterator.getIndexIterable()) {
            Point p = this.indexToPoint(idx);
            int[] xs = p.iCoords;
            for (int d = 0; d < this.getNumOfDimensions(); ++d) {
                int x = xs[d];
                if (x != 0 && x != this.getDimension(d) - 1) continue;
                this.setLabel(idx, Integer.MAX_VALUE);
                continue block0;
            }
        }
    }

    public List<Point> initContour() {
        LinkedList<Point> contourPoints = new LinkedList<Point>();
        block0: for (int i : this.iIterator.getIndexIterable()) {
            int label = this.getLabelAbs(i);
            if (this.isSpecialLabel(label)) continue;
            Point p = this.indexToPoint(i);
            for (Integer neighbor : this.iterateNeighbours(p)) {
                int neighborLabel = this.getLabelAbs(neighbor);
                if (neighborLabel == label) continue;
                this.setLabel(p, this.labelToNeg(label));
                contourPoints.add(p);
                continue block0;
            }
        }
        return contourPoints;
    }

    public Iterable<Integer> iterateNeighbours(final Point aPoint) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new NeighbourConnIterator(LabelImage.this.pointToIndex(aPoint));
            }
        };
    }

    public Iterable<Integer> iterateNeighbours(final Integer aIndex) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new NeighbourConnIterator(aIndex);
            }
        };
    }

    public Iterable<Integer> iterateBgNeighbours(final Integer aIndex) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new BgNeighbourConnIterator(aIndex);
            }
        };
    }

    public void initWithImg(ImagePlus aImagePlus) {
        this.iDataLabel = LabelImage.imgToIntArray(aImagePlus);
    }

    public void initLabelsWithRoi(Roi aRoi) {
        if (this.getNumOfDimensions() == 2) {
            ColorProcessor ip = new ColorProcessor(this.getWidth(), this.getHeight(), this.iDataLabel);
            ip.setValue(1.0);
            ip.fill(aRoi);
        } else {
            int sizeOfSlice = this.getWidth() * this.getHeight();
            int[] slice = new int[sizeOfSlice];
            ColorProcessor ip = new ColorProcessor(this.getWidth(), this.getHeight(), slice);
            ip.setValue(1.0);
            ip.fill(aRoi);
            int idx = 0;
            for (int z = 0; z < this.getDepth(); ++z) {
                for (int i = 0; i < sizeOfSlice; ++i) {
                    this.iDataLabel[idx++] = slice[idx % sizeOfSlice];
                }
            }
        }
    }

    public int getMax() {
        int max = Integer.MIN_VALUE;
        for (int v : this.iDataLabel) {
            if (max >= v) continue;
            max = v;
        }
        return max;
    }

    @Override
    public ImagePlus convertToImg(String aTitle) {
        ImagePlus imp = new ImagePlus(aTitle, this.getShortStack(true, true, true));
        StackStatistics stackStats = new StackStatistics(imp);
        imp.setDisplayRange(stackStats.min, stackStats.max);
        IJ.run((ImagePlus)imp, (String)"3-3-2 RGB", null);
        return imp;
    }

    public ImageStack getShortStack(boolean aUseAbsValue, boolean aBorderRemove, boolean aClampValues) {
        short[] shortData = LabelImage.intToShort(this.iDataLabel, aUseAbsValue, aBorderRemove, aClampValues);
        int w = this.getWidth();
        int h = this.getHeight();
        int area = w * h;
        ImageStack stack = new ImageStack(w, h);
        for (int i = 0; i < this.getNumOfSlices(); ++i) {
            stack.addSlice("", (Object)Arrays.copyOfRange(shortData, i * area, (i + 1) * area));
        }
        return stack;
    }

    private static short[] intToShort(int[] aInputArr, boolean aUseAbsValue, boolean aBorderRemove, boolean aClampValues) {
        int len = aInputArr.length;
        short[] shorts = new short[len];
        boolean foundFirstErrorMax = false;
        boolean foundFirstErrorMin = false;
        for (int i = 0; i < len; ++i) {
            int val = aInputArr[i];
            if (aBorderRemove && val == Integer.MAX_VALUE) {
                val = 0;
            }
            if (aClampValues) {
                if (val > Short.MAX_VALUE) {
                    val = Short.MAX_VALUE;
                    if (!foundFirstErrorMax) {
                        foundFirstErrorMax = true;
                        logger.error((Object)("Found value=" + val + "at idx=" + i + " which is too big for short type!"));
                    }
                } else if (val < Short.MIN_VALUE) {
                    if (!foundFirstErrorMin) {
                        foundFirstErrorMin = true;
                        logger.error((Object)("Found value=" + val + "at idx=" + i + " which is too small for short type!"));
                    }
                    val = Short.MIN_VALUE;
                }
            }
            shorts[i] = aUseAbsValue ? (short)Math.abs((short)val) : (short)val;
        }
        return shorts;
    }

    private static int[] imgToIntArray(ImagePlus aImagePlus) {
        ImageStack stack = aImagePlus.getStack();
        int imgArea = aImagePlus.getWidth() * aImagePlus.getHeight();
        int numOfSlices = stack.getSize();
        int[] result = new int[numOfSlices * imgArea];
        for (int i = 0; i < numOfSlices; ++i) {
            int[] intArray = LabelImage.getIntArray(stack.getProcessor(i + 1));
            for (int j = 0; j < imgArea; ++j) {
                result[i * imgArea + j] = intArray[j];
            }
        }
        return result;
    }

    private static int[] getIntArray(ImageProcessor aImgProcessor) {
        int[] intArray = null;
        Object pixels = aImgProcessor.getPixels();
        if (pixels instanceof int[]) {
            intArray = (int[])((int[])pixels).clone();
        } else if (pixels instanceof float[]) {
            intArray = ConvertArray.toInt((float[])pixels);
        } else if (pixels instanceof byte[]) {
            intArray = ConvertArray.toInt((byte[])pixels);
        } else if (pixels instanceof short[]) {
            intArray = ConvertArray.toInt((short[])pixels);
        } else {
            throw new RuntimeException("Not supported conversion");
        }
        return intArray;
    }

    private class BgNeighbourConnIterator
    implements Iterator<Integer> {
        private int cursor = 0;
        private final int inputIndex;
        int max = 0;
        int[] idxs = null;

        BgNeighbourConnIterator(Integer aIndex) {
            this.inputIndex = aIndex;
            Point start = LabelImage.this.indexToPoint(aIndex);
            this.max = 0;
            this.idxs = new int[LabelImage.this.iNeighbourBgPoints.length];
            if (LabelImage.this.isInBound(start)) {
                for (int i = 0; i < LabelImage.this.iNeighbourBgPoints.length; ++i) {
                    if (!LabelImage.this.isInBound(start.add(LabelImage.this.iNeighbourBgPoints[i]))) continue;
                    this.idxs[this.max++] = LabelImage.this.iNeighbourBgIndices[i] + this.inputIndex;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.max;
        }

        @Override
        public Integer next() {
            return this.idxs[this.cursor++];
        }

        @Override
        public void remove() {
        }
    }

    private class NeighbourConnIterator
    implements Iterator<Integer> {
        private int cursor = 0;
        private final int inputIndex;
        int max = 0;
        int[] idxs = null;

        NeighbourConnIterator(Integer aIndex) {
            this.inputIndex = aIndex;
            Point start = LabelImage.this.indexToPoint(aIndex);
            this.max = 0;
            this.idxs = new int[LabelImage.this.iNeighbourPoints.length];
            if (LabelImage.this.isInBound(start)) {
                for (int i = 0; i < LabelImage.this.iNeighbourPoints.length; ++i) {
                    if (!LabelImage.this.isInBound(start.add(LabelImage.this.iNeighbourPoints[i]))) continue;
                    this.idxs[this.max++] = LabelImage.this.iNeighbourIndices[i] + this.inputIndex;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.max;
        }

        @Override
        public Integer next() {
            return this.idxs[this.cursor++];
        }

        @Override
        public void remove() {
        }
    }
}

