/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils.masks;

import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.iterators.SpaceIterator;
import mosaic.core.imageUtils.masks.Mask;

public abstract class EllipseBase
implements Mask {
    private final float[] iMiddlePoint;
    private final float[] iRadius;
    protected float[] iScaling;
    protected final int[] iDimensions;
    protected final boolean[] iMask;
    protected final SpaceIterator iIterator;
    protected int iNumOfFgPoints = 0;

    EllipseBase(float aRadius, int aSizeOfRegion, float[] aScaling) {
        int numOfDims = aScaling.length;
        this.iMiddlePoint = new float[numOfDims];
        this.iRadius = new float[numOfDims];
        this.iDimensions = new int[numOfDims];
        for (int i = 0; i < numOfDims; ++i) {
            this.iRadius[i] = aRadius;
            this.iMiddlePoint[i] = (float)aSizeOfRegion / 2.0f;
            this.iDimensions[i] = aSizeOfRegion;
        }
        this.iScaling = aScaling;
        this.iIterator = new SpaceIterator(this.iDimensions);
        this.iMask = new boolean[this.iIterator.getSize()];
    }

    @Override
    public boolean isInMask(int aIndex) {
        return this.iMask[aIndex];
    }

    @Override
    public int[] getDimensions() {
        return this.iDimensions;
    }

    @Override
    public int getNumOfFgPoints() {
        return this.iNumOfFgPoints;
    }

    protected float hyperEllipse(Point aPoint) {
        int[] iCoords = aPoint.iCoords;
        float result = 0.0f;
        for (int vD = 0; vD < this.iRadius.length; ++vD) {
            float dist = ((float)iCoords[vD] + 0.5f - this.iMiddlePoint[vD]) * this.iScaling[vD];
            result += dist * dist / (this.iRadius[vD] * this.iRadius[vD]);
        }
        return result;
    }
}

