/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.particleLinking;

import java.util.ArrayList;
import java.util.List;

class BipartiteMatcher {
    private static final double TOL = 1.0E-10;
    private int n;
    private double[][] weights;
    private double minWeight;
    private double maxWeight;
    private int[] sMatches;
    private int[] tMatches;
    private static final int NO_LABEL = -1;
    private static final int EMPTY_LABEL = -2;
    private int[] sLabels;
    private int[] tLabels;
    private double[] u;
    private double[] v;
    private double[] pi;
    private final List<Integer> eligibleS = new ArrayList<Integer>();
    private final List<Integer> eligibleT = new ArrayList<Integer>();

    public BipartiteMatcher(int n) {
        this.reset(n);
    }

    private void reset(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative num nodes: " + n);
        }
        this.n = n;
        this.weights = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.weights[i][j] = 1.0;
            }
        }
        this.minWeight = 1.0;
        this.maxWeight = Double.NEGATIVE_INFINITY;
        this.sMatches = new int[n];
        this.tMatches = new int[n];
        this.sLabels = new int[n];
        this.tLabels = new int[n];
        this.u = new double[n];
        this.v = new double[n];
        this.pi = new double[n];
    }

    public void setWeight(int i, int j, double w) {
        if (this.n == -1) {
            throw new IllegalStateException("Graph size not specified.");
        }
        if (i < 0 || i >= this.n) {
            throw new IllegalArgumentException("i-value out of range: " + i);
        }
        if (j < 0 || j >= this.n) {
            throw new IllegalArgumentException("j-value out of range: " + j);
        }
        if (Double.isNaN(w)) {
            throw new IllegalArgumentException("Illegal weight: " + w);
        }
        this.weights[i][j] = w;
        if (w > Double.NEGATIVE_INFINITY && w < this.minWeight) {
            this.minWeight = w;
        }
        if (w > this.maxWeight) {
            this.maxWeight = w;
        }
    }

    public int[] getMatching() {
        int i;
        if (this.n == -1) {
            throw new IllegalStateException("Graph size not specified.");
        }
        if (this.n == 0) {
            return new int[0];
        }
        this.ensurePositiveWeights();
        this.eligibleS.clear();
        this.eligibleT.clear();
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.sMatches[i2] = -1;
            this.tMatches[i2] = -1;
            this.u[i2] = this.maxWeight;
            this.v[i2] = 0.0;
            this.pi[i2] = Double.POSITIVE_INFINITY;
            this.sLabels[i2] = -2;
            this.eligibleS.add(new Integer(i2));
            this.tLabels[i2] = -1;
        }
        while (true) {
            int lastNode;
            if ((lastNode = this.findAugmentingPath()) != -1) {
                this.flipPath(lastNode);
                for (i = 0; i < this.n; ++i) {
                    this.pi[i] = Double.POSITIVE_INFINITY;
                    this.sLabels[i] = -1;
                    this.tLabels[i] = -1;
                }
                this.eligibleS.clear();
                for (i = 0; i < this.n; ++i) {
                    if (this.sMatches[i] != -1) continue;
                    this.sLabels[i] = -2;
                    this.eligibleS.add(new Integer(i));
                }
                this.eligibleT.clear();
                continue;
            }
            double delta1 = Double.POSITIVE_INFINITY;
            for (int i3 = 0; i3 < this.n; ++i3) {
                if (!(this.u[i3] < delta1)) continue;
                delta1 = this.u[i3];
            }
            double delta2 = Double.POSITIVE_INFINITY;
            for (int j = 0; j < this.n; ++j) {
                if (!(this.pi[j] >= 1.0E-10) || !(this.pi[j] < delta2)) continue;
                delta2 = this.pi[j];
            }
            if (delta1 < delta2) break;
            this.changeDualVars(delta2);
        }
        int[] matching = new int[this.n];
        for (i = 0; i < this.n; ++i) {
            matching[i] = this.sMatches[i];
        }
        return matching;
    }

    private int findAugmentingPath() {
        while (!this.eligibleS.isEmpty() || !this.eligibleT.isEmpty()) {
            if (!this.eligibleS.isEmpty()) {
                int i = this.eligibleS.get(this.eligibleS.size() - 1);
                this.eligibleS.remove(this.eligibleS.size() - 1);
                for (int j = 0; j < this.n; ++j) {
                    double diff;
                    if (this.tMatches[j] == i || !(this.pi[j] >= 1.0E-10) || !((diff = this.u[i] + this.v[j] - this.weights[i][j]) < this.pi[j])) continue;
                    this.tLabels[j] = i;
                    this.pi[j] = diff;
                    if (!(this.pi[j] < 1.0E-10)) continue;
                    this.eligibleT.add(new Integer(j));
                }
                continue;
            }
            int j = this.eligibleT.get(this.eligibleT.size() - 1);
            this.eligibleT.remove(this.eligibleT.size() - 1);
            if (this.tMatches[j] == -1) {
                return j;
            }
            int i = this.tMatches[j];
            this.sLabels[i] = j;
            this.eligibleS.add(new Integer(i));
        }
        return -1;
    }

    private void flipPath(int lastNode) {
        while (lastNode != -2) {
            int parent = this.tLabels[lastNode];
            this.sMatches[parent] = lastNode;
            this.tMatches[lastNode] = parent;
            lastNode = this.sLabels[parent];
        }
    }

    private void changeDualVars(double delta) {
        for (int i = 0; i < this.n; ++i) {
            if (this.sLabels[i] == -1) continue;
            int n = i;
            this.u[n] = this.u[n] - delta;
        }
        for (int j = 0; j < this.n; ++j) {
            if (this.pi[j] < 1.0E-10) {
                int n = j;
                this.v[n] = this.v[n] + delta;
                continue;
            }
            if (this.tLabels[j] == -1) continue;
            int n = j;
            this.pi[n] = this.pi[n] - delta;
            if (!(this.pi[j] < 1.0E-10)) continue;
            this.eligibleT.add(new Integer(j));
        }
    }

    private void ensurePositiveWeights() {
        if (this.minWeight < 1.0E-10) {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    this.weights[i][j] = this.weights[i][j] - this.minWeight + 1.0;
                }
            }
            this.maxWeight = this.maxWeight - this.minWeight + 1.0;
            this.minWeight = 1.0;
        }
    }
}

