/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.psf;

import ij.IJ;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import io.scif.SCIFIOService;
import io.scif.img.ImgIOException;
import io.scif.img.ImgOpener;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import mosaic.core.psf.FilePSFSettings;
import mosaic.core.psf.GeneratePSF;
import mosaic.core.psf.psf;
import mosaic.core.utils.MosaicUtils;
import mosaic.utils.io.serialize.DataFile;
import mosaic.utils.io.serialize.SerializedDataFile;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.algorithm.fft2.FFTConvolution;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.Context;
import org.scijava.app.AppService;
import org.scijava.app.StatusService;

class FilePSF<T extends RealType<T> & NativeType<T>>
implements psf<T> {
    private FilePSFSettings settings = new FilePSFSettings();
    private Img<T> image;
    private RandomAccess<T> rd;
    private final Class<T> clCreator;
    protected String filename;
    private final int[] offset = null;
    private double[][] Image2DD;
    private double[][][] Image3DD;
    private float[][] Image2DF;
    private float[][][] Image3DF;

    public FilePSF(Class<T> cl) {
        this.clCreator = cl;
    }

    public RandomAccess<T> copyRandomAccess() {
        return this.rd;
    }

    public int getIntPosition(int i) {
        return this.rd.getIntPosition(i);
    }

    public long getLongPosition(int i) {
        return this.rd.getLongPosition(i);
    }

    public void localize(int[] loc) {
        this.rd.localize(loc);
    }

    public void localize(long[] loc) {
        this.rd.localize(loc);
    }

    public double getDoublePosition(int i) {
        return this.rd.getDoublePosition(i);
    }

    public float getFloatPosition(int i) {
        return this.rd.getFloatPosition(i);
    }

    public void localize(float[] loc) {
        this.rd.localize(loc);
    }

    public void localize(double[] loc) {
        this.rd.localize(loc);
    }

    public int numDimensions() {
        return this.rd.numDimensions();
    }

    public void bck(int i) {
        this.rd.bck(i);
    }

    public void fwd(int i) {
        this.rd.fwd(i);
    }

    public void move(Localizable arg) {
        this.rd.move(arg);
    }

    public void move(int[] mv) {
        this.rd.move(mv);
    }

    public void move(long[] mv) {
        this.rd.move(mv);
    }

    public void move(int i, int j) {
        this.rd.move(i, j);
    }

    public void setPosition(Localizable arg) {
        this.rd.setPosition(arg);
    }

    public void setPosition(int[] pos_) {
        this.rd.setPosition(pos_);
    }

    public void setPosition(long[] pos_) {
        this.rd.setPosition(pos_);
    }

    public void setPosition(int i, int j) {
        this.rd.setPosition(i, j);
    }

    public void setPosition(long i, int j) {
        this.rd.setPosition(i, j);
    }

    public Sampler<T> copy() {
        return this.rd.copy();
    }

    public T get() {
        return (T)((RealType)this.rd.get());
    }

    public void move(long i, int j) {
        this.rd.move(i, j);
    }

    @Override
    public void getParamenters() {
        this.settings.filePSF = new String();
        this.settings = FilePSF.getConfigHandler().LoadFromFile(IJ.getDirectory((String)"temp") + File.separator + "psf_file_settings.dat", FilePSFSettings.class, this.settings);
        GenericDialog gd = new GenericDialog("File PSF");
        String psf2 = MosaicUtils.parseString("psf_file", Macro.getOptions());
        if (psf2 != null) {
            gd.addStringField("File", psf2);
        } else {
            gd.addStringField("File", this.settings.filePSF);
        }
        final TextField PSFc = (TextField)gd.getStringFields().lastElement();
        Button optionButton = new Button("Choose");
        GridBagConstraints c = new GridBagConstraints();
        int gridx = 2;
        int gridy = 0;
        c.gridx = 2;
        c.gridy = gridy++;
        c.anchor = 13;
        gd.add((Component)optionButton, (Object)c);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDialog op = new OpenDialog("Choose PSF file", null);
                FilePSF.this.filename = op.getDirectory() + File.separator + op.getFileName();
                PSFc.setText(FilePSF.this.filename);
            }
        });
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String filename = gd.getNextString();
        ArrayImgFactory factory = new ArrayImgFactory();
        ImgOpener imgOpener = new ImgOpener(new Context(new Class[]{SCIFIOService.class, AppService.class, StatusService.class}));
        try {
            try {
                this.image = (Img)imgOpener.openImgs(filename, (ImgFactory)factory, (RealType)this.clCreator.newInstance()).get(0);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        catch (ImgIOException e) {
            e.printStackTrace();
        }
        if (this.image == null) {
            return;
        }
        this.rd = this.image.randomAccess();
        this.settings.filePSF = filename;
        FilePSF.getConfigHandler().SaveToFile(IJ.getDirectory((String)"temp") + File.separator + "psf_file_settings.dat", this.settings);
    }

    @Override
    public <S extends RealType<S>> void convolve(RandomAccessibleInterval<S> img, S bound) {
        new FFTConvolution(img, this.image, (ImgFactory)new ArrayImgFactory()).convolve();
    }

    @Override
    public int[] getSuggestedImageSize() {
        if (this.image == null) {
            return null;
        }
        int[] sz = new int[this.image.numDimensions()];
        for (int i = 0; i < this.image.numDimensions(); ++i) {
            sz[i] = (int)this.image.dimension(i);
        }
        return sz;
    }

    @Override
    public void setSuggestedImageSize(int[] sz) {
    }

    @Override
    public void setCenter(int[] pos) {
        long[] pos_ = new long[pos.length];
        for (int i = 0; i < pos.length; ++i) {
            pos_[i] = pos[i];
            this.offset[i] = pos[i];
        }
        this.rd = Views.offset(this.image, (long[])pos_).randomAccess();
    }

    @Override
    public String getStringParameters() {
        return "file=" + this.filename;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    private static DataFile<FilePSFSettings> getConfigHandler() {
        return new SerializedDataFile<FilePSFSettings>();
    }

    @Override
    public int[] getCenter() {
        return this.offset;
    }

    @Override
    public boolean isSeparable() {
        return false;
    }

    @Override
    public double[] getSeparableImageAsDoubleArray(int dim) {
        return null;
    }

    @Override
    public float[][][] getImage3DAsFloatArray() {
        if (this.Image3DF == null) {
            this.Image3DF = GeneratePSF.generateImage3DAsFloatArray(this);
        }
        return this.Image3DF;
    }

    @Override
    public double[][][] getImage3DAsDoubleArray() {
        if (this.Image3DD == null) {
            this.Image3DD = GeneratePSF.generateImage3DAsDoubleArray(this);
        }
        return this.Image3DD;
    }

    @Override
    public double[][] getImage2DAsDoubleArray() {
        if (this.Image2DD == null) {
            this.Image2DD = GeneratePSF.generateImage2DAsDoubleArray(this);
        }
        return this.Image2DD;
    }

    @Override
    public float[][] getImage2DAsFloatArray() {
        this.Image2DF = GeneratePSF.generateImage2DAsFloatArray(this);
        return this.Image2DF;
    }
}

