/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.psf;

import ij.IJ;
import ij.gui.GenericDialog;
import java.io.File;
import java.lang.reflect.Array;
import mosaic.core.psf.GaussPSFSettings;
import mosaic.core.psf.GeneratePSF;
import mosaic.core.psf.psf;
import mosaic.utils.io.serialize.DataFile;
import mosaic.utils.io.serialize.SerializedDataFile;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public class GaussPSF<T extends RealType<T>>
implements psf<T> {
    private GaussPSFSettings settings = new GaussPSFSettings();
    private final RealType<T>[] pos;
    private RealType<T>[] stdDev;
    private final RealType<T>[] offset;
    private final Class<T> clCreator;
    private final double[][] sepDimD;
    private double[][] Image2DD;
    private double[][][] Image3DD;
    private float[][] Image2DF;
    private float[][][] Image3DF;

    public GaussPSF(int dim, Class<T> cl) {
        this.clCreator = cl;
        this.pos = (RealType[])Array.newInstance(cl, dim);
        this.stdDev = (RealType[])Array.newInstance(cl, dim);
        this.offset = (RealType[])Array.newInstance(cl, dim);
        this.sepDimD = new double[dim][];
        try {
            for (int i = 0; i < dim; ++i) {
                this.pos[i] = (RealType)cl.newInstance();
                this.stdDev[i] = (RealType)cl.newInstance();
                this.offset[i] = (RealType)cl.newInstance();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void setStdDeviation(RealType<T>[] var_) {
        this.stdDev = var_;
    }

    public RandomAccess<T> copyRandomAccess() {
        return this;
    }

    public int getIntPosition(int i) {
        return (int)this.pos[i].getRealDouble();
    }

    public long getLongPosition(int i) {
        return (int)this.pos[i].getRealDouble();
    }

    public void localize(int[] loc) {
        for (int i = 0; i < loc.length; ++i) {
            this.pos[i].setReal((float)loc[i]);
        }
    }

    public void localize(long[] loc) {
        for (int i = 0; i < loc.length; ++i) {
            this.pos[i].setReal((float)loc[i]);
        }
    }

    public double getDoublePosition(int i) {
        return this.pos[i].getRealDouble();
    }

    public float getFloatPosition(int i) {
        return this.pos[i].getRealFloat();
    }

    public void localize(float[] loc) {
        for (int i = 0; i < loc.length; ++i) {
            this.pos[i].setReal(loc[i]);
        }
    }

    public void localize(double[] loc) {
        for (int i = 0; i < loc.length; ++i) {
            this.pos[i].setReal(loc[i]);
        }
    }

    public int numDimensions() {
        return this.pos.length;
    }

    public void bck(int i) {
        this.pos[i].setReal(this.pos[i].getRealDouble() + 1.0);
    }

    public void fwd(int i) {
        this.pos[i].setReal(this.pos[i].getRealDouble() + 1.0);
    }

    public void move(Localizable arg) {
        for (int i = 0; i < arg.numDimensions(); ++i) {
            this.pos[i].setReal(this.pos[i].getRealDouble() + arg.getDoublePosition(i));
        }
    }

    public void move(int[] mv) {
        for (int i = 0; i < mv.length; ++i) {
            this.pos[i].setReal((float)mv[i]);
        }
    }

    public void move(long[] mv) {
        for (int i = 0; i < mv.length; ++i) {
            this.pos[i].setReal(this.pos[i].getRealDouble() + (double)mv[i]);
        }
    }

    public void move(int i, int j) {
        this.pos[i].setReal((float)j);
    }

    public void setPosition(Localizable arg) {
        for (int i = 0; i < arg.numDimensions(); ++i) {
            this.pos[i].setReal(arg.getDoublePosition(i));
        }
    }

    public void setPosition(int[] pos_) {
        for (int i = 0; i < this.pos.length; ++i) {
            this.pos[i].setReal((float)pos_[i]);
        }
    }

    public void setPosition(long[] pos_) {
        for (int i = 0; i < this.pos.length; ++i) {
            this.pos[i].setReal((float)pos_[i]);
        }
    }

    public void setPosition(int i, int j) {
        this.pos[i].setReal((float)j);
    }

    public void setPosition(long i, int j) {
        this.pos[(int)i].setReal((float)j);
    }

    public Sampler<T> copy() {
        return this;
    }

    public T get() {
        double res = 1.0;
        for (int i = 0; i < this.pos.length; ++i) {
            res *= 1.0 / Math.sqrt(Math.PI * 2) / this.stdDev[i].getRealDouble() * Math.exp(-(this.pos[i].getRealDouble() - this.offset[i].getRealDouble()) * (this.pos[i].getRealDouble() - this.offset[i].getRealDouble()) / (2.0 * this.stdDev[i].getRealDouble() * this.stdDev[i].getRealDouble()));
        }
        RealType rc = (RealType)this.pos[0].createVariable();
        rc.setReal(res);
        RealType rt = null;
        try {
            rt = (RealType)this.clCreator.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        rt.setReal(res);
        return (T)rt;
    }

    public void move(long i, int j) {
        this.pos[(int)i].setReal(this.pos[(int)i].getRealDouble() + (double)j);
    }

    @Override
    public void getParamenters() {
        int i;
        this.settings = GaussPSF.getConfigHandler().LoadFromFile(IJ.getDirectory((String)"temp") + File.separator + "psf_gauss_settings.dat", GaussPSFSettings.class, this.settings);
        GenericDialog gd = new GenericDialog("Gauss PSF");
        if (this.pos.length >= 1) {
            gd.addNumericField("sigma_X", 1.0, 3);
        }
        if (this.pos.length >= 2) {
            gd.addNumericField("sigma_Y", 1.0, 3);
        }
        if (this.pos.length >= 3) {
            gd.addNumericField("sigma_Z", 1.0, 3);
        }
        for (i = 0; i < this.pos.length - 3; ++i) {
            gd.addNumericField("sigma_" + i, 1.0, 3);
        }
        for (i = 0; i < this.pos.length - 3; ++i) {
            gd.addNumericField("mean_" + i, 1.0, 3);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        for (i = 0; i < this.stdDev.length; ++i) {
            this.stdDev[i].setReal(gd.getNextNumber());
        }
        GaussPSF.getConfigHandler().SaveToFile(IJ.getDirectory((String)"temp") + File.separator + "psf_gauss_settings.dat", this.settings);
    }

    @Override
    public <S extends RealType<S>> void convolve(RandomAccessibleInterval<S> img, S bound) {
        int d;
        double[] sigma = new double[img.numDimensions()];
        if (this.stdDev == null) {
            for (d = 0; d < sigma.length; ++d) {
                sigma[d] = 1.0;
            }
        } else {
            for (d = 0; d < sigma.length; ++d) {
                sigma[d] = this.stdDev[d].getRealDouble();
            }
        }
        ExtendedRandomAccessibleInterval infiniteImg = Views.extendValue(img, bound);
        try {
            Gauss3.gauss((double[])sigma, (RandomAccessible)infiniteImg, img);
        }
        catch (IncompatibleTypeException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setCenter(int[] pos) {
        for (int i = 0; i < pos.length; ++i) {
            this.offset[i].setReal((float)pos[i]);
        }
    }

    @Override
    public String getStringParameters() {
        String opt = new String();
        opt = this.stdDev.length == 2 ? opt + "sigma_x=" + this.stdDev[0] + " sigma_y=" + this.stdDev[1] + " Dimensions=" + this.stdDev.length : opt + "sigma_x=" + this.stdDev[0] + " sigma_y=" + this.stdDev[1] + " sigma_z=" + this.stdDev[2] + " Dimensions=" + this.stdDev.length;
        for (int i = 0; i < this.stdDev.length - 3; ++i) {
            opt = opt + "sigma_" + i + "=" + this.stdDev[i + 3];
        }
        return opt;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    private static DataFile<GaussPSFSettings> getConfigHandler() {
        return new SerializedDataFile<GaussPSFSettings>();
    }

    @Override
    public int[] getSuggestedImageSize() {
        int[] sz = new int[this.pos.length];
        for (int i = 0; i < this.pos.length; ++i) {
            int szo = (int)(this.stdDev[i].getRealDouble() * 8.0) + 1;
            sz[i] = szo % 2 == 0 ? szo + 1 : szo;
        }
        return sz;
    }

    @Override
    public void setSuggestedImageSize(int[] sz) {
    }

    @Override
    public boolean isSeparable() {
        return true;
    }

    @Override
    public double[] getSeparableImageAsDoubleArray(int aDim) {
        if (this.sepDimD[aDim] == null) {
            int[] sz = this.getSuggestedImageSize();
            int[] mid = new int[sz.length];
            for (int i = 0; i < sz.length; ++i) {
                mid[i] = sz[i] / 2;
            }
            int[] old_mid = this.getCenter();
            this.setCenter(mid);
            for (int dim = 0; dim < this.sepDimD.length; ++dim) {
                this.sepDimD[dim] = new double[sz[dim]];
                for (int i = 0; i < sz[dim]; ++i) {
                    double res;
                    this.sepDimD[dim][i] = res = 1.0 / Math.sqrt(Math.PI * 2) / this.stdDev[dim].getRealDouble() * Math.exp(-((double)i - this.offset[dim].getRealDouble()) * ((double)i - this.offset[dim].getRealDouble()) / (2.0 * this.stdDev[dim].getRealDouble() * this.stdDev[dim].getRealDouble()));
                }
            }
            this.setCenter(old_mid);
        }
        return this.sepDimD[aDim];
    }

    @Override
    public float[][][] getImage3DAsFloatArray() {
        if (this.Image3DF == null) {
            this.Image3DF = GeneratePSF.generateImage3DAsFloatArray(this);
        }
        return this.Image3DF;
    }

    @Override
    public double[][][] getImage3DAsDoubleArray() {
        if (this.Image3DD == null) {
            this.Image3DD = GeneratePSF.generateImage3DAsDoubleArray(this);
        }
        return this.Image3DD;
    }

    @Override
    public double[][] getImage2DAsDoubleArray() {
        if (this.Image2DD == null) {
            this.Image2DD = GeneratePSF.generateImage2DAsDoubleArray(this);
        }
        return this.Image2DD;
    }

    @Override
    public float[][] getImage2DAsFloatArray() {
        this.Image2DF = GeneratePSF.generateImage2DAsFloatArray(this);
        return this.Image2DF;
    }

    @Override
    public int[] getCenter() {
        int[] ofs = new int[this.pos.length];
        for (int i = 0; i < ofs.length; ++i) {
            ofs[i] = (int)this.offset[i].getRealDouble();
        }
        return ofs;
    }
}

