/*
 * Decompiled with CFR 0.152.
 */
package mosaic.noise_sample;

import java.util.Random;
import mosaic.noise_sample.NoiseSample;
import net.imglib2.type.numeric.RealType;

class PoissonSampler<T extends RealType<T>>
implements NoiseSample<T> {
    private final Random mRandomGenerator = new Random(8888L);
    private double offset;

    PoissonSampler(double offset_) {
        this.offset = offset_;
    }

    @Override
    public void sample(T x, T out) {
        int aLambda = (int)x.getRealDouble();
        if ((aLambda = (int)((double)aLambda - this.offset)) >= 30) {
            double rnd = this.mRandomGenerator.nextGaussian() * Math.sqrt(aLambda) + (double)aLambda + 0.5 + this.offset;
            if (rnd >= out.getMaxValue()) {
                rnd = out.getMaxValue();
            }
            out.setReal(rnd);
            return;
        }
        double p = 1.0;
        int k = 0;
        double vL = Math.exp(-aLambda);
        do {
            ++k;
        } while ((p *= this.mRandomGenerator.nextDouble()) >= vL);
        if ((double)(k - 1) + this.offset > x.getMaxValue()) {
            out.setReal(x.getMaxValue());
        } else {
            out.setReal((double)(k - 1) + this.offset);
        }
    }
}

