/*
 * Decompiled with CFR 0.152.
 */
package mosaic.particleTracker;

import ij.IJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.text.TextPanel;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import mosaic.core.utils.MosaicUtils;
import mosaic.particleTracker.Trajectory;
import mosaic.particleTracker.TrajectoryAnalysisPlot;
import mosaic.plugins.ParticleTracker3DModular_;

public class ResultsWindow
extends Frame
implements FocusListener,
ActionListener {
    private final ParticleTracker3DModular_ particleTracker3DModular;
    private static final long serialVersionUID = 1L;
    public final TextPanel text_panel;
    public final TextPanel configuration_panel;
    private final Button view_static;
    private final Button save_report;
    private final Button display_report;
    private final Button dummy;
    private final Button plot_particle;
    private final Button trajectory_focus;
    private final Button trajectory_info;
    private final Button traj_in_area_info;
    private final Button area_focus;
    private final Button transfer_particles;
    private final Button transfer_trajs;
    private final Button mssButton;
    private final Button transfer_traj;
    private final Button mssAllResultsButton;
    private final Button mssTrajectoryResultButton;
    final Label per_traj_label;
    private final Label area_label;
    private final Label all_label;
    private final MenuItem mag_factor;
    private final MenuItem relink_particles;
    public int magnification_factor = 4;
    public double pixelDimensions = 1.0;
    public double timeInterval = 1.0;

    public ResultsWindow(ParticleTracker3DModular_ particleTracker3DModular_, String title) {
        super(title);
        this.particleTracker3DModular = particleTracker3DModular_;
        this.enableEvents(64L);
        this.addFocusListener(this);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.anchor = 18;
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 0.25;
        c.weighty = 0.25;
        this.configuration_panel = new TextPanel("configuration");
        gridbag.setConstraints((Component)this.configuration_panel, c);
        this.add((Component)this.configuration_panel);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.text_panel = new TextPanel("Results");
        this.text_panel.setTitle("Results");
        gridbag.setConstraints((Component)this.text_panel, c);
        this.add((Component)this.text_panel);
        Panel all_options = new Panel();
        all_options.setBackground(Color.LIGHT_GRAY);
        all_options.setLayout(gridbag);
        this.all_label = new Label("All Trajectories", 1);
        this.save_report = new Button(" Save Full Report");
        this.save_report.addActionListener(this);
        this.display_report = new Button(" Display Full Report");
        this.display_report.addActionListener(this);
        this.view_static = new Button(" Visualize All Trajectories ");
        this.view_static.addActionListener(this);
        this.transfer_particles = new Button(" Segmented Particles to Table");
        this.transfer_particles.addActionListener(this);
        this.transfer_trajs = new Button(" All Trajectories to Table");
        this.transfer_trajs.addActionListener(this);
        this.mssAllResultsButton = new Button(" All MSS/MSD to Table ");
        this.mssAllResultsButton.addActionListener(this);
        gridbag.setConstraints(this.all_label, c);
        all_options.add(this.all_label);
        gridbag.setConstraints(this.view_static, c);
        all_options.add(this.view_static);
        gridbag.setConstraints(this.save_report, c);
        all_options.add(this.save_report);
        gridbag.setConstraints(this.display_report, c);
        all_options.add(this.display_report);
        gridbag.setConstraints(this.transfer_particles, c);
        all_options.add(this.transfer_particles);
        gridbag.setConstraints(this.transfer_trajs, c);
        all_options.add(this.transfer_trajs);
        gridbag.setConstraints(this.mssAllResultsButton, c);
        all_options.add(this.mssAllResultsButton);
        Panel per_traj_options = new Panel();
        per_traj_options.setBackground(Color.GRAY);
        per_traj_options.setLayout(gridbag);
        this.per_traj_label = new Label("Trajectory (select from visual)", 1);
        this.trajectory_focus = new Button("Focus on Selected Trajectory");
        this.trajectory_focus.addActionListener(this);
        this.trajectory_info = new Button("Selected Trajectory Info");
        this.trajectory_info.addActionListener(this);
        this.plot_particle = new Button("");
        this.plot_particle.addActionListener(this);
        this.plot_particle.setEnabled(false);
        this.mssButton = new Button(" MSS/MSD plots ");
        this.mssButton.addActionListener(this);
        this.transfer_traj = new Button("Selected Trajectory to Table");
        this.transfer_traj.addActionListener(this);
        this.mssTrajectoryResultButton = new Button(" MSS/MSD to Table");
        this.mssTrajectoryResultButton.addActionListener(this);
        gridbag.setConstraints(this.per_traj_label, c);
        per_traj_options.add(this.per_traj_label);
        gridbag.setConstraints(this.trajectory_focus, c);
        per_traj_options.add(this.trajectory_focus);
        gridbag.setConstraints(this.trajectory_info, c);
        per_traj_options.add(this.trajectory_info);
        gridbag.setConstraints(this.plot_particle, c);
        per_traj_options.add(this.plot_particle);
        gridbag.setConstraints(this.transfer_traj, c);
        per_traj_options.add(this.transfer_traj);
        gridbag.setConstraints(this.mssButton, c);
        per_traj_options.add(this.mssButton);
        gridbag.setConstraints(this.mssTrajectoryResultButton, c);
        per_traj_options.add(this.mssTrajectoryResultButton);
        Panel area_options = new Panel();
        area_options.setBackground(Color.LIGHT_GRAY);
        area_options.setLayout(gridbag);
        this.area_label = new Label(" Area ", 1);
        this.area_focus = new Button(" Focus on Area ");
        this.area_focus.addActionListener(this);
        this.traj_in_area_info = new Button(" Trajectories in Area Info ");
        this.traj_in_area_info.addActionListener(this);
        this.dummy = new Button("");
        this.dummy.setEnabled(false);
        gridbag.setConstraints(this.area_label, c);
        area_options.add(this.area_label);
        gridbag.setConstraints(this.area_focus, c);
        area_options.add(this.area_focus);
        gridbag.setConstraints(this.traj_in_area_info, c);
        area_options.add(this.traj_in_area_info);
        gridbag.setConstraints(this.dummy, c);
        area_options.add(this.dummy);
        Panel all_panels = new Panel(new GridLayout(1, 3));
        all_panels.add(all_options);
        all_panels.add(per_traj_options);
        all_panels.add(area_options);
        c.weighty = 0.01;
        gridbag.setConstraints(all_panels, c);
        this.add(all_panels);
        Menu view = new Menu("View Preferences");
        this.mag_factor = new MenuItem("Magnification factor");
        this.mag_factor.addActionListener(this);
        view.add(this.mag_factor);
        Menu relink = new Menu("Relink Particles");
        this.relink_particles = new MenuItem("set new parameters for linking");
        this.relink_particles.addActionListener(this);
        relink.add(this.relink_particles);
        MenuBar mb = new MenuBar();
        mb.add(view);
        mb.add(relink);
        this.setMenuBar(mb);
        this.pack();
        WindowManager.addWindow((Frame)this);
        this.setSize((int)this.getMinimumSize().getWidth(), 512);
        GUI.center((Window)this);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        int id = e.getID();
        if (id == 201) {
            this.setVisible(false);
            this.dispose();
            WindowManager.removeWindow((Frame)this);
        } else if (id == 205) {
            WindowManager.setWindow((Frame)this);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        WindowManager.setWindow((Frame)this);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public synchronized void actionPerformed(ActionEvent ae) {
        Trajectory trajectory;
        Trajectory traj;
        Object source = ae.getSource();
        Roi user_roi = null;
        if (source == this.view_static) {
            this.particleTracker3DModular.resetTrajectoriesFilter();
            this.particleTracker3DModular.generateView(null, this.particleTracker3DModular.iTrajImg);
            return;
        }
        if (source == this.mssButton || source == this.mssTrajectoryResultButton || source == this.mssAllResultsButton) {
            ParticleTracker3DModular_.CalibrationData calData = this.particleTracker3DModular.getImageCalibrationData();
            if (calData.errorMsg == null) {
                this.pixelDimensions = calData.pixelDimension;
                this.timeInterval = calData.timeInterval;
            } else {
                IJ.error((String)calData.errorMsg);
                WindowManager.setCurrentWindow((ImageWindow)this.particleTracker3DModular.iInputImage.getWindow());
                IJ.run((String)"Properties...");
                return;
            }
        }
        if (source == this.save_report) {
            SaveDialog sd = new SaveDialog("Save report", IJ.getDirectory((String)"image"), "Traj_" + this.particleTracker3DModular.iResultFilesBaseTitle, ".txt");
            if (sd.getDirectory() == null || sd.getFileName() == null) {
                return;
            }
            MosaicUtils.write2File(sd.getDirectory(), sd.getFileName(), this.particleTracker3DModular.getFullReport().toString());
            return;
        }
        if (source == this.display_report) {
            this.text_panel.selectAll();
            this.text_panel.clearSelection();
            this.text_panel.append(this.particleTracker3DModular.getFullReport().toString());
            return;
        }
        if (source == this.area_focus || source == this.traj_in_area_info) {
            user_roi = IJ.getImage().getRoi();
            if (user_roi == null) {
                IJ.error((String)"The active image does not have a selection\nPlease select an area of interest first\nClick and drag the mouse on the active image.");
                return;
            }
            if (source == this.area_focus) {
                this.particleTracker3DModular.generateAreaFocusView(this.magnification_factor);
                return;
            }
            if (source == this.traj_in_area_info) {
                this.text_panel.selectAll();
                this.text_panel.clearSelection();
                block0: for (Trajectory traj2 : this.particleTracker3DModular.iTrajectories) {
                    for (int i = 0; i < traj2.iParticles.length; ++i) {
                        if (!user_roi.getBounds().contains(traj2.iParticles[i].iY, traj2.iParticles[i].iX) || !traj2.to_display) continue;
                        this.text_panel.appendLine("%% Trajectory " + traj2.iSerialNumber);
                        this.text_panel.append(this.particleTracker3DModular.trajectoryHeader());
                        this.text_panel.append(traj2.toString());
                        continue block0;
                    }
                }
                return;
            }
        }
        if ((source == this.trajectory_focus || source == this.trajectory_info || source == this.transfer_traj || source == this.mssButton || source == this.mssTrajectoryResultButton) && this.particleTracker3DModular.chosen_traj == -1) {
            IJ.error((String)"Please select a trajectory first\nClick with the mouse on a trajectory in 'All trajectories' display");
            return;
        }
        if (source == this.trajectory_focus) {
            this.particleTracker3DModular.generateTrajFocusView(this.particleTracker3DModular.chosen_traj);
            return;
        }
        if (source == this.trajectory_info) {
            traj = this.particleTracker3DModular.iTrajectories.elementAt(this.particleTracker3DModular.chosen_traj);
            this.text_panel.selectAll();
            this.text_panel.clearSelection();
            this.text_panel.appendLine("%% Trajectory " + traj.iSerialNumber);
            this.text_panel.append(this.particleTracker3DModular.trajectoryHeader());
            this.text_panel.append(traj.toString());
            return;
        }
        if (source == this.transfer_traj) {
            traj = this.particleTracker3DModular.iTrajectories.elementAt(this.particleTracker3DModular.chosen_traj);
            this.particleTracker3DModular.transferSelectedTrajectoriesToResultTable(traj).show("Results");
            return;
        }
        if (source == this.mag_factor) {
            String[] mag_choices = new String[]{"1", "2", "4", "6", "8", "10"};
            GenericDialog mag_dialog = new GenericDialog("Select Magnification Factor");
            mag_dialog.addChoice("Magnification factor", mag_choices, "" + this.magnification_factor);
            mag_dialog.showDialog();
            if (mag_dialog.wasCanceled()) {
                return;
            }
            this.magnification_factor = Integer.parseInt(mag_dialog.getNextChoice());
            return;
        }
        if (source == this.relink_particles) {
            GenericDialog relink_dialog = new GenericDialog("Select new linking parameters");
            relink_dialog.addNumericField("Link Range", (double)this.particleTracker3DModular.iLinkRange, 0);
            relink_dialog.addNumericField("Displacement", this.particleTracker3DModular.displacement, 2);
            relink_dialog.showDialog();
            if (relink_dialog.wasCanceled()) {
                return;
            }
            this.particleTracker3DModular.iLinkRange = (int)relink_dialog.getNextNumber();
            this.particleTracker3DModular.displacement = relink_dialog.getNextNumber();
            this.particleTracker3DModular.iTrajectories = null;
            IJ.showStatus((String)"Linking Particles");
            boolean linkParticlesResult = this.particleTracker3DModular.linkParticles();
            if (!linkParticlesResult) {
                return;
            }
            IJ.showStatus((String)"Generating Trajectories");
            this.particleTracker3DModular.generateTrajectories();
            this.particleTracker3DModular.assignColorsToTrajectories();
            this.particleTracker3DModular.iTrajImg = this.particleTracker3DModular.createHyperStackFromFrames();
            this.configuration_panel.selectAll();
            this.configuration_panel.clearSelection();
            this.configuration_panel.append(this.particleTracker3DModular.getConfiguration().toString());
            this.configuration_panel.append(this.particleTracker3DModular.getInputFramesInformation().toString());
            this.text_panel.selectAll();
            this.text_panel.clearSelection();
            this.text_panel.appendLine("Relinking DONE!");
            this.text_panel.appendLine("Found " + this.particleTracker3DModular.iTrajectories.size() + " Trajectories");
            return;
        }
        if (source == this.transfer_particles) {
            this.particleTracker3DModular.generateResultsTableWithParticles().show("Results");
            return;
        }
        if (source == this.transfer_trajs) {
            this.particleTracker3DModular.generateResultsTableWithTrajectories().show("Results");
            return;
        }
        if (source == this.mssTrajectoryResultButton) {
            trajectory = this.particleTracker3DModular.iTrajectories.elementAt(this.particleTracker3DModular.chosen_traj);
            this.particleTracker3DModular.mssTrajectoryResultsToTable(trajectory, this.pixelDimensions, this.timeInterval);
            return;
        }
        if (source == this.mssAllResultsButton) {
            this.particleTracker3DModular.mssAllResultsToTable(this.pixelDimensions, this.timeInterval);
            return;
        }
        if (source == this.mssButton) {
            trajectory = this.particleTracker3DModular.iTrajectories.elementAt(this.particleTracker3DModular.chosen_traj);
            new TrajectoryAnalysisPlot(trajectory, this.pixelDimensions, this.timeInterval);
            return;
        }
        IJ.error((String)("Unhandled event: [" + ae.getActionCommand() + "]"));
    }
}

