/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import net.imglib2.Cursor;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class ColorSubstitution
implements ExtendedPlugInFilter {
    <T extends RealType<T> & NativeType<T>> void substitute(ImagePlus imp, double col_from, double col_to) {
        ImagePlusImg image = ImagePlusAdapter.wrap((ImagePlus)imp);
        Cursor cur = image.cursor();
        while (cur.hasNext()) {
            cur.next();
            if ((double)((RealType)cur.get()).getRealFloat() != col_from) continue;
            ((RealType)cur.get()).setReal(col_to);
        }
        imp.repaintWindow();
    }

    public int setup(String arg, ImagePlus imp) {
        return 13;
    }

    public int showDialog(ImagePlus imp, String arg1, PlugInFilterRunner arg2) {
        GenericDialog gd = new GenericDialog("Color substitution");
        gd.addNumericField("Change color value from:", 0.0, 3);
        gd.addNumericField("                   to:  ", 0.0, 3);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        double col_from = gd.getNextNumber();
        double col_to = gd.getNextNumber();
        this.substitute(imp, col_from, col_to);
        return 4096;
    }

    public void run(ImageProcessor ip) {
    }

    public void setNPasses(int arg0) {
    }
}

