/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.PlugInInterpreter;
import ij.plugin.PluginInstaller;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class JythonLauncher
implements PlugIn {
    private static boolean downloadJar(String url) {
        String name = url.substring(url.lastIndexOf("/") + 1);
        boolean ok = false;
        String msg = name + " was not found in the plugins\nfolder or it is outdated. Click \"OK\" to download\nit from the ImageJ website.";
        GenericDialog gd = new GenericDialog("Download " + name + "?");
        gd.addMessage(msg);
        gd.showDialog();
        if (!gd.wasCanceled() && !(ok = new PluginInstaller().install("http://imagej.nih.gov/ij" + url))) {
            IJ.error((String)("Unable to download " + name + " from " + "http://imagej.nih.gov/ij" + url));
        }
        return ok;
    }

    private static void runScript(Object plugin, String script, String arg) {
        if (plugin instanceof PlugInInterpreter) {
            PlugInInterpreter interp = (PlugInInterpreter)plugin;
            interp.run(script, arg);
        }
    }

    private static void runPython(String script, String arg) {
        boolean ok;
        Object jython;
        if (arg == null) {
            arg = "";
        }
        if ((jython = IJ.runPlugIn((String)"Jython", (String)"")) == null && (ok = JythonLauncher.downloadJar("/plugins/jython/Jython.jar"))) {
            jython = IJ.runPlugIn((String)"Jython", (String)"");
        }
        if (jython != null) {
            JythonLauncher.runScript(jython, script, arg);
        }
    }

    public void run(String arg) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(arg);
        String theString = null;
        try {
            theString = IOUtils.toString((InputStream)stream);
            JythonLauncher.runPython(theString, "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Class<JythonLauncher> clazz = JythonLauncher.class;
        String url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class").toString();
        String pluginsDir = url.substring("file:".length(), url.length() - clazz.getName().length() - ".class".length());
        System.setProperty("plugins.dir", pluginsDir);
        new ImageJ();
        ImagePlus image = IJ.openImage((String)"http://imagej.net/images/clown.jpg");
        image.show();
        IJ.runPlugIn((String)clazz.getName(), (String)"");
    }
}

