/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import mosaic.plugins.utils.PlugInBase;
import mosaic.plugins.utils.PlugInFloatBase;
import mosaic.utils.ImgUtils;
import mosaic.utils.math.Matlab;
import mosaic.utils.math.Matrix;

public class LaplaceFilter
extends PlugInFloatBase {
    @Override
    protected void processImg(FloatProcessor aOutputImg, FloatProcessor aOrigImg, int aChannelNumber) {
        int w = aOutputImg.getWidth();
        int h = aOutputImg.getHeight();
        double[][] img = new double[h][w];
        ImgUtils.ImgToYX2Darray(aOrigImg, img, 1.0);
        Matrix imgMatrix = new Matrix(img);
        Matrix m1 = Matlab.imfilterSymmetric(imgMatrix, new Matrix(new double[][]{{0.0, 1.0, 0.0}, {1.0, -4.0, 1.0}, {0.0, 1.0, 0.0}}));
        double[][] result = m1.getArrayYX();
        ImgUtils.YX2DarrayToImg(result, aOutputImg, 1.0);
    }

    @Override
    protected void postprocessBeforeShow() {
        this.iProcessedImg.resetDisplayRange();
    }

    @Override
    protected boolean showDialog() {
        return true;
    }

    @Override
    protected boolean setup(String aArgs) {
        this.setResultDestination(PlugInBase.ResultOutput.NEW_BY_PLUGIN);
        this.iProcessedImg = ImgUtils.createNewEmptyImgPlus(this.iInputImg, "laplace_" + this.iInputImg.getTitle(), 1.0, 1.0, ImgUtils.OutputType.FLOAT);
        this.updateFlags(31);
        return true;
    }

    public static void main(String[] args) {
        Class<LaplaceFilter> clazz = LaplaceFilter.class;
        String url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class").toString();
        String pluginsDir = url.substring("file:".length(), url.length() - clazz.getName().length() - ".class".length());
        System.setProperty("plugins.dir", pluginsDir);
        new ImageJ();
        ImagePlus image = IJ.openImage((String)"https://upload.wikimedia.org/wikipedia/commons/3/3f/Bikesgray.jpg");
        image.show();
        IJ.runPlugIn((String)clazz.getName(), (String)"");
    }
}

