/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mosaic.plugins.utils.CurvatureFilterBase;
import mosaic.utils.ImgUtils;
import mosaic.variationalCurvatureFilters.CurvatureFilter;

public class SuperResolution
extends CurvatureFilterBase {
    private void superResolution(FloatProcessor aInputIp, FloatProcessor aOriginalIp, CurvatureFilter aFilter, int aNumberOfIterations) {
        int originalWidth = aOriginalIp.getWidth();
        int originalHeight = aOriginalIp.getHeight();
        int superHeight = originalHeight * 2;
        int superWidth = originalWidth * 2;
        float[][] img = new float[superHeight][superWidth];
        float maxValueOfPixel = (float)aInputIp.getMax();
        if (maxValueOfPixel < 1.0f) {
            maxValueOfPixel = 1.0f;
        }
        this.convertToArrayAndNormalize((ImageProcessor)aOriginalIp, img, maxValueOfPixel);
        aFilter.runFilter(img, aNumberOfIterations, new CurvatureFilter.Mask(){

            @Override
            public boolean shouldBeProcessed(int x, int y) {
                return x % 2 != 1 || y % 2 != 1;
            }
        });
        ImgUtils.YX2DarrayToImg(img, aInputIp, maxValueOfPixel);
    }

    private void convertToArrayAndNormalize(ImageProcessor aInputIp, float[][] aNewImgArray, float aNormalizationValue) {
        float[] pixels = (float[])aInputIp.getPixels();
        int w = aInputIp.getWidth();
        int h = aInputIp.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                aNewImgArray[2 * y + 1][2 * x + 1] = pixels[x + y * w] / aNormalizationValue;
            }
        }
    }

    @Override
    protected boolean setup(String aArgs) {
        this.setFilePrefix("resized_");
        this.updateFlags(31);
        this.setScaleX(2.0);
        this.setScaleY(2.0);
        return true;
    }

    @Override
    protected void processImg(FloatProcessor aOutputImg, FloatProcessor aOrigImg, int aChannelNumber) {
        this.superResolution(aOutputImg, aOrigImg, this.getCurvatureFilter(), this.getNumberOfIterations());
    }
}

