/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.process.FloatProcessor;
import mosaic.plugins.utils.CurvatureFilterBase;
import mosaic.plugins.utils.PlugInBase;
import mosaic.utils.ImgUtils;
import mosaic.variationalCurvatureFilters.CurvatureFilter;

public class VariationalCurvatureFilter
extends CurvatureFilterBase {
    private void filterImage(FloatProcessor aOutputIp, FloatProcessor aOriginalIp, CurvatureFilter aFilter, int aNumberOfIterations) {
        int originalWidth = aOriginalIp.getWidth();
        int originalHeight = aOriginalIp.getHeight();
        int roundedWidth = (int)(Math.ceil((double)originalWidth / 2.0) * 2.0);
        int roundedHeight = (int)(Math.ceil((double)originalHeight / 2.0) * 2.0);
        float[][] img = new float[roundedHeight][roundedWidth];
        float maxValueOfPixel = (float)aOriginalIp.getMax();
        if (maxValueOfPixel < 1.0f) {
            maxValueOfPixel = 1.0f;
        }
        ImgUtils.ImgToYX2Darray(aOriginalIp, img, maxValueOfPixel);
        aFilter.runFilter(img, aNumberOfIterations);
        ImgUtils.YX2DarrayToImg(img, aOutputIp, maxValueOfPixel);
    }

    @Override
    protected boolean setup(String aArgs) {
        if (aArgs.equals("updateOriginal")) {
            this.setResultDestination(PlugInBase.ResultOutput.UPDATE_ORIGINAL);
        }
        this.setFilePrefix("filtered_");
        this.updateFlags(31);
        this.setSplitMethodMenu(true);
        return true;
    }

    @Override
    protected void processImg(FloatProcessor aOutputImg, FloatProcessor aOrigImg, int aChannelNumber) {
        this.filterImage(aOutputImg, aOrigImg, this.getCurvatureFilter(), this.getNumberOfIterations());
    }
}

