/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins.utils;

import ij.IJ;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import mosaic.plugins.utils.PlugInBase;

public abstract class PlugInFloatBase
extends PlugInBase {
    private int iFlags = 98336;

    protected abstract void processImg(FloatProcessor var1, FloatProcessor var2, int var3);

    @Override
    protected int getFlags() {
        return this.iFlags;
    }

    @Override
    protected void updateFlags(int aFlag) {
        this.iFlags |= aFlag;
    }

    public void run(ImageProcessor aIp) {
        int i;
        IJ.showStatus((String)"In progress...");
        int noOfChannels = aIp.getNChannels();
        ArrayList<Thread> th = new ArrayList<Thread>(noOfChannels);
        ArrayList<ProcessOneChannel> poc = new ArrayList<ProcessOneChannel>(noOfChannels);
        for (i = 0; i < noOfChannels; ++i) {
            FloatProcessor res = null;
            ImageProcessor currentIp = null;
            if (this.iResultOutput != PlugInBase.ResultOutput.NONE) {
                currentIp = this.iProcessedImg.getStack().getProcessor(aIp.getSliceNumber());
                res = currentIp.toFloat(i, null);
            }
            FloatProcessor orig = aIp.toFloat(i, null);
            orig.setSliceNumber(aIp.getSliceNumber());
            ProcessOneChannel p = new ProcessOneChannel(currentIp, res, orig, i);
            Thread t = new Thread(p);
            t.start();
            th.add(t);
            poc.add(p);
        }
        for (i = 0; i < noOfChannels; ++i) {
            try {
                ((Thread)th.get(i)).join();
                ((ProcessOneChannel)poc.get(i)).update();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        IJ.showStatus((String)"Done.");
    }

    private class ProcessOneChannel
    implements Runnable {
        int i;
        ImageProcessor currentIp;
        FloatProcessor res;
        FloatProcessor orig;

        ProcessOneChannel(ImageProcessor currentIp, FloatProcessor res, FloatProcessor orig, int aChannel) {
            this.i = aChannel;
            this.currentIp = currentIp;
            this.res = res;
            this.orig = orig;
        }

        @Override
        public void run() {
            PlugInFloatBase.this.processImg(this.res, this.orig, this.i);
        }

        public void update() {
            if (PlugInFloatBase.this.iResultOutput != PlugInBase.ResultOutput.NONE) {
                this.currentIp.setPixels(this.i, this.res);
            }
        }
    }
}

