/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins.utils.templatePlugins;

import ij.process.ByteProcessor;
import mosaic.plugins.utils.PlugIn8bitBase;

public class HistogramEqualizationPlugin
extends PlugIn8bitBase {
    @Override
    protected void processImg(ByteProcessor aOutputImg, ByteProcessor aOrigImg, int aChannelNumber) {
        byte[] pixels = (byte[])aOrigImg.getPixelsCopy();
        this.do8bitHistogramEqualization(pixels);
        aOutputImg.setPixels((Object)pixels);
    }

    private void do8bitHistogramEqualization(byte[] aImgPixels) {
        int i;
        int i2;
        int GRAY_LEVELS = 256;
        int[] hist = new int[256];
        for (i2 = 0; i2 < aImgPixels.length; ++i2) {
            int pv;
            int n = pv = aImgPixels[i2] & 0xFF;
            hist[n] = hist[n] + 1;
        }
        for (i2 = 1; i2 < 256; ++i2) {
            hist[i2] = hist[i2] + hist[i2 - 1];
        }
        double[] T = new double[256];
        double G = 256.0;
        double N_M = aImgPixels.length;
        for (i = 0; i < 256; ++i) {
            T[i] = (double)hist[i] * 255.0 / N_M;
        }
        for (i = 0; i < aImgPixels.length; ++i) {
            int pv = aImgPixels[i] & 0xFF;
            double d = T[pv];
            aImgPixels[i] = (byte)d;
        }
    }

    @Override
    protected boolean showDialog() {
        return true;
    }

    @Override
    protected boolean setup(String aArgs) {
        this.setFilePrefix("equalized_");
        return true;
    }
}

