/*
 * Decompiled with CFR 0.152.
 */
package mosaic.psf2d;

import ij.process.ImageProcessor;
import mosaic.psf2d.PsfSourcePosition;
import mosaic.utils.ArrayOps;
import mosaic.utils.ConvertArray;
import mosaic.utils.math.Interpolation;

public class PsfSampler {
    private float[] iPsf;
    private float[] iRadius;
    private final StringBuffer iPsfData = new StringBuffer("");

    public PsfSampler(ImageProcessor aInputImg, PsfSourcePosition aPsfCoords, int aMaxRadius, int aNumOfSamples, int aMagnificationFactor, float aMagnification, float aPixelSize) {
        ImageProcessor fp = aInputImg.convertToFloat();
        double[][] img2d = ConvertArray.toDouble2D(ConvertArray.toDouble((float[])fp.getPixels()), fp.getWidth(), fp.getHeight());
        int numOfCircles = aMaxRadius * aMagnificationFactor + 1;
        this.iPsf = new float[numOfCircles];
        this.iRadius = new float[numOfCircles];
        for (int j = 0; j < numOfCircles; ++j) {
            float currentRadius = (float)j / (float)aMagnificationFactor;
            this.iPsf[j] = 0.0f;
            for (int i = 0; i < aNumOfSamples; ++i) {
                double angleOfSample = (double)i / (double)aNumOfSamples * (Math.PI * 2);
                float xPosOfSample = aPsfCoords.iX + currentRadius * (float)Math.cos(angleOfSample);
                float yPosOfSample = aPsfCoords.iY + currentRadius * (float)Math.sin(angleOfSample);
                this.iPsfData.append("(" + xPosOfSample + ", " + yPosOfSample + "); ");
                int n = j;
                this.iPsf[n] = (float)((double)this.iPsf[n] + Interpolation.bicubicInterpolation(xPosOfSample, yPosOfSample, img2d, Interpolation.InterpolationMode.NONE));
            }
            int n = j;
            this.iPsf[n] = this.iPsf[n] / (float)aNumOfSamples;
            this.iRadius[j] = 1000.0f * currentRadius * aPixelSize / aMagnification;
            this.iPsfData.append("\n\n%Radius:\t" + this.iRadius[j] + " nm");
            this.iPsfData.append("\n%Sampling Positions of Point Source:\n");
            this.iPsfData.append("\n%Overall Mean Intensity Value on Radius:\t" + this.iPsf[j] + "\n");
        }
        ArrayOps.normalize(this.iPsf);
    }

    public float[] getPsf() {
        return this.iPsf;
    }

    public float[] getRadius() {
        return this.iRadius;
    }

    public StringBuffer getPsfReport() {
        return this.iPsfData;
    }
}

