/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.DRS;

import ij.ImagePlus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.convolution.Convolver;
import mosaic.core.imageUtils.convolution.Gauss1D;
import mosaic.core.imageUtils.images.IntensityImage;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.imageUtils.iterators.SpaceIterator;
import mosaic.regions.DRS.Particle;
import mosaic.regions.DRS.ParticleSet;
import mosaic.regions.DRS.Rng;
import mosaic.regions.DRS.SettingsDRS;
import mosaic.regions.GUI.SegmentationProcessWindow;
import mosaic.regions.RC.ContourParticle;
import mosaic.regions.energies.Energy;
import mosaic.regions.energies.ImageModel;
import mosaic.regions.topology.TopologicalNumber;
import mosaic.regions.utils.LabelStatisticToolbox;
import mosaic.regions.utils.LabelStatistics;
import mosaic.utils.Debug;
import mosaic.utils.math.IndexedDiscreteDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.log4j.Logger;

public class AlgorithmDRS {
    private static final Logger logger = Logger.getLogger(AlgorithmDRS.class);
    private final LabelImage iLabelImage;
    private final IntensityImage iIntensityImage;
    private final IntensityImage iEdgeImage;
    private final ImageModel iImageModel;
    private final SettingsDRS iSettings;
    private int iAcceptedMoves = 0;
    private int iIterationCounter = 0;
    private Rng iRng = new Rng(1212);
    private Rng iDistrRng = new Rng();
    private Point[] iFgNeighborsOffsets;
    private int[] iFgNeighborsIndices;
    private Point[] iBgNeighborsOffsets;
    private int[] iBgNeighborsIndices;
    private TopologicalNumber iTopoFunction;
    private float[] iLengthProposalMask = null;
    private IndexedDiscreteDistribution iEdgeImageDistr = null;
    private List<Integer> iLabels = new ArrayList<Integer>();
    private Map<Integer, Float> iParentsProposalNormalizer = new HashMap<Integer, Float>();
    private Map<Integer, Float> iChildrenProposalNormalizer = new HashMap<Integer, Float>();
    private float iTotalNormalizer;
    private Map<Integer, ParticleSet> iChildren = new HashMap<Integer, ParticleSet>();
    private Map<Integer, ParticleSet> iParents = new HashMap<Integer, ParticleSet>();
    private ParticleSet iFloatingParticles = new ParticleSet();
    private float iFloatingParticlesProposalNormalizer = 0.0f;
    private List<ParticleHistoryElement> iParticlesHistory = new ArrayList<ParticleHistoryElement>();
    private List<ParticleHistoryElement> iFloatingParticlesHistory = new ArrayList<ParticleHistoryElement>();
    private final HashMap<Integer, LabelStatistics> iLabelStatistics = new HashMap();
    private Map<Integer, List<McmcResult>> iMcmcResults = new HashMap<Integer, List<McmcResult>>();
    private List<LabelImageHistoryEvent> iLabelImageHistory = new ArrayList<LabelImageHistoryEvent>();
    private int iMcmcStepSize = 1;
    private float iMcmcTemperature = 1.0f;
    private float[] Q_A = new float[this.iMcmcStepSize];
    private int[] currentLabelAtParticleA = new int[this.iMcmcStepSize];
    private Particle[] candidateToMoveParticleA = new Particle[this.iMcmcStepSize];
    private float[] Q_B = new float[this.iMcmcStepSize];
    private int[] currentLabelAtParticleB = new int[this.iMcmcStepSize];
    private Particle[] partnerToMoveParticleB = new Particle[this.iMcmcStepSize];
    private float[] Q_A_B = new float[this.iMcmcStepSize];
    private float[] Q_B_A = new float[this.iMcmcStepSize];
    private float[] Qb_A = new float[this.iMcmcStepSize];
    private float[] Qb_B = new float[this.iMcmcStepSize];
    private float[] Qb_A_B = new float[this.iMcmcStepSize];
    private float[] Qb_B_A = new float[this.iMcmcStepSize];
    private boolean[] isParticleAfloating = new boolean[this.iMcmcStepSize];
    private boolean[] isParticleAbFloating = new boolean[this.iMcmcStepSize];
    private boolean[] isParticleBbFloating = new boolean[this.iMcmcStepSize];

    public AlgorithmDRS(IntensityImage aIntensityImage, LabelImage aLabelImage, ImageModel aModel, SettingsDRS aSettings) {
        logger.debug((Object)("DRS algorithm created with settings:" + Debug.getJsonString(aSettings)));
        this.iLabelImage = aLabelImage;
        this.iIntensityImage = aIntensityImage;
        logger.debug((Object)"Generating edge image");
        this.iEdgeImage = this.generateEdgeImage(this.iIntensityImage);
        this.iImageModel = aModel;
        this.iSettings = aSettings;
        this.iLabelImage.initBorder();
        logger.debug((Object)"Initializing conectivities");
        this.initConnectivities();
        logger.debug((Object)"Initializing distribution");
        this.initEdgeDistribution();
        logger.debug((Object)"Initializing length proposal");
        this.initLenghtProposal();
        logger.debug((Object)"Initializing labels");
        this.initLabels();
        logger.debug((Object)"Initializing statistics");
        LabelStatisticToolbox.initStatistics(this.iLabelImage, this.iIntensityImage, this.iLabelStatistics);
    }

    private void initConnectivities() {
        int i;
        this.iFgNeighborsOffsets = this.iLabelImage.getConnFG().getPointOffsets();
        this.iFgNeighborsIndices = new int[this.iFgNeighborsOffsets.length];
        for (i = 0; i < this.iFgNeighborsOffsets.length; ++i) {
            this.iFgNeighborsIndices[i] = this.iLabelImage.pointToIndex(this.iFgNeighborsOffsets[i]);
        }
        this.iBgNeighborsOffsets = this.iLabelImage.getConnBG().getPointOffsets();
        this.iBgNeighborsIndices = new int[this.iBgNeighborsOffsets.length];
        for (i = 0; i < this.iBgNeighborsOffsets.length; ++i) {
            this.iBgNeighborsIndices[i] = this.iLabelImage.pointToIndex(this.iBgNeighborsOffsets[i]);
        }
        this.iTopoFunction = new TopologicalNumber(this.iLabelImage);
    }

    private void initLenghtProposal() {
        if (this.iSettings.useBiasedProposal) {
            this.iLengthProposalMask = new float[this.iBgNeighborsOffsets.length];
            for (int i = 0; i < this.iBgNeighborsOffsets.length; ++i) {
                this.iLengthProposalMask[i] = (float)(1.0 / this.iBgNeighborsOffsets[i].length());
            }
        }
    }

    private void initLabels() {
        this.iLabels.add(0);
        this.iParentsProposalNormalizer.put(0, Float.valueOf(0.0f));
        this.iChildrenProposalNormalizer.put(0, Float.valueOf(0.0f));
        this.iTotalNormalizer = 0.0f;
        HashSet<Integer> visitedLabels = new HashSet<Integer>();
        visitedLabels.add(0);
        Iterator<Integer> ri = new SpaceIterator(this.iLabelImage.getDimensions()).getIndexIterator();
        while (ri.hasNext()) {
            int idx = ri.next();
            int label = this.iLabelImage.getLabel(idx);
            if (this.iLabelImage.isBorderLabel(label)) continue;
            int labelAbs = this.iLabelImage.labelToAbs(label);
            if (!visitedLabels.contains(labelAbs)) {
                visitedLabels.add(labelAbs);
                this.iLabels.add(label);
                this.iParentsProposalNormalizer.put(labelAbs, Float.valueOf(0.0f));
                this.iChildrenProposalNormalizer.put(labelAbs, Float.valueOf(0.0f));
            }
            for (Particle particle : this.getRegularParticles(idx, new ParticleSet())) {
                if (!this.isParticleTopoValid(particle)) continue;
                this.insertCandidatesToContainers(particle, label, false);
                this.iLabelImage.setLabel(idx, -labelAbs);
            }
        }
    }

    public void runOneIteration() {
        ++this.iIterationCounter;
        this.iAcceptedMoves += this.runIteration() ? 1 : 0;
        if (this.iIterationCounter == this.iSettings.maxNumOfIterations) {
            logger.info((Object)("Overall acceptance rate: " + (float)this.iAcceptedMoves / (float)this.iIterationCounter));
        }
    }

    private boolean runIteration() {
        boolean accept;
        Particle particleA;
        int i;
        double probabilityOfFloatingParticle;
        float offBoundaryPerc;
        this.iParticlesHistory.clear();
        this.iFloatingParticlesHistory.clear();
        this.iLabelImageHistory.clear();
        for (int i2 = 0; i2 < this.iMcmcStepSize; ++i2) {
            this.isParticleAbFloating[i2] = false;
            this.isParticleBbFloating[i2] = false;
            this.isParticleAfloating[i2] = false;
        }
        if (this.iLabels.size() < 2) {
            throw new IllegalStateException("No active region for MCMC available in iteration: " + this.iIterationCounter);
        }
        int sampledIndex = this.iRng.GetIntegerVariate(this.iLabels.size() - 2) + 1;
        int sampledLabel = this.iLabels.get(sampledIndex);
        if (this.iSettings.allowFission && this.iSettings.allowFusion && this.iSettings.offBoundarySampleProbability > 0.0f && (offBoundaryPerc = this.iSettings.offBoundarySampleProbability * (1.0f - (float)this.iIterationCounter / (this.iSettings.burnInFactor * (float)this.iSettings.maxNumOfIterations))) > 0.0f && this.iRng.GetVariate() < (double)offBoundaryPerc) {
            return this.sampleOffBoundary(sampledLabel);
        }
        boolean particleAisFloating = false;
        ParticleSet activeCandidates = null;
        double rand = this.iRng.GetUniformVariate(0.0, 1.0);
        if (rand < (probabilityOfFloatingParticle = (double)(this.iFloatingParticlesProposalNormalizer / (this.iTotalNormalizer + this.iFloatingParticlesProposalNormalizer)))) {
            activeCandidates = this.iFloatingParticles;
            particleAisFloating = true;
        } else {
            ParticleSet particleSet = activeCandidates = rand < (probabilityOfFloatingParticle + 1.0) / 2.0 ? this.iChildren.get(sampledLabel) : this.iParents.get(sampledLabel);
        }
        if (activeCandidates.size() == 0) {
            this.resetLabelsToParents();
            return false;
        }
        int approxedIndexOffset = 0;
        IndexedDiscreteDistribution candidatesProposalsDistr = null;
        if (this.iSettings.useBiasedProposal && !particleAisFloating) {
            boolean approxedIndex;
            int NumberOfSamplesForBiasedProposalApproximation = 30;
            int size = activeCandidates.size() < 30 ? activeCandidates.size() : 30;
            boolean bl = approxedIndex = size == 30;
            if (approxedIndex) {
                approxedIndexOffset = this.iRng.GetIntegerVariate(activeCandidates.size() - 1);
            }
            double[] allParticlesProposals = new double[size];
            for (int k = 0; k < size; ++k) {
                int idx = (k + approxedIndexOffset) % activeCandidates.size();
                allParticlesProposals[k] = activeCandidates.get((int)idx).iProposal;
            }
            candidatesProposalsDistr = new IndexedDiscreteDistribution((RandomGenerator)this.iDistrRng, allParticlesProposals);
        }
        for (int i3 = 0; i3 < this.iMcmcStepSize; ++i3) {
            int particleIndex;
            if (this.iSettings.useBiasedProposal && !particleAisFloating && candidatesProposalsDistr != null) {
                particleIndex = candidatesProposalsDistr.sample();
                particleIndex = (particleIndex + approxedIndexOffset) % activeCandidates.size();
                this.Q_A[i3] = activeCandidates.get((int)particleIndex).iProposal;
            } else {
                particleIndex = this.iRng.GetIntegerVariate(activeCandidates.size() - 1);
                this.Q_A[i3] = 1.0f;
            }
            Particle particleA2 = activeCandidates.get(particleIndex);
            int currentAbsLabelAtA = this.iLabelImage.getLabelAbs(particleA2.iIndex);
            if (particleAisFloating) {
                this.isParticleAfloating[i3] = true;
                if (currentAbsLabelAtA == particleA2.iCandidateLabel) {
                    return false;
                }
                if (this.isRegularParticle(particleA2, currentAbsLabelAtA)) {
                    return false;
                }
                this.eraseFloatingParticle(particleA2, true);
            }
            int n = i3;
            this.Q_A[n] = this.Q_A[n] / (this.isParticleAfloating[i3] ? this.iFloatingParticlesProposalNormalizer : this.getProposalNormalizer(currentAbsLabelAtA, particleA2.iCandidateLabel));
            this.currentLabelAtParticleA[i3] = currentAbsLabelAtA;
            this.candidateToMoveParticleA[i3] = particleA2;
        }
        boolean singleParticleMoveForPairProposals = false;
        if (this.iSettings.usePairProposal) {
            for (int i4 = 0; i4 < this.iMcmcStepSize; ++i4) {
                Particle vB;
                Particle particleA3 = this.candidateToMoveParticleA[i4];
                Particle vA = new Particle(particleA3.iIndex, particleA3.iCandidateLabel, this.calculateProposal(particleA3.iIndex));
                this.applyParticle(particleA3, true);
                this.isParticleAbFloating[i4] = this.isParticleFloating(particleA3.iIndex, particleA3.iCandidateLabel);
                ParticleSet particles_Q_B_A = this.getPartnerParticles(vA);
                if (this.iSettings.useBiasedProposal) {
                    double[] proposals_Q_B_A = new double[particles_Q_B_A.size()];
                    float normalizer_Q_B_A = 0.0f;
                    for (int k = 0; k < particles_Q_B_A.size(); ++k) {
                        proposals_Q_B_A[k] = particles_Q_B_A.get((int)k).iProposal;
                        normalizer_Q_B_A = (float)((double)normalizer_Q_B_A + proposals_Q_B_A[k]);
                    }
                    IndexedDiscreteDistribution vQ_B_A = new IndexedDiscreteDistribution((RandomGenerator)this.iDistrRng, proposals_Q_B_A);
                    vB = particles_Q_B_A.get(vQ_B_A.sample());
                    this.Q_B_A[i4] = vB.iProposal / normalizer_Q_B_A;
                } else {
                    vB = particles_Q_B_A.get(this.iRng.GetIntegerVariate(particles_Q_B_A.size() - 1));
                    this.Q_B_A[i4] = 1.0f / (float)particles_Q_B_A.size();
                }
                this.partnerToMoveParticleB[i4] = vB;
                this.currentLabelAtParticleB[i4] = this.iLabelImage.getLabelAbs(vB.iIndex);
                if (vB.iIndex == vA.iIndex && vB.iCandidateLabel == vA.iCandidateLabel) {
                    singleParticleMoveForPairProposals = true;
                    this.currentLabelAtParticleB[i4] = this.currentLabelAtParticleA[i4];
                }
                Particle vReverseParticleA = new Particle(particleA3.iIndex, this.currentLabelAtParticleA[i4], particleA3.iProposal);
                if (singleParticleMoveForPairProposals) {
                    this.applyParticle(vReverseParticleA, true);
                }
                ParticleSet particles_Qb_A_B = this.getPartnerParticles(vB);
                if (this.iSettings.useBiasedProposal) {
                    float normalizer_Qb_A_B = 0.0f;
                    for (Particle p : particles_Qb_A_B) {
                        normalizer_Qb_A_B += p.iProposal;
                    }
                    this.Qb_A_B[i4] = this.calculateProposal(vA.iIndex) / normalizer_Qb_A_B;
                } else {
                    this.Qb_A_B[i4] = 1.0f / (float)particles_Qb_A_B.size();
                }
                if (singleParticleMoveForPairProposals) continue;
                this.applyParticle(vReverseParticleA, true);
                this.Q_B[i4] = 0.0f;
                if (!this.isRegularParticle(vB, this.currentLabelAtParticleB[i4])) continue;
                this.Q_B[i4] = (this.iSettings.useBiasedProposal ? this.calculateProposal(vB.iIndex) : 1.0f) / this.getProposalNormalizer(this.currentLabelAtParticleB[i4], vB.iCandidateLabel);
            }
        }
        ParticleSet appliedParticles = new ParticleSet();
        ArrayList<Integer> appliedParticleOrigLabels = new ArrayList<Integer>();
        float energyDiff = 0.0f;
        for (int i5 = 0; i5 < this.iMcmcStepSize; ++i5) {
            int numOfParticlesToApply;
            Particle particleA4 = this.candidateToMoveParticleA[i5];
            Particle particleB = this.partnerToMoveParticleB[i5];
            int n = numOfParticlesToApply = this.iSettings.usePairProposal && !singleParticleMoveForPairProposals ? 2 : 1;
            while (numOfParticlesToApply > 0) {
                int originalLabel;
                boolean shouldProcessB = numOfParticlesToApply > 1;
                Particle currentMinimalParticle = shouldProcessB ? particleB : particleA4;
                int n2 = originalLabel = shouldProcessB ? this.currentLabelAtParticleB[i5] : this.currentLabelAtParticleA[i5];
                if (!appliedParticles.contains(currentMinimalParticle)) {
                    energyDiff += this.calculateEnergyDifference(currentMinimalParticle.iIndex, originalLabel, currentMinimalParticle.iCandidateLabel, this.iIntensityImage.get(currentMinimalParticle.iIndex));
                    this.applyParticle(currentMinimalParticle, false);
                    appliedParticles.insert(currentMinimalParticle);
                    appliedParticleOrigLabels.add(originalLabel);
                }
                if (shouldProcessB) {
                    ParticleSet particles_Q_A_B = this.getRegularParticlesInFgNeighborhood(particleB.iIndex);
                    particleB.iProposal = this.calculateProposal(particleB.iIndex);
                    particles_Q_A_B.insert(particleB);
                    if (this.iSettings.useBiasedProposal) {
                        float normalizer_Q_A_B = 0.0f;
                        for (Particle p : particles_Q_A_B) {
                            normalizer_Q_A_B += p.iProposal;
                        }
                        this.Q_A_B[i5] = this.calculateProposal(particleA4.iIndex) / normalizer_Q_A_B;
                    } else {
                        this.Q_A_B[i5] = 1.0f / (float)particles_Q_A_B.size();
                    }
                    Particle reverseParticleA = new Particle(particleA4.iIndex, this.currentLabelAtParticleA[i5], this.calculateProposal(particleA4.iIndex));
                    ParticleSet particles_Qb_B_A = this.getRegularParticlesInFgNeighborhood(particleA4.iIndex);
                    particles_Qb_B_A.insert(reverseParticleA);
                    if (this.iSettings.useBiasedProposal) {
                        float normalizer_Qb_B_A = 0.0f;
                        for (Particle p : particles_Qb_B_A) {
                            normalizer_Qb_B_A += p.iProposal;
                        }
                        this.Qb_B_A[i5] = this.calculateProposal(particleB.iIndex) / normalizer_Qb_B_A;
                    } else {
                        this.Qb_B_A[i5] = 1.0f / (float)particles_Qb_B_A.size();
                    }
                }
                --numOfParticlesToApply;
            }
        }
        boolean hardReject = false;
        for (i = 0; i < this.iMcmcStepSize; ++i) {
            particleA = this.candidateToMoveParticleA[i];
            Particle particleB = this.partnerToMoveParticleB[i];
            if (this.iSettings.usePairProposal) {
                this.isParticleBbFloating[i] = this.isParticleFloating(particleB.iIndex, this.currentLabelAtParticleB[i]);
            } else {
                this.isParticleAbFloating[i] = this.isParticleFloating(particleA.iIndex, this.currentLabelAtParticleA[i]);
            }
            Particle reverseFloatingParticle = null;
            if (this.isParticleAbFloating[i]) {
                reverseFloatingParticle = new Particle(this.candidateToMoveParticleA[i].iIndex, this.currentLabelAtParticleA[i], this.calculateProposal(this.candidateToMoveParticleA[i].iIndex));
            }
            if (this.iSettings.usePairProposal && this.isParticleBbFloating[i]) {
                reverseFloatingParticle = new Particle(this.partnerToMoveParticleB[i].iIndex, this.currentLabelAtParticleB[i], this.calculateProposal(this.partnerToMoveParticleB[i].iIndex));
            }
            if (!this.isParticleAbFloating[i] && !this.isParticleBbFloating[i] || this.insertFloatingParticle(reverseFloatingParticle, true)) continue;
            hardReject = true;
        }
        for (i = 0; i < this.iMcmcStepSize; ++i) {
            particleA = this.candidateToMoveParticleA[i];
            Particle particleB = this.partnerToMoveParticleB[i];
            if (!this.iSettings.useBiasedProposal) {
                this.Qb_A[i] = 1.0f;
                this.Qb_B[i] = 1.0f;
            } else {
                this.Qb_A[i] = this.calculateProposal(particleA.iIndex);
                if (this.iSettings.usePairProposal && !singleParticleMoveForPairProposals) {
                    this.Qb_B[i] = this.calculateProposal(particleB.iIndex);
                }
            }
            float normalizer_Qb_A = this.isParticleAbFloating[i] ? this.iFloatingParticlesProposalNormalizer : this.getProposalNormalizer(particleA.iCandidateLabel, this.currentLabelAtParticleA[i]);
            int n = i;
            this.Qb_A[n] = this.Qb_A[n] / normalizer_Qb_A;
            if (this.iSettings.usePairProposal && !singleParticleMoveForPairProposals) {
                float normalizer_Qb_B = this.isParticleBbFloating[i] ? this.iFloatingParticlesProposalNormalizer : this.getProposalNormalizer(particleB.iCandidateLabel, this.currentLabelAtParticleB[i]);
                int n3 = i;
                this.Qb_B[n3] = this.Qb_B[n3] / normalizer_Qb_B;
            }
            if (!singleParticleMoveForPairProposals) continue;
            this.Q_B[i] = this.Q_A[i];
            this.Q_A_B[i] = this.Q_B_A[i];
            this.Qb_B_A[i] = this.Qb_A_B[i];
            this.Qb_B[i] = this.Qb_A[i];
        }
        float forwardBackwardRatio = 1.0f;
        for (int i6 = 0; i6 < this.iMcmcStepSize; ++i6) {
            float vPProposeAFloatInXb;
            if (this.iSettings.usePairProposal) {
                if (this.isParticleAbFloating[i6] || this.isParticleBbFloating[i6] || this.isParticleAfloating[i6]) {
                    forwardBackwardRatio *= this.Qb_B[i6] * this.Qb_A_B[i6] / (this.Q_A[i6] * this.Q_B_A[i6]);
                    continue;
                }
                forwardBackwardRatio *= (this.Qb_A[i6] * this.Qb_B_A[i6] + this.Qb_B[i6] * this.Qb_A_B[i6]) / (this.Q_A[i6] * this.Q_B_A[i6] + this.Q_B[i6] * this.Q_A_B[i6]);
                continue;
            }
            if (this.isParticleAfloating[i6]) {
                vPProposeAFloatInXb = this.iFloatingParticlesProposalNormalizer / (this.iFloatingParticlesProposalNormalizer + this.iTotalNormalizer);
                forwardBackwardRatio = (float)((double)forwardBackwardRatio * ((double)(0.5f * (1.0f - vPProposeAFloatInXb)) / probabilityOfFloatingParticle));
                forwardBackwardRatio *= this.Qb_A[i6] / this.Q_A[i6];
                continue;
            }
            if (this.isParticleAbFloating[i6]) {
                vPProposeAFloatInXb = this.iFloatingParticlesProposalNormalizer / (this.iFloatingParticlesProposalNormalizer + this.iTotalNormalizer);
                forwardBackwardRatio = (float)((double)forwardBackwardRatio * ((double)vPProposeAFloatInXb / (0.5 * (1.0 - probabilityOfFloatingParticle))));
                forwardBackwardRatio *= this.Qb_A[i6] / this.Q_A[i6];
                continue;
            }
            forwardBackwardRatio *= this.Qb_A[i6] / this.Q_A[i6];
        }
        float hastingsRatio = (float)Math.exp(-energyDiff / this.iMcmcTemperature) * forwardBackwardRatio;
        boolean bl = hastingsRatio >= 1.0f ? true : (accept = (double)hastingsRatio > this.iRng.GetUniformVariate(0.0, 1.0));
        if (!accept || hardReject) {
            this.rejectParticles(appliedParticles, appliedParticleOrigLabels);
        } else {
            for (int i7 = 0; i7 < appliedParticles.size(); ++i7) {
                this.storeResult(appliedParticles.get((int)i7).iIndex, appliedParticleOrigLabels.get(i7), this.iIterationCounter);
            }
        }
        return accept;
    }

    private void initEdgeDistribution() {
        if (this.iSettings.offBoundarySampleProbability > 0.0f) {
            this.iEdgeImageDistr = AlgorithmDRS.generateDiscreteDistribution(this.iEdgeImage, this.iDistrRng);
        }
    }

    private void rejectParticles(ParticleSet aAppliedParticles, ArrayList<Integer> aOrigLabels) {
        ParticleHistoryElement phe;
        int i;
        for (i = this.iParticlesHistory.size() - 1; i >= 0; --i) {
            phe = this.iParticlesHistory.get(i);
            if (phe.wasAdded) {
                this.eraseCandidatesFromContainers(phe.particle, phe.originalLabel, false);
                continue;
            }
            this.insertCandidatesToContainers(phe.particle, phe.originalLabel, false);
        }
        for (i = this.iFloatingParticlesHistory.size() - 1; i >= 0; --i) {
            phe = this.iFloatingParticlesHistory.get(i);
            if (phe.wasAdded) {
                this.eraseFloatingParticle(phe.particle, false);
                continue;
            }
            this.insertFloatingParticle(phe.particle, false);
        }
        for (i = this.iLabelImageHistory.size() - 1; i >= 0; --i) {
            LabelImageHistoryEvent lihe = this.iLabelImageHistory.get(i);
            this.iLabelImage.setLabel(lihe.index, lihe.label);
        }
        for (i = aOrigLabels.size() - 1; i >= 0; --i) {
            Particle p = aAppliedParticles.get(i);
            LabelStatisticToolbox.updateLabelStatistics(this.iIntensityImage.get(p.iIndex), p.iCandidateLabel, aOrigLabels.get(i), this.iLabelStatistics);
        }
    }

    private void storeResult(int aCandidateIndex, int aLabelBefore, int aIteration) {
        List<McmcResult> resultsForIndex = this.iMcmcResults.get(aCandidateIndex);
        if (resultsForIndex == null) {
            resultsForIndex = new ArrayList<McmcResult>();
            this.iMcmcResults.put(aCandidateIndex, resultsForIndex);
        }
        resultsForIndex.add(new McmcResult(aIteration, aLabelBefore));
    }

    private float calculateEnergyDifference(int aIndex, int aCurrentLabel, int aToLabel, float aImgValue) {
        ContourParticle contourCandidate = new ContourParticle(aCurrentLabel, aImgValue);
        Energy.EnergyResult res = this.iImageModel.calculateDeltaEnergy(this.iLabelImage.indexToPoint(aIndex), contourCandidate, aToLabel, this.iLabelStatistics);
        return res.energyDifference.floatValue();
    }

    private void applyParticle(Particle aCandidateParticle, boolean aDoSimulate) {
        this.addAndRemoveParticlesWhenMove(aCandidateParticle);
        this.storeLabelImageHistory(aCandidateParticle.iIndex, this.iLabelImage.getLabel(aCandidateParticle.iIndex));
        int fromLabelOldValue = this.iLabelImage.getLabelAbs(aCandidateParticle.iIndex);
        int sign = -1;
        if (this.iLabelImage.isEnclosedByLabelBgConnectivity(aCandidateParticle.iIndex, aCandidateParticle.iCandidateLabel)) {
            sign = 1;
        }
        this.iLabelImage.setLabel(aCandidateParticle.iIndex, sign * aCandidateParticle.iCandidateLabel);
        if (!aDoSimulate) {
            LabelStatisticToolbox.updateLabelStatistics(this.iIntensityImage.get(aCandidateParticle.iIndex), fromLabelOldValue, aCandidateParticle.iCandidateLabel, this.iLabelStatistics);
        }
        if (this.iSettings.useBiasedProposal || !this.iSettings.allowFission || !this.iSettings.allowHandles) {
            this.updateProposalsAndFilterTopologyInNeighborhood(aCandidateParticle);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addAndRemoveParticlesWhenMove(Particle aCandidateParticle) {
        int candidateIndex = aCandidateParticle.iIndex;
        int labelTo = aCandidateParticle.iCandidateLabel;
        int origAbsLabelFrom = this.iLabelImage.getLabelAbs(candidateIndex);
        int savedOrigLabel = this.iLabelImage.getLabel(candidateIndex);
        this.iLabelImage.setLabel(candidateIndex, -labelTo);
        Particle reverseParticle = new Particle(candidateIndex, origAbsLabelFrom, this.calculateProposal(candidateIndex));
        boolean reverseParticleIsFloating = this.isParticleFloating(reverseParticle.iIndex, reverseParticle.iCandidateLabel);
        this.iLabelImage.setLabel(candidateIndex, savedOrigLabel);
        if (!reverseParticleIsFloating) {
            this.insertCandidatesToContainers(reverseParticle, labelTo, true);
        }
        this.eraseCandidatesFromContainers(aCandidateParticle, origAbsLabelFrom, true);
        if (origAbsLabelFrom != 0 && labelTo != 0) {
            Particle particle = new Particle(candidateIndex, 0, this.calculateProposal(candidateIndex));
            this.eraseCandidatesFromContainers(particle, origAbsLabelFrom, true);
            this.insertCandidatesToContainers(particle, labelTo, true);
        }
        if (origAbsLabelFrom != 0) {
            void var8_11;
            for (int offset : this.iBgNeighborsIndices) {
                int notExisted;
                int index = candidateIndex + offset;
                int label = this.iLabelImage.getLabel(index);
                if (label <= 0 || label != origAbsLabelFrom || (notExisted = this.insertCandidatesToContainers(new Particle(index, 0, this.calculateProposal(index)), origAbsLabelFrom, true)) == 0) continue;
                this.iLabelImage.setLabel(index, -origAbsLabelFrom);
                this.storeLabelImageHistory(index, label);
            }
            boolean bl = false;
            while (var8_11 < this.iFgNeighborsOffsets.length) {
                int index = candidateIndex + this.iFgNeighborsIndices[var8_11];
                int label = this.iLabelImage.getLabel(index);
                if (!this.iLabelImage.isBorderLabel(label)) {
                    int savedOriginalLabel = this.iLabelImage.getLabel(candidateIndex);
                    this.iLabelImage.setLabel(candidateIndex, -labelTo);
                    if (Math.abs(label) != origAbsLabelFrom) {
                        boolean hasOtherMother = false;
                        for (Point offset : this.iFgNeighborsOffsets) {
                            int label2 = this.iLabelImage.getLabelAbs(candidateIndex + this.iLabelImage.pointToIndex(offset.add(this.iFgNeighborsOffsets[var8_11])));
                            if (label2 != origAbsLabelFrom) continue;
                            hasOtherMother = true;
                            break;
                        }
                        if (!hasOtherMother) {
                            this.eraseCandidatesFromContainers(new Particle(index, origAbsLabelFrom, 0.0f), Math.abs(label), true);
                        }
                    }
                    this.iLabelImage.setLabel(candidateIndex, savedOriginalLabel);
                }
                ++var8_11;
            }
        }
        if (labelTo != 0) {
            int n = this.iLabelImage.getLabel(candidateIndex);
            this.iLabelImage.setLabel(candidateIndex, -labelTo);
            for (int offset : this.iBgNeighborsIndices) {
                int index = candidateIndex + offset;
                int label = this.iLabelImage.getLabel(index);
                if (label != -labelTo || !this.iLabelImage.isEnclosedByLabelBgConnectivity(index, labelTo)) continue;
                this.eraseCandidatesFromContainers(new Particle(index, 0, 0.0f), labelTo, true);
                this.iLabelImage.setLabel(index, Math.abs(label));
                this.storeLabelImageHistory(index, label);
            }
            this.iLabelImage.setLabel(candidateIndex, n);
            for (int i = 0; i < this.iFgNeighborsOffsets.length; ++i) {
                boolean notExisted;
                int index = candidateIndex + this.iFgNeighborsIndices[i];
                int label = this.iLabelImage.getLabel(index);
                int absLabel = Math.abs(label);
                if (absLabel == labelTo || this.iLabelImage.isBorderLabel(absLabel)) continue;
                boolean hasOtherMother = false;
                for (Point vOff2 : this.iFgNeighborsOffsets) {
                    int label2 = this.iLabelImage.getLabelAbs(candidateIndex + this.iLabelImage.pointToIndex(vOff2.add(this.iFgNeighborsOffsets[i])));
                    if (label2 != labelTo) continue;
                    hasOtherMother = true;
                    break;
                }
                if (hasOtherMother || !(notExisted = this.insertCandidatesToContainers(new Particle(index, labelTo, this.calculateProposal(index)), absLabel, true))) continue;
                this.iLabelImage.setLabel(index, -absLabel);
                this.storeLabelImageHistory(index, label);
            }
        }
    }

    private boolean isParticleFloating(int aParticleIndex, int aCandidateLabel) {
        if (aCandidateLabel > 0) {
            return this.iLabelImage.isSingleFgPoint(aParticleIndex, aCandidateLabel);
        }
        return this.iLabelImage.isEnclosedByLabelBgConnectivity(aParticleIndex, this.iLabelImage.getLabelAbs(aParticleIndex));
    }

    private float getProposalNormalizer(int aCurrentLabel, int aCandidateLabel) {
        return aCandidateLabel == 0 ? this.iParentsProposalNormalizer.get(aCurrentLabel).floatValue() : this.iChildrenProposalNormalizer.get(aCandidateLabel).floatValue();
    }

    private boolean isRegularParticle(Particle aParticle, int aCurrentLabel) {
        return aParticle.iCandidateLabel == 0 ? this.iParents.get(aCurrentLabel).contains(aParticle) : this.iChildren.get(aParticle.iCandidateLabel).contains(aParticle);
    }

    private void resetLabelsToParents() {
        this.iLabels.clear();
        this.iLabels.addAll(this.iParents.keySet());
    }

    private void storeLabelImageHistory(int aIndex, int aOrigLabel) {
        this.iLabelImageHistory.add(new LabelImageHistoryEvent(aIndex, aOrigLabel));
    }

    private void updateProposalsAndFilterTopologyInNeighborhood(Particle aParticle) {
        for (int i = -1; i < this.iBgNeighborsIndices.length; ++i) {
            int offset = i >= 0 ? this.iBgNeighborsIndices[i] : 0;
            for (Particle particle : this.getRegularParticles(aParticle.iIndex + offset, new ParticleSet())) {
                int label;
                int n = label = particle.iCandidateLabel == 0 ? this.iLabelImage.getLabelAbs(particle.iIndex) : particle.iCandidateLabel;
                if (this.isParticleTopoValid(particle)) {
                    particle.iProposal = this.calculateProposal(particle.iIndex);
                    this.insertCandidatesToContainers(particle, label, true);
                    continue;
                }
                this.eraseCandidatesFromContainers(particle, label, true);
            }
        }
    }

    private void topologyFiltering(ParticleSet aParticleSet) {
        for (int i = aParticleSet.size() - 1; i >= 0; --i) {
            Particle p = aParticleSet.get(i);
            if (this.isParticleTopoValid(p)) continue;
            aParticleSet.erase(p);
        }
    }

    private boolean isParticleTopoValid(Particle aParticle) {
        if (!this.iSettings.allowFission || !this.iSettings.allowHandles) {
            int particleLabel;
            ArrayList<Integer> labelsToCheck = new ArrayList<Integer>(2);
            if (aParticle.iCandidateLabel != 0) {
                labelsToCheck.add(aParticle.iCandidateLabel);
            }
            if ((particleLabel = this.iLabelImage.getLabelAbs(aParticle.iIndex)) != 0) {
                labelsToCheck.add(particleLabel);
            }
            for (TopologicalNumber.TopologicalNumberResult tnr : this.iTopoFunction.getTopologicalNumbers(this.iLabelImage.indexToPoint(aParticle.iIndex), labelsToCheck)) {
                if (tnr != null && tnr.iNumOfConnectedComponentsFG == 1 && tnr.iNumOfConnectedComponentsBG == 1) continue;
                return false;
            }
        }
        return true;
    }

    private ParticleSet getRegularParticlesInBgNeighborhood(int aIndex) {
        ParticleSet aList = new ParticleSet();
        for (int offset : this.iBgNeighborsIndices) {
            this.getRegularParticles(aIndex + offset, aList);
        }
        return aList;
    }

    private ParticleSet getRegularParticlesInFgNeighborhood(int aIndex) {
        ParticleSet aList = new ParticleSet();
        for (int offset : this.iFgNeighborsIndices) {
            this.getRegularParticles(aIndex + offset, aList);
        }
        return aList;
    }

    private ParticleSet getPartnerParticles(Particle aParticle) {
        ParticleSet aSet = new ParticleSet();
        ParticleSet conditionalParticles = this.getRegularParticlesInBgNeighborhood(aParticle.iIndex);
        for (Particle p : conditionalParticles) {
            if (p.iCandidateLabel == aParticle.iCandidateLabel) continue;
            aSet.insert(p);
        }
        if (!this.iSettings.allowFission || !this.iSettings.allowHandles) {
            this.topologyFiltering(aSet);
        }
        aSet.insert(aParticle);
        return aSet;
    }

    private ParticleSet getRegularParticles(int aIndex, ParticleSet aSet) {
        int currentLabel = this.iLabelImage.getLabel(aIndex);
        if (this.iLabelImage.isBorderLabel(currentLabel)) {
            return aSet;
        }
        float proposal = this.calculateProposal(aIndex);
        int absCurrentLabel = this.iLabelImage.labelToAbs(currentLabel);
        boolean isParentInserted = false;
        for (Integer idx : this.iLabelImage.iterateNeighbours(aIndex)) {
            int neighborLabel = this.iLabelImage.getLabel(idx);
            int absNeighborLabel = this.iLabelImage.labelToAbs(neighborLabel);
            if (this.iLabelImage.isBorderLabel(neighborLabel) || absNeighborLabel == absCurrentLabel) continue;
            if (neighborLabel != 0) {
                aSet.insert(new Particle(aIndex, absNeighborLabel, proposal));
            }
            if (isParentInserted || currentLabel == 0) continue;
            aSet.insert(new Particle(aIndex, 0, proposal));
            isParentInserted = true;
        }
        if (!isParentInserted && currentLabel != 0) {
            for (Integer idx : this.iLabelImage.iterateBgNeighbours(aIndex)) {
                if (this.iLabelImage.getLabelAbs(idx) == absCurrentLabel) continue;
                aSet.insert(new Particle(aIndex, 0, proposal));
                break;
            }
        }
        return aSet;
    }

    private int sampleIndexFromEdgeDensity() {
        int index = -1;
        while (this.iLabelImage.isBorderLabel(this.iLabelImage.getLabel(index = this.iEdgeImageDistr.sample()))) {
        }
        return index;
    }

    private boolean insertCandidatesToContainers(Particle aParticle, int aCurrentLabel, boolean aDoRecord) {
        Particle replacedParticle;
        Map<Integer, ParticleSet> container = aParticle.iCandidateLabel == 0 ? this.iParents : this.iChildren;
        Map<Integer, Float> containerNormalizer = aParticle.iCandidateLabel == 0 ? this.iParentsProposalNormalizer : this.iChildrenProposalNormalizer;
        int label = aParticle.iCandidateLabel == 0 ? aCurrentLabel : aParticle.iCandidateLabel;
        ParticleSet particles = container.get(label);
        if (particles == null) {
            particles = new ParticleSet();
            container.put(label, particles);
        }
        float diff = (replacedParticle = particles.insert(aParticle)) == null ? aParticle.iProposal : aParticle.iProposal - replacedParticle.iProposal;
        containerNormalizer.replace(label, Float.valueOf(containerNormalizer.getOrDefault(label, Float.valueOf(0.0f)).floatValue() + diff));
        this.iTotalNormalizer += diff;
        if (aDoRecord) {
            if (replacedParticle != null) {
                this.iParticlesHistory.add(new ParticleHistoryElement(replacedParticle, aCurrentLabel, false));
            }
            this.iParticlesHistory.add(new ParticleHistoryElement(aParticle, aCurrentLabel, true));
        }
        return replacedParticle == null;
    }

    private boolean eraseCandidatesFromContainers(Particle aParticle, int aCurrentLabel, boolean aDoRecord) {
        Map<Integer, ParticleSet> container = aParticle.iCandidateLabel == 0 ? this.iParents : this.iChildren;
        Map<Integer, Float> containerNormalizer = aParticle.iCandidateLabel == 0 ? this.iParentsProposalNormalizer : this.iChildrenProposalNormalizer;
        int label = aParticle.iCandidateLabel == 0 ? aCurrentLabel : aParticle.iCandidateLabel;
        ParticleSet particles = container.get(label);
        Particle replacedParticle = particles.erase(aParticle);
        if (replacedParticle != null) {
            containerNormalizer.put(label, Float.valueOf(containerNormalizer.get(label).floatValue() - replacedParticle.iProposal));
            this.iTotalNormalizer -= replacedParticle.iProposal;
        }
        if (replacedParticle != null && aDoRecord) {
            this.iParticlesHistory.add(new ParticleHistoryElement(replacedParticle, aCurrentLabel, false));
        }
        return replacedParticle != null;
    }

    private void eraseFloatingParticle(Particle aParticle, boolean aDoRecord) {
        int index = this.iFloatingParticles.getIndex(aParticle);
        Particle updatedParticle = this.iFloatingParticles.get(index);
        if (updatedParticle.iProposal - aParticle.iProposal > Math.ulp(1.0f) * 10.0f) {
            this.iFloatingParticlesProposalNormalizer -= aParticle.iProposal;
            updatedParticle.iProposal -= aParticle.iProposal;
        } else {
            this.iFloatingParticlesProposalNormalizer -= updatedParticle.iProposal;
            this.iFloatingParticles.erase(updatedParticle);
        }
        if (aDoRecord) {
            this.iFloatingParticlesHistory.add(new ParticleHistoryElement(aParticle, 0, false));
        }
    }

    private boolean insertFloatingParticle(Particle aParticle, boolean aDoRecord) {
        if (this.iFloatingParticles.contains(aParticle)) {
            return false;
        }
        this.iFloatingParticlesProposalNormalizer += aParticle.iProposal;
        this.iFloatingParticles.insert(aParticle);
        if (aDoRecord) {
            this.iFloatingParticlesHistory.add(new ParticleHistoryElement(aParticle, 0, true));
        }
        return true;
    }

    private boolean sampleOffBoundary(int aLabel) {
        boolean shouldGrowth = this.iRng.GetUniformVariate(0.0, 1.0) < 0.5;
        int candidateLabel = this.iRng.GetUniformVariate(0.0, 1.0) > 0.5 ? aLabel : 0;
        int particleIndex = this.sampleIndexFromEdgeDensity();
        Particle particle = new Particle(particleIndex, candidateLabel, 0.0f);
        boolean particleExists = this.iFloatingParticles.contains(particle);
        if (!shouldGrowth && particleExists) {
            Particle p = this.iFloatingParticles.get(this.iFloatingParticles.getIndex(particle));
            particle.iProposal = (float)(this.iRng.GetVariate() * (double)p.iProposal);
            this.eraseFloatingParticle(particle, false);
        } else if (shouldGrowth && !particleExists) {
            particle.iProposal = this.calculateProposal(particle.iIndex);
            this.insertFloatingParticle(particle, false);
        } else {
            return false;
        }
        return true;
    }

    private float calculateProposal(int aIndex) {
        if (!this.iSettings.useBiasedProposal) {
            return 1.0f;
        }
        float length = 0.0f;
        boolean isFloatingParticle = true;
        int label = this.iLabelImage.getLabelAbs(aIndex);
        Point point = this.iLabelImage.indexToPoint(aIndex);
        for (int i = 0; i < this.iBgNeighborsOffsets.length; ++i) {
            Point offset = this.iBgNeighborsOffsets[i];
            int currLabel = this.iLabelImage.getLabelAbs(offset.add(point));
            if (currLabel == label) continue;
            length += this.iLengthProposalMask[i];
            isFloatingParticle = false;
        }
        if (isFloatingParticle) {
            length = this.iLengthProposalMask[0] / 2.0f;
        }
        return length;
    }

    public ImagePlus createProbabilityImage() {
        int[] dims = this.iLabelImage.getDimensions();
        SegmentationProcessWindow resultImg = new SegmentationProcessWindow(dims[0], dims[1], true);
        int numOfBurnInIterations = (int)(this.iSettings.burnInFactor * (float)this.iIterationCounter);
        int numOfCountableIterations = this.iIterationCounter - numOfBurnInIterations;
        for (int currentLabel : this.iLabels) {
            if (currentLabel == 0) continue;
            IntensityImage img = new IntensityImage(this.iLabelImage.getDimensions());
            for (int i = 0; i < this.iLabelImage.getSize(); ++i) {
                img.set(i, this.iLabelImage.getLabelAbs(i) == currentLabel ? 1.0f : 0.0f);
            }
            for (Map.Entry<Integer, List<McmcResult>> e : this.iMcmcResults.entrySet()) {
                int index = e.getKey();
                List<McmcResult> results = e.getValue();
                int labelAtIndex = this.iLabelImage.getLabelAbs(index);
                long iterationsInLabel = labelAtIndex == currentLabel ? (long)numOfCountableIterations : 0L;
                for (int i = results.size() - 1; i >= 0; --i) {
                    McmcResult result = results.get(i);
                    if (result.iteration < numOfBurnInIterations) break;
                    if (currentLabel == labelAtIndex) {
                        iterationsInLabel -= (long)(result.iteration - numOfBurnInIterations);
                    } else if (currentLabel == result.previousLabel) {
                        iterationsInLabel += (long)(result.iteration - numOfBurnInIterations);
                    }
                    labelAtIndex = result.previousLabel;
                }
                img.set(index, (float)((double)iterationsInLabel / (double)numOfCountableIterations));
            }
            resultImg.addSliceToStack(img, "label_" + currentLabel, false);
        }
        resultImg.setImageTitle("Probability");
        return resultImg.getImage();
    }

    static IndexedDiscreteDistribution generateDiscreteDistribution(IntensityImage aImg, Rng am_NumberGeneratorBoost) {
        Point point;
        double[] pmf = new double[aImg.getSize()];
        Iterator<Point> ri = new SpaceIterator(aImg.getDimensions()).getPointIterator();
        int index = 0;
        double sumOfPixelValues = 0.0;
        while (ri.hasNext()) {
            point = ri.next();
            double value = aImg.get(point);
            sumOfPixelValues += value;
            pmf[index++] = value;
        }
        if (sumOfPixelValues < (double)(10.0f * Math.ulp(1.0f))) {
            sumOfPixelValues = aImg.getSize();
            index = 0;
            ri = new SpaceIterator(aImg.getDimensions()).getPointIterator();
            while (ri.hasNext()) {
                point = ri.next();
                aImg.set(point, 1.0f);
                pmf[index] = 1.0;
                ++index;
            }
        }
        return new IndexedDiscreteDistribution((RandomGenerator)am_NumberGeneratorBoost, pmf);
    }

    private IntensityImage generateEdgeImage(IntensityImage aImage) {
        IntensityImage img = new IntensityImage(aImage);
        img.normalize();
        Convolver imgConvolver = new Convolver(img.getWidth(), img.getHeight(), img.getDepth());
        imgConvolver.initFromIntensityImage(img);
        Gauss1D gauss = new Gauss1D(1.5, 7);
        imgConvolver.x1D(gauss);
        imgConvolver.y1D(gauss);
        if (img.getDepth() > 1) {
            imgConvolver.z1D(gauss);
            imgConvolver.sobel3D();
        } else {
            imgConvolver.sobel2D();
        }
        imgConvolver.getIntensityImage(img);
        return img;
    }

    private class LabelImageHistoryEvent {
        public int index;
        public int label;

        public LabelImageHistoryEvent(int aIndex, int aLabel) {
            this.index = aIndex;
            this.label = aLabel;
        }
    }

    private class McmcResult {
        public int iteration;
        public int previousLabel;

        public McmcResult(int aIteration, int aPreviousLabel) {
            this.iteration = aIteration;
            this.previousLabel = aPreviousLabel;
        }

        public String toString() {
            return "Result{" + this.iteration + ", " + this.previousLabel + "}";
        }
    }

    private class ParticleHistoryElement {
        final Particle particle;
        final int originalLabel;
        final boolean wasAdded;

        public ParticleHistoryElement(Particle vReplacedParticle, int aCurrentLabel, boolean b) {
            this.particle = vReplacedParticle;
            this.originalLabel = aCurrentLabel;
            this.wasAdded = b;
        }

        public String toString() {
            return "PHE{ P:" + this.particle + ", L:" + this.originalLabel + ", A:" + this.wasAdded + "}";
        }
    }
}

