/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.DRS;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import mosaic.regions.DRS.Particle;

public class ParticleSet
implements Iterable<Particle> {
    private HashMap<Particle, Integer> iMap = new HashMap();
    protected ArrayList<Particle> iParticles = new ArrayList();

    int size() {
        return this.iMap.size();
    }

    int getIndex(Particle aParticle) {
        Integer index = this.iMap.get(aParticle);
        if (index == null) {
            return -1;
        }
        return index;
    }

    boolean contains(Particle aParticle) {
        return this.iMap.containsKey(aParticle);
    }

    Particle insert(Particle aParticle) {
        Integer index = this.iMap.get(aParticle);
        Particle lastRemovedElement = null;
        if (index == null) {
            this.iParticles.add(aParticle);
            this.iMap.put(aParticle, this.iMap.size());
        } else {
            lastRemovedElement = this.iParticles.set(index, aParticle);
            this.iMap.replace(aParticle, index);
        }
        return lastRemovedElement;
    }

    Particle get(int aIndex) {
        return this.iParticles.get(aIndex);
    }

    Particle erase(Particle aParticle) {
        Integer index = this.iMap.get(aParticle);
        if (index == null) {
            return null;
        }
        Particle lastRemovedElement = this.iParticles.get(index);
        int lastElementIndex = this.iParticles.size() - 1;
        if (lastElementIndex != index) {
            Particle lastParticle = this.iParticles.get(lastElementIndex);
            this.iParticles.set(index, lastParticle);
            this.iMap.replace(lastParticle, index);
        }
        this.iParticles.remove(lastElementIndex);
        this.iMap.remove(aParticle);
        return lastRemovedElement;
    }

    public String toString() {
        return " MAP/VECsize: " + this.iMap.size() + "/" + this.iParticles.size() + " mapElements:\n" + this.iMap;
    }

    @Override
    public Iterator<Particle> iterator() {
        return new Iterator<Particle>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < ParticleSet.this.iParticles.size();
            }

            @Override
            public Particle next() {
                return ParticleSet.this.iParticles.get(this.idx++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

