/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.GUI;

import mosaic.regions.GUI.ControllerWindow;

public class Controller {
    protected ControllerWindow controllerFrame = null;
    private final Object pauseMonitor = new Object();
    private boolean pause = false;
    private boolean abort = false;

    public Controller(boolean aShowWindow) {
        if (aShowWindow) {
            this.controllerFrame = new ControllerWindow(this);
            this.controllerFrame.setVisible(true);
        }
    }

    public void close() {
        if (this.controllerFrame != null) {
            Thread closeThread = new Thread(){

                @Override
                public void run() {
                    Controller.this.controllerFrame.dispose();
                    Controller.this.controllerFrame = null;
                }
            };
            try {
                Thread.sleep(0L);
                closeThread.start();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAborted() {
        Object object = this.pauseMonitor;
        synchronized (object) {
            if (this.pause) {
                try {
                    this.pauseMonitor.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.abort) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.pauseMonitor;
        synchronized (object) {
            this.abort = true;
            this.pause = false;
            this.pauseMonitor.notify();
        }
    }

    void pause() {
        this.pause = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        Object object = this.pauseMonitor;
        synchronized (object) {
            this.pause = false;
            this.pauseMonitor.notify();
        }
    }
}

