/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.GUI;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Roi;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import mosaic.regions.GUI.EnergyGUI;
import mosaic.regions.GUI.FileOpenerActionListener;
import mosaic.regions.GUI.InitializationGUI;
import mosaic.regions.GUI.RegularizationGUI;
import mosaic.regions.GUI.TextAreaListener;
import mosaic.regions.RC.PluginSettingsRC;
import mosaic.regions.RegionsUtils;
import mosaic.regions.Settings;
import org.apache.log4j.Logger;

public class GuiRC {
    private static final Logger logger = Logger.getLogger(GuiRC.class);
    protected final PluginSettingsRC iSettings;
    private final ImagePlus iInputImg;
    GenericDialog iMainDialogWin;
    protected static final String TextDefaultInputImage = "Input Image: \n\nDrop image here,\ninsert Path to file,\nor press Button below";
    protected static final String TextDefaultLabelImage = "Drop Label Image here, or insert Path to file";
    private Choice iInputImageChoice;
    private Choice iLabelImageChoice;
    private boolean iKeepAllFrames = true;
    private boolean iShowNormalized = true;
    private boolean iShowAndSaveStatistics = true;
    private boolean iUseCluster = false;
    private String iInputImageFromTextArea;
    private String iInputImageTitleFromChoice;
    private String iInputLabelImageFromTextArea;
    private String iInputLabelImageTitleFromChoice;
    boolean isConfigurationValid = false;
    boolean isConfigurationReadAlready = false;

    public GuiRC(PluginSettingsRC aSettings, ImagePlus aInputImg) {
        this.iSettings = aSettings;
        this.iInputImg = aInputImg;
        String[] strings = new String[]{"Keep_Frames", "Normalize_input_image", "Show_and_save_Statistics", "Process on computer cluster"};
        if (IJ.isMacro()) {
            logger.info((Object)"GUI - macro mode");
            this.iKeepAllFrames = false;
            this.iMainDialogWin = new GenericDialog("RC/DRS MACRO MODE");
            this.iMainDialogWin.addStringField("text1", "");
            this.iMainDialogWin.addStringField("text2", "");
            this.iMainDialogWin.addCheckbox(strings[2], true);
            return;
        }
        logger.info((Object)"GUI - regular mode");
        this.iMainDialogWin = new CustomDialog("Region Competition");
        Font bf = new Font(null, 1, 12);
        this.iMainDialogWin.addMessage("Input and Label image", bf);
        this.iMainDialogWin.addTextAreas(TextDefaultInputImage, TextDefaultLabelImage, 5, 30);
        new TextAreaListener(this, this.iMainDialogWin.getTextArea1(), TextDefaultInputImage);
        new TextAreaListener(this, this.iMainDialogWin.getTextArea2(), TextDefaultLabelImage);
        Panel p = new Panel();
        Button b = new Button("Open Input Image");
        b.addActionListener(new FileOpenerActionListener(this.iMainDialogWin, this.iMainDialogWin.getTextArea1()));
        p.add(b);
        b = new Button("Open Label Image");
        b.addActionListener(new FileOpenerActionListener(this.iMainDialogWin, this.iMainDialogWin.getTextArea2()));
        p.add(b);
        this.iMainDialogWin.addPanel(p, 10, new Insets(0, 25, 0, 0));
        this.addOpenedImageChooser();
        this.iMainDialogWin.addMessage("Segmentation parameters", bf);
        p = new Panel();
        b = new Button("Parameters");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiRC.this.createParametersDialog();
            }
        });
        p.add(b);
        this.iMainDialogWin.addPanel(p, 10, new Insets(0, 25, 0, 0));
        p = new Panel();
        b = new Button("Reset Settings");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiRC.this.iSettings.copy(new Settings());
            }
        });
        p.add(b);
        this.iMainDialogWin.addPanel(p, 10, new Insets(0, 25, 0, 0));
        this.iMainDialogWin.addMessage("Output and processing settings", bf);
        boolean[] bools = new boolean[]{this.iKeepAllFrames, this.iShowNormalized, this.iShowAndSaveStatistics, false};
        this.iMainDialogWin.addCheckboxGroup(2, strings.length, strings, bools);
        p = new Panel();
        p.add(new JLabel("<html>Please refer to and cite:<br><br>J. Cardinale, G. Paul, and I. F. Sbalzarini.<br>Discrete region competition for unknown numbers of connected regions.<br>IEEE Trans. Image Process., 21(8):3531\u20133545, 2012.</html>"));
        this.iMainDialogWin.addPanel(p);
    }

    protected void createParametersDialog() {
        GenericDialog gd = new GenericDialog("Region Competition Parameters");
        Font bf = new Font(null, 1, 12);
        int gridy = 1;
        int gridx = 2;
        gd.addMessage("Energy and initialization settings", bf);
        RegionsUtils.EnergyFunctionalType[] energyValues = RegionsUtils.EnergyFunctionalType.values();
        String[] energyItems = new String[energyValues.length];
        for (int i = 0; i < energyValues.length; ++i) {
            energyItems[i] = energyValues[i].toString();
        }
        gd.addChoice("E_data", energyItems, this.iSettings.energyFunctional.toString());
        final Choice choiceEnergy = (Choice)gd.getChoices().lastElement();
        Button optionButton = new Button("Options");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = gridy++;
        c.anchor = 13;
        gd.add((Component)optionButton, (Object)c);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String energy = choiceEnergy.getSelectedItem();
                EnergyGUI energyGUI = EnergyGUI.factory((Settings)GuiRC.this.iSettings, energy);
                energyGUI.createDialog();
                energyGUI.showDialog();
                energyGUI.processDialog();
            }
        });
        RegionsUtils.RegularizationType[] regularizationValues = RegionsUtils.RegularizationType.values();
        String[] regularizationItems = new String[regularizationValues.length];
        for (int i = 0; i < regularizationValues.length; ++i) {
            regularizationItems[i] = regularizationValues[i].toString();
        }
        gd.addChoice("E_length", regularizationItems, this.iSettings.regularizationType.toString());
        final Choice choiceRegularization = (Choice)gd.getChoices().lastElement();
        Button optionButton2 = new Button("Options");
        GridBagConstraints c2 = new GridBagConstraints();
        c2.anchor = 13;
        c2.gridx = 2;
        c2.gridy = gridy++;
        gd.add((Component)optionButton2, (Object)c2);
        optionButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String type = choiceRegularization.getSelectedItem();
                RegularizationGUI gui = RegularizationGUI.factory((Settings)GuiRC.this.iSettings, type);
                gui.createDialog();
                gui.showDialog();
                gui.processDialog();
            }
        });
        RegionsUtils.InitializationType[] initTypes = RegionsUtils.InitializationType.values();
        String[] initializationItems = new String[initTypes.length];
        for (int i = 0; i < initTypes.length; ++i) {
            initializationItems[i] = initTypes[i].toString();
        }
        gd.addChoice("Initialization", initializationItems, this.iSettings.initType.toString());
        final Choice initializationChoice = (Choice)gd.getChoices().lastElement();
        Button optionButton3 = new Button("Options");
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridx = 2;
        c3.gridy = gridy++;
        c3.anchor = 13;
        gd.add((Component)optionButton3, (Object)c3);
        optionButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String type = initializationChoice.getSelectedItem();
                InitializationGUI gui = InitializationGUI.factory((Settings)GuiRC.this.iSettings, type);
                gui.createDialog();
                gui.showDialog();
                gui.processDialog();
            }
        });
        gd.addMessage("\nGeneral settings", bf);
        gd.addNumericField("Lambda E_length", (double)this.iSettings.energyContourLengthCoeff, 4, 8, "");
        gd.addNumericField("Max_Iterations", (double)this.iSettings.maxNumOfIterations, 0, 8, "");
        gd.addCheckboxGroup(1, 4, new String[]{"Fusion", "Fission", "Handles"}, new boolean[]{this.iSettings.allowFusion, this.iSettings.allowFission, this.iSettings.allowHandles});
        gd.addNumericField("Theta E_merge", (double)this.iSettings.energyRegionMergingThreshold, 4, 8, "");
        gd.addNumericField("Oscillation threshold (Convergence)", this.iSettings.oscillationThreshold, 4, 8, "");
        gd.showDialog();
        if (gd.wasOKed()) {
            RegionsUtils.InitializationType type;
            String energy = gd.getNextChoice();
            this.iSettings.energyFunctional = RegionsUtils.EnergyFunctionalType.getEnum(energy);
            EnergyGUI eg = EnergyGUI.factory((Settings)this.iSettings, this.iSettings.energyFunctional);
            eg.createDialog();
            eg.processDialog();
            String regularization = gd.getNextChoice();
            this.iSettings.regularizationType = RegionsUtils.RegularizationType.getEnum(regularization);
            this.iSettings.energyContourLengthCoeff = (float)gd.getNextNumber();
            this.iSettings.maxNumOfIterations = (int)gd.getNextNumber();
            this.iSettings.energyRegionMergingThreshold = (float)gd.getNextNumber();
            this.iSettings.oscillationThreshold = gd.getNextNumber();
            String initialization = gd.getNextChoice();
            this.iSettings.initType = type = RegionsUtils.InitializationType.getEnum(initialization);
            InitializationGUI ig = InitializationGUI.factory((Settings)this.iSettings, this.iSettings.initType);
            ig.createDialog();
            ig.processDialog();
            this.iSettings.allowFusion = gd.getNextBoolean();
            this.iSettings.allowFission = gd.getNextBoolean();
            this.iSettings.allowHandles = gd.getNextBoolean();
        }
    }

    public void showDialog() {
        this.isConfigurationReadAlready = false;
        this.iMainDialogWin.showDialog();
    }

    public boolean configurationValid() {
        if (!this.isConfigurationReadAlready) {
            this.isConfigurationValid = this.processInput();
        }
        return this.isConfigurationValid;
    }

    private void addOpenedImageChooser() {
        int[] ids = WindowManager.getIDList();
        int numOpenedImg = ids != null ? ids.length : 0;
        String[] names = new String[numOpenedImg + 1];
        names[0] = "";
        if (ids != null) {
            for (int i = 0; i < numOpenedImg; ++i) {
                names[i + 1] = WindowManager.getImage((int)ids[i]).getTitle();
            }
        }
        this.iMainDialogWin.addChoice("InputImage", names, names[0]);
        this.iInputImageChoice = (Choice)this.iMainDialogWin.getChoices().lastElement();
        if (this.iInputImg != null) {
            this.iInputImageChoice.select(this.iInputImg.getTitle());
        }
        this.iMainDialogWin.addChoice("LabelImage", names, names[0]);
        this.iLabelImageChoice = (Choice)this.iMainDialogWin.getChoices().lastElement();
        if (numOpenedImg >= 2 && this.iInputImg != null) {
            WindowManager.putBehind();
            this.iLabelImageChoice.select(WindowManager.getCurrentImage().getTitle());
            WindowManager.toFront((Frame)this.iInputImg.getWindow());
        }
    }

    protected boolean processInput() {
        if (this.iMainDialogWin.wasCanceled()) {
            return false;
        }
        if (IJ.isMacro()) {
            this.iInputImageFromTextArea = this.iMainDialogWin.getNextString();
            this.iInputLabelImageFromTextArea = this.iMainDialogWin.getNextString();
            this.iShowAndSaveStatistics = this.iMainDialogWin.getNextBoolean();
            return true;
        }
        this.iInputImageFromTextArea = this.iMainDialogWin.getTextArea1().getText();
        if (this.iInputImageFromTextArea == null || this.iInputImageFromTextArea.isEmpty() || this.iInputImageFromTextArea.equals(TextDefaultInputImage)) {
            this.iMainDialogWin.getTextArea1().setText("[]");
            this.iInputImageFromTextArea = null;
        }
        this.iInputLabelImageFromTextArea = this.iMainDialogWin.getTextArea2().getText();
        if (this.iInputLabelImageFromTextArea == null || this.iInputLabelImageFromTextArea.isEmpty() || this.iInputLabelImageFromTextArea.equals(TextDefaultLabelImage)) {
            this.iMainDialogWin.getTextArea2().setText("[]");
            this.iInputLabelImageFromTextArea = null;
        }
        this.iInputImageTitleFromChoice = this.iMainDialogWin.getNextChoice();
        this.iInputLabelImageTitleFromChoice = this.iMainDialogWin.getNextChoice();
        this.iKeepAllFrames = this.iMainDialogWin.getNextBoolean();
        this.iShowNormalized = this.iMainDialogWin.getNextBoolean();
        this.iShowAndSaveStatistics = this.iMainDialogWin.getNextBoolean();
        this.iUseCluster = this.iMainDialogWin.getNextBoolean();
        return true;
    }

    public ImagePlus getInputImage() {
        String file = this.iInputImageFromTextArea;
        ImagePlus inputImage = WindowManager.getImage((String)this.iInputImageTitleFromChoice);
        return this.getImage(file, inputImage, this.iInputImg);
    }

    public ImagePlus getInputLabelImage() {
        String fileName = this.iInputLabelImageFromTextArea;
        ImagePlus choiceIP = WindowManager.getImage((String)this.iInputLabelImageTitleFromChoice);
        return this.getImage(fileName, choiceIP, null);
    }

    public boolean useCluster() {
        return this.iUseCluster;
    }

    public boolean showAllFrames() {
        return this.iKeepAllFrames;
    }

    public boolean showAndSaveStatistics() {
        return this.iShowAndSaveStatistics;
    }

    public boolean getNormalize() {
        return this.iShowNormalized;
    }

    private ImagePlus getImage(String file, ImagePlus inputImage, ImagePlus aDefault) {
        ImagePlus ip = null;
        if (file != null && !file.isEmpty()) {
            ip = IJ.openImage((String)file);
        }
        if (ip == null) {
            ip = inputImage;
        }
        if (ip == null) {
            ip = aDefault;
        }
        return ip;
    }

    void setInputImageChoiceEmpty() {
        if (this.iInputImageChoice != null) {
            this.iInputImageChoice.select(0);
        }
    }

    void setLabelImageChoiceEmpty() {
        if (this.iLabelImageChoice != null) {
            this.iLabelImageChoice.select(0);
        }
    }

    private class CustomDialog
    extends NonBlockingGenericDialog {
        private static final long serialVersionUID = 1L;

        protected CustomDialog(String title) {
            super(title);
        }

        protected void setup() {
            Button[] buttons = this.getButtons();
            final Button ok = buttons[0];
            final Button cancel = buttons[1];
            ok.removeActionListener((ActionListener)((Object)this));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!GuiRC.this.isConfigurationReadAlready) {
                        GuiRC.this.isConfigurationValid = GuiRC.this.processInput();
                        GuiRC.this.isConfigurationReadAlready = true;
                    }
                    if (GuiRC.this.iSettings.initType == RegionsUtils.InitializationType.ROI_2D) {
                        Roi roi = null;
                        ImagePlus iChosenInputImage = GuiRC.this.getInputImage();
                        if (iChosenInputImage == null) {
                            IJ.showMessage((String)"Before starting Region Competition plugin please open image with selected ROI(s).");
                            GuiRC.this.isConfigurationValid = false;
                            GuiRC.this.iMainDialogWin.actionPerformed(new ActionEvent(cancel, 0, "Cancel pressed"));
                            return;
                        }
                        roi = iChosenInputImage.getRoi();
                        if (roi == null) {
                            IJ.showMessage((String)("You have chosen initialization type to ROI.\nPlease add ROI region(s) to plugin input image (" + iChosenInputImage.getTitle() + ")."));
                            iChosenInputImage.show();
                        } else {
                            this.itIsOK(e);
                        }
                    } else {
                        this.itIsOK(e);
                    }
                }

                void itIsOK(ActionEvent e) {
                    ok.removeActionListener(this);
                    ok.addActionListener((ActionListener)GuiRC.this.iMainDialogWin);
                    GuiRC.this.iMainDialogWin.actionPerformed(e);
                }
            });
        }
    }
}

