/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import mosaic.core.imageUtils.images.IntensityImage;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.psf.GeneratePSF;
import mosaic.core.utils.MosaicUtils;
import mosaic.regions.energies.E_CV;
import mosaic.regions.energies.E_CurvatureFlow;
import mosaic.regions.energies.E_Deconvolution;
import mosaic.regions.energies.E_Gamma;
import mosaic.regions.energies.E_KLMergingCriterion;
import mosaic.regions.energies.E_PC_Gauss;
import mosaic.regions.energies.E_PS;
import mosaic.regions.energies.Energy;
import mosaic.regions.energies.ImageModel;
import mosaic.regions.initializers.BoxInitializer;
import mosaic.regions.initializers.BubbleInitializer;
import mosaic.regions.initializers.MaximaBubbles;
import mosaic.utils.ImgUtils;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.real.FloatType;

public abstract class RegionsUtils {
    public static ImageModel initEnergies(IntensityImage intensityImage, LabelImage labelImage, Calibration inputImageCalibration, EnergyFunctionalType m_EnergyFunctional, float m_RegionMergingThreshold, int m_GaussPSEnergyRadius, float m_BalloonForceCoeff, RegularizationType regularizationType, float m_CurvatureMaskRadius, float m_EnergyContourLengthCoeff) {
        Energy.InternalEnergy e_length;
        Energy.ExternalEnergy e_data;
        E_KLMergingCriterion e_merge = null;
        switch (m_EnergyFunctional) {
            case e_PC: {
                e_data = new E_CV();
                e_merge = new E_KLMergingCriterion(0, m_RegionMergingThreshold);
                break;
            }
            case e_PS: {
                e_data = new E_PS(labelImage, intensityImage, m_GaussPSEnergyRadius, m_BalloonForceCoeff, m_RegionMergingThreshold);
                break;
            }
            case e_DeconvolutionPC: {
                GeneratePSF gPsf = new GeneratePSF();
                Img<FloatType> image_psf = gPsf.generate(labelImage.getDepth());
                double Vol = MosaicUtils.volume_image(image_psf);
                MosaicUtils.rescale_image(image_psf, (float)(1.0 / Vol));
                e_data = new E_Deconvolution(intensityImage, image_psf);
                break;
            }
            case e_PC_Gauss: {
                e_data = new E_PC_Gauss();
                e_merge = new E_KLMergingCriterion(0, m_RegionMergingThreshold);
                break;
            }
            default: {
                String s = "Unsupported Energy functional";
                IJ.showMessage((String)"Unsupported Energy functional");
                throw new RuntimeException("Unsupported Energy functional");
            }
        }
        switch (regularizationType) {
            case Sphere_Regularization: {
                e_length = new E_CurvatureFlow(labelImage, (int)m_CurvatureMaskRadius, inputImageCalibration);
                break;
            }
            case Approximative: {
                e_length = new E_Gamma(labelImage);
                break;
            }
            case None: {
                e_length = null;
                break;
            }
            default: {
                String s = "Unsupported Regularization";
                IJ.showMessage((String)"Unsupported Regularization");
                throw new RuntimeException("Unsupported Regularization");
            }
        }
        return new ImageModel(e_data, e_length, e_merge, m_EnergyContourLengthCoeff);
    }

    public static IntensityImage initInputImage(ImagePlus inputImageChosenByUser, boolean normalize_ip, int iPadSize) {
        if (inputImageChosenByUser != null) {
            int c = inputImageChosenByUser.getNChannels();
            int f = inputImageChosenByUser.getNFrames();
            if (c != 1 || f != 1) {
                String s = "Plugin is not able to segment correctly multichannel or multiframe images.\nCurrent input file info: number of channels=" + c + "number of frames=" + f + "\nPlease use as a input only 2D or 3D single image.";
                IJ.showMessage((String)s);
                throw new RuntimeException(s);
            }
            ImagePlus workImg = inputImageChosenByUser;
            ImageStack padedIs = ImgUtils.pad(inputImageChosenByUser.getStack(), iPadSize, inputImageChosenByUser.getNDimensions() > 2);
            workImg = inputImageChosenByUser.duplicate();
            workImg.setStack(padedIs);
            inputImageChosenByUser.show();
            return new IntensityImage(workImg, normalize_ip);
        }
        IJ.noImage();
        return null;
    }

    public static LabelImage initLabelImage(IntensityImage intensityImage, ImagePlus inputImageChosenByUser, ImagePlus inputLabelImageChosenByUser, int iPadSize, InitializationType labelImageInitType, double l_BoxRatio, int m_BubblesRadius, int m_BubblesDispl, double l_Sigma, double l_Tolerance, int l_BubblesRadius, int l_RegionTolerance) {
        LabelImage labelImage = new LabelImage(intensityImage.getDimensions());
        switch (labelImageInitType) {
            case ROI_2D: {
                if (inputImageChosenByUser.getRoi() == null) {
                    throw new RuntimeException("No ROI found in input image");
                }
                labelImage.initLabelsWithRoi(inputImageChosenByUser.getRoi());
                labelImage.initBorder();
                labelImage.connectedComponents();
                break;
            }
            case Rectangle: {
                BoxInitializer bi = new BoxInitializer(labelImage);
                bi.initialize(l_BoxRatio);
                break;
            }
            case Bubbles: {
                BubbleInitializer bi = new BubbleInitializer(labelImage);
                bi.initialize(m_BubblesRadius, m_BubblesDispl);
                break;
            }
            case LocalMax: {
                MaximaBubbles mb = new MaximaBubbles(intensityImage, labelImage, l_Sigma, l_Tolerance, l_BubblesRadius, l_RegionTolerance);
                mb.initialize();
                break;
            }
            case File: {
                if (inputLabelImageChosenByUser != null && inputLabelImageChosenByUser.getWidth() == inputImageChosenByUser.getWidth() && inputLabelImageChosenByUser.getHeight() == inputImageChosenByUser.getHeight()) {
                    ImagePlus labelImg = inputLabelImageChosenByUser;
                    ImageStack padedIs = ImgUtils.pad(inputLabelImageChosenByUser.getStack(), iPadSize, inputLabelImageChosenByUser.getNDimensions() > 2);
                    labelImg = inputLabelImageChosenByUser.duplicate();
                    labelImg.setStack(padedIs);
                    labelImage.initWithImg(labelImg);
                    labelImage.initBorder();
                    labelImage.connectedComponents();
                    break;
                }
                String msg = "No valid label image given.";
                IJ.showMessage((String)"No valid label image given.");
                return null;
            }
            default: {
                throw new RuntimeException("No valid input option in User Input. Abort");
            }
        }
        return labelImage;
    }

    public static enum RegularizationType {
        Sphere_Regularization("Sphere Reguralization"),
        Approximative("Approximative"),
        None("None");

        private final String iName;

        private RegularizationType(String aName) {
            this.iName = aName;
        }

        public String toString() {
            return this.iName;
        }

        public static RegularizationType getEnum(String aString) {
            for (RegularizationType t : RegularizationType.values()) {
                if (!t.toString().equals(aString)) continue;
                return t;
            }
            return RegularizationType.valueOf(aString);
        }
    }

    public static enum EnergyFunctionalType {
        e_PC("PC"),
        e_PS("PS"),
        e_DeconvolutionPC("Deconvolution PC"),
        e_PC_Gauss("PC Gauss");

        private final String iName;

        private EnergyFunctionalType(String aName) {
            this.iName = aName;
        }

        public String toString() {
            return this.iName;
        }

        public static EnergyFunctionalType getEnum(String aString) {
            for (EnergyFunctionalType t : EnergyFunctionalType.values()) {
                if (!t.toString().equals(aString)) continue;
                return t;
            }
            return EnergyFunctionalType.valueOf(aString);
        }
    }

    public static enum InitializationType {
        Rectangle("Rectangle"),
        Bubbles("Bubbles"),
        LocalMax("Local Maximum"),
        ROI_2D("ROI 2D"),
        File("File with regions");

        private final String iName;

        private InitializationType(String aName) {
            this.iName = aName;
        }

        public String toString() {
            return this.iName;
        }

        public static InitializationType getEnum(String aString) {
            for (InitializationType t : InitializationType.values()) {
                if (!t.toString().equals(aString)) continue;
                return t;
            }
            return InitializationType.valueOf(aString);
        }
    }
}

