/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.energies;

import java.util.HashMap;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.regions.RC.ContourParticle;
import mosaic.regions.energies.Energy;
import mosaic.regions.utils.LabelStatistics;

public class E_Gamma
extends Energy.InternalEnergy {
    protected final LabelImage iLabelImage;

    public E_Gamma(LabelImage aLabelImage) {
        this.iLabelImage = aLabelImage;
    }

    @Override
    public Energy.EnergyResult CalculateEnergyDifference(Point contourPoint, ContourParticle contourParticle, int toLabel, HashMap<Integer, LabelStatistics> labelMap) {
        int pLabel = contourParticle.candidateLabel;
        int nSameNeighbors = 0;
        int nOtherNeighbors = 0;
        for (int neighbor : this.iLabelImage.iterateNeighbours(contourPoint)) {
            int neighborLabel = this.iLabelImage.getLabelAbs(neighbor);
            if (neighborLabel == pLabel) {
                ++nSameNeighbors;
                continue;
            }
            ++nOtherNeighbors;
        }
        double dGamma = (double)(nOtherNeighbors - nSameNeighbors) / (double)this.iLabelImage.getConnFG().getNeighborhoodSize();
        return new Energy.EnergyResult(dGamma, false);
    }
}

