/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.energies;

import java.util.HashMap;
import mosaic.core.imageUtils.Point;
import mosaic.regions.RC.ContourParticle;
import mosaic.regions.energies.Energy;
import mosaic.regions.utils.LabelStatistics;

public class E_PC_Gauss
extends Energy.ExternalEnergy {
    double CalculateVariance(double aSumSq, double aMean, int aN) {
        if (aN < 2) {
            return 0.0;
        }
        return (aSumSq - (double)aN * aMean * aMean) / ((double)aN - 1.0);
    }

    @Override
    public Energy.EnergyResult CalculateEnergyDifference(Point contourPoint, ContourParticle contourParticle, int toLabel, HashMap<Integer, LabelStatistics> labelMap) {
        int fromLabel = contourParticle.label;
        double aValue = contourParticle.intensity;
        LabelStatistics toStats = labelMap.get(toLabel);
        LabelStatistics fromStats = labelMap.get(fromLabel);
        int toCount = toStats.iLabelCount;
        int fromCount = fromStats.iLabelCount;
        double newToMean = (toStats.iSum + aValue) / ((double)toCount + 1.0);
        double newFromMean = fromCount > 0 ? (fromStats.iSum - aValue) / ((double)fromCount - 1.0) : 0.0;
        double newToVar = this.CalculateVariance(toStats.iSumOfSq + aValue * aValue, newToMean, toCount + 1);
        double newFromVar = this.CalculateVariance(fromStats.iSumOfSq - aValue * aValue, newFromMean, fromCount - 1);
        double oldToVar = toStats.iVarIntensity;
        double oldFromVar = fromStats.iVarIntensity;
        if (newToVar <= 0.0) {
            newToVar = Math.ulp(1.0) * 10.0;
        }
        if (newFromVar <= 0.0) {
            newFromVar = Math.ulp(1.0) * 10.0;
        }
        if (oldToVar <= 0.0) {
            oldToVar = Math.ulp(1.0) * 10.0;
        }
        if (oldFromVar <= 0.0) {
            oldFromVar = Math.ulp(1.0) * 10.0;
        }
        double vOneBySq2Pi = 1.0 / Math.sqrt(Math.PI * 2);
        double energy = ((double)fromCount - 1.0) * Math.log(vOneBySq2Pi / Math.sqrt(newFromVar)) - ((double)fromCount - 1.0) / 2.0;
        energy -= (double)fromCount * Math.log(vOneBySq2Pi / Math.sqrt(oldFromVar)) - (double)fromCount / 2.0;
        energy += ((double)toCount + 1.0) * Math.log(vOneBySq2Pi / Math.sqrt(newToVar)) - ((double)toCount + 1.0) / 2.0;
        energy -= (double)toCount * Math.log(vOneBySq2Pi / Math.sqrt(oldToVar)) - (double)toCount / 2.0;
        return new Energy.EnergyResult(energy *= -1.0, false);
    }
}

