/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.energies;

import java.util.HashMap;
import mosaic.core.imageUtils.MaskOnSpaceMapper;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.IntensityImage;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.imageUtils.masks.BallMask;
import mosaic.regions.RC.ContourParticle;
import mosaic.regions.energies.E_KLMergingCriterion;
import mosaic.regions.energies.Energy;
import mosaic.regions.utils.LabelStatistics;

public class E_PS
extends Energy.ExternalEnergy {
    private final int iBgLabel;
    private final IntensityImage iIntensityImage;
    private final LabelImage iLabelImage;
    private final float iBalloonForceCoeff;
    private final float iRegionMergingThreshold;
    private final MaskOnSpaceMapper iSphereIt;

    public E_PS(LabelImage aLabelImage, IntensityImage aIntensityImage, int aPsEnergyRadius, float aBalloonForceCoeff, float aRegionMergingThreshold) {
        this.iBgLabel = 0;
        this.iIntensityImage = aIntensityImage;
        this.iLabelImage = aLabelImage;
        this.iBalloonForceCoeff = aBalloonForceCoeff;
        this.iRegionMergingThreshold = aRegionMergingThreshold;
        this.iSphereIt = new MaskOnSpaceMapper(new BallMask(aPsEnergyRadius, this.iLabelImage.getNumOfDimensions()), this.iLabelImage.getDimensions());
    }

    @Override
    public Energy.EnergyResult CalculateEnergyDifference(Point aContourPoint, ContourParticle aContourParticle, int aToLabel, HashMap<Integer, LabelStatistics> aLabelStats) {
        double varFrom;
        double meanFrom;
        double varTo;
        double meanTo;
        double value = aContourParticle.intensity;
        int fromLabel = aContourParticle.label;
        this.iSphereIt.setMiddlePoint(aContourPoint);
        double sumFrom = -value;
        double sumSquaredFrom = -value * value;
        int cntFrom = -1;
        double sumTo = 0.0;
        double sumSquaredTo = 0.0;
        int cntTo = 0;
        while (this.iSphereIt.hasNext()) {
            double data;
            int labelIdx = this.iSphereIt.next();
            int absLabel = this.iLabelImage.getLabelAbs(labelIdx);
            if (absLabel == fromLabel) {
                data = this.iIntensityImage.get(labelIdx);
                sumFrom += data;
                sumSquaredFrom += data * data;
                ++cntFrom;
                continue;
            }
            if (absLabel != aToLabel) continue;
            data = this.iIntensityImage.get(labelIdx);
            sumTo += data;
            sumSquaredTo += data * data;
            ++cntTo;
        }
        if (cntTo == 0) {
            LabelStatistics info = aLabelStats.get(aToLabel);
            meanTo = info.iMeanIntensity;
            varTo = info.iVarIntensity;
        } else {
            meanTo = sumTo / (double)cntTo;
            varTo = (sumSquaredTo - sumTo * sumTo / (double)cntTo) / (double)cntTo;
        }
        if (cntFrom == 0) {
            LabelStatistics info = aLabelStats.get(fromLabel);
            meanFrom = info.iMeanIntensity;
            varFrom = info.iVarIntensity;
        } else {
            meanFrom = sumFrom / (double)cntFrom;
            varFrom = (sumSquaredFrom - sumFrom * sumFrom / (double)cntFrom) / (double)cntFrom;
        }
        boolean shouldMerge = false;
        if (fromLabel != this.iBgLabel && aToLabel != this.iBgLabel && E_KLMergingCriterion.calc(meanFrom, meanTo, varFrom, varTo, cntFrom, cntTo) < (double)this.iRegionMergingThreshold) {
            shouldMerge = true;
        }
        double energyDiff = Math.pow(value - meanTo, 2.0) - Math.pow(value - meanFrom, 2.0);
        if (fromLabel == 0) {
            float vCurrentImageValue = (float)value;
            energyDiff = this.iBalloonForceCoeff > 0.0f ? (energyDiff -= (double)(this.iBalloonForceCoeff * vCurrentImageValue)) : (energyDiff -= (double)(-this.iBalloonForceCoeff * (1.0f - vCurrentImageValue)));
        }
        return new Energy.EnergyResult(energyDiff, shouldMerge);
    }
}

