/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.topology;

import java.util.ArrayDeque;
import java.util.Queue;
import mosaic.core.imageUtils.Connectivity;
import mosaic.core.imageUtils.Point;

class UnitCubeConnectedComponenetsCounter {
    private final Connectivity iConnectivity;
    private final Connectivity iNeighborhoodConnectivity;
    private final boolean[] iIndex2NeighbourMap;
    private final boolean[][] iUnitCubeNeighborsMap;
    private final Queue<Integer> iQueue;
    private char[] iImage;

    public UnitCubeConnectedComponenetsCounter(Connectivity aConnectivity) {
        this.iConnectivity = aConnectivity;
        this.iNeighborhoodConnectivity = aConnectivity.getIncreasedConnectivity();
        this.iIndex2NeighbourMap = this.createIndex2NeighbourMap();
        this.iUnitCubeNeighborsMap = this.crateUnitCubeNeighborsMap();
        this.iQueue = new ArrayDeque<Integer>(this.iConnectivity.getNeighborhoodSize());
    }

    public UnitCubeConnectedComponenetsCounter SetImage(char[] aImage) {
        this.iImage = (char[])aImage.clone();
        return this;
    }

    private boolean[] createIndex2NeighbourMap() {
        int neighborhoodSize = this.iConnectivity.getNeighborhoodSize();
        boolean[] result = new boolean[neighborhoodSize];
        for (int i = 0; i < neighborhoodSize; ++i) {
            result[i] = this.iConnectivity.isNeighbor(i);
        }
        return result;
    }

    boolean[][] crateUnitCubeNeighborsMap() {
        int neighborhoodSize = this.iConnectivity.getNeighborhoodSize();
        boolean[][] neighborsInUnitCube = new boolean[neighborhoodSize][neighborhoodSize];
        int numOfDimensions = this.iConnectivity.getNumOfDimensions();
        for (int neighbor1 = 0; neighbor1 < neighborhoodSize; ++neighbor1) {
            if (!this.iNeighborhoodConnectivity.isNeighbor(neighbor1)) continue;
            for (int neighbor2 = 0; neighbor2 < neighborhoodSize; ++neighbor2) {
                Point p1 = this.iConnectivity.toPoint(neighbor1);
                Point p2 = this.iConnectivity.toPoint(neighbor2);
                Point sum = p1.add(p2);
                boolean inUnitCube = true;
                for (int d = 0; d < numOfDimensions && inUnitCube; ++d) {
                    if (sum.iCoords[d] >= -1 && sum.iCoords[d] <= 1) continue;
                    inUnitCube = false;
                }
                if (!inUnitCube || !this.iConnectivity.isNeighbor(p2) || !this.iNeighborhoodConnectivity.isNeighbor(sum)) continue;
                int sumOffset = this.iConnectivity.toIndex(sum);
                neighborsInUnitCube[neighbor1][sumOffset] = true;
            }
        }
        return neighborsInUnitCube;
    }

    public int getNumberOfConnectedComponents() {
        int numOfConnectedComponents = 0;
        int neighborhoodSize = this.iConnectivity.getNeighborhoodSize();
        boolean[] processedIndices = new boolean[neighborhoodSize];
        this.iQueue.clear();
        int seed = 0;
        while (seed < neighborhoodSize) {
            while (seed < neighborhoodSize && (this.iImage[seed] == '\u0000' || !this.iIndex2NeighbourMap[seed] || processedIndices[seed])) {
                ++seed;
            }
            if (seed >= neighborhoodSize) break;
            ++numOfConnectedComponents;
            processedIndices[seed] = true;
            this.iQueue.add(seed);
            while (!this.iQueue.isEmpty()) {
                int current = this.iQueue.poll();
                for (int neighbor = 0; neighbor < neighborhoodSize; ++neighbor) {
                    if (processedIndices[neighbor] || this.iImage[neighbor] == '\u0000' || !this.iUnitCubeNeighborsMap[current][neighbor]) continue;
                    this.iQueue.add(neighbor);
                    processedIndices[neighbor] = true;
                }
            }
        }
        return numOfConnectedComponents;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (Base: " + this.iConnectivity + ", Increased: " + this.iNeighborhoodConnectivity + ")";
    }
}

