/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils;

public class ArrayOps {
    public static MinMax<Float> findMinMax(float[][] aArray) {
        int arrayW = aArray[0].length;
        int arrayH = aArray.length;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int y = 0; y < arrayH; ++y) {
            for (int x = 0; x < arrayW; ++x) {
                float pix = aArray[y][x];
                if (pix < min) {
                    min = pix;
                }
                if (!(pix > max)) continue;
                max = pix;
            }
        }
        return new MinMax<Float>(Float.valueOf(min), Float.valueOf(max));
    }

    public static MinMax<Double> findMinMax(double[][] aArray) {
        int arrayW = aArray[0].length;
        int arrayH = aArray.length;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int y = 0; y < arrayH; ++y) {
            for (int x = 0; x < arrayW; ++x) {
                double pix = aArray[y][x];
                if (pix < min) {
                    min = pix;
                }
                if (!(pix > max)) continue;
                max = pix;
            }
        }
        return new MinMax<Double>(min, max);
    }

    public static MinMax<Double> findMinMax(double[][][] aArray) {
        int arrayW = aArray[0][0].length;
        int arrayH = aArray[0].length;
        int arrayZ = aArray.length;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int z = 0; z < arrayZ; ++z) {
            for (int y = 0; y < arrayH; ++y) {
                for (int x = 0; x < arrayW; ++x) {
                    double pix = aArray[z][y][x];
                    if (pix < min) {
                        min = pix;
                    }
                    if (!(pix > max)) continue;
                    max = pix;
                }
            }
        }
        return new MinMax<Double>(min, max);
    }

    public static MinMax<Float> findMinMax(float[] aArray) {
        int len = aArray.length;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int x = 0; x < len; ++x) {
            float pix = aArray[x];
            if (pix < min) {
                min = pix;
            }
            if (!(pix > max)) continue;
            max = pix;
        }
        return new MinMax<Float>(Float.valueOf(min), Float.valueOf(max));
    }

    public static MinMax<Double> findMinMax(double[] aArray) {
        int len = aArray.length;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int x = 0; x < len; ++x) {
            double pix = aArray[x];
            if (pix < min) {
                min = pix;
            }
            if (!(pix > max)) continue;
            max = pix;
        }
        return new MinMax<Double>(min, max);
    }

    public static void normalize(float[][] aArray) {
        MinMax<Float> minMax = ArrayOps.findMinMax(aArray);
        float min = minMax.getMin().floatValue();
        float max = minMax.getMax().floatValue();
        int arrayW = aArray[0].length;
        int arrayH = aArray.length;
        if (max != min) {
            for (int y = 0; y < arrayH; ++y) {
                for (int x = 0; x < arrayW; ++x) {
                    aArray[y][x] = (aArray[y][x] - min) / (max - min);
                }
            }
        }
    }

    public static void normalize(double[][] aArray) {
        MinMax<Double> minMax = ArrayOps.findMinMax(aArray);
        double min = minMax.getMin();
        double max = minMax.getMax();
        int arrayW = aArray[0].length;
        int arrayH = aArray.length;
        if (max != min) {
            for (int y = 0; y < arrayH; ++y) {
                for (int x = 0; x < arrayW; ++x) {
                    aArray[y][x] = (aArray[y][x] - min) / (max - min);
                }
            }
        }
    }

    public static MinMax<Double> normalize(double[][][] aArray) {
        MinMax<Double> minMax = ArrayOps.findMinMax(aArray);
        double min = minMax.getMin();
        double max = minMax.getMax();
        ArrayOps.normalize(aArray, aArray, min, max);
        return minMax;
    }

    public static void normalize(double[][][] aArraySrc, double[][][] aArrayDst, double aMin, double aMax) {
        int arrayW = aArraySrc[0][0].length;
        int arrayH = aArraySrc[0].length;
        int arrayZ = aArraySrc.length;
        if (aMax != aMin) {
            for (int z = 0; z < arrayZ; ++z) {
                for (int y = 0; y < arrayH; ++y) {
                    for (int x = 0; x < arrayW; ++x) {
                        aArrayDst[z][y][x] = (aArraySrc[z][y][x] - aMin) / (aMax - aMin);
                    }
                }
            }
        }
    }

    public static void normalize(float[] aArray) {
        MinMax<Float> minMax = ArrayOps.findMinMax(aArray);
        float min = minMax.getMin().floatValue();
        float max = minMax.getMax().floatValue();
        int len = aArray.length;
        if (max != min) {
            for (int x = 0; x < len; ++x) {
                aArray[x] = (aArray[x] - min) / (max - min);
            }
        }
    }

    public static void normalize(double[] aArray) {
        MinMax<Double> minMax = ArrayOps.findMinMax(aArray);
        double min = minMax.getMin();
        double max = minMax.getMax();
        int len = aArray.length;
        if (max != min) {
            for (int x = 0; x < len; ++x) {
                aArray[x] = (aArray[x] - min) / (max - min);
            }
        }
    }

    public static void convertRange(float[][] aArray, float aMultiply, float aShift) {
        int arrayW = aArray[0].length;
        int arrayH = aArray.length;
        for (int y = 0; y < arrayH; ++y) {
            for (int x = 0; x < arrayW; ++x) {
                aArray[y][x] = aArray[y][x] * aMultiply + aShift;
            }
        }
    }

    public static void fill(short[][][] aArray, short aValue) {
        int lenX = aArray.length;
        int lenY = aArray[0].length;
        int lenZ = aArray[0][0].length;
        for (int x = 0; x < lenX; ++x) {
            for (int y = 0; y < lenY; ++y) {
                for (int z = 0; z < lenZ; ++z) {
                    aArray[x][y][z] = aValue;
                }
            }
        }
    }

    public static void fill(float[][][] aArray, float aValue) {
        int lenX = aArray.length;
        int lenY = aArray[0].length;
        int lenZ = aArray[0][0].length;
        for (int x = 0; x < lenX; ++x) {
            for (int y = 0; y < lenY; ++y) {
                for (int z = 0; z < lenZ; ++z) {
                    aArray[x][y][z] = aValue;
                }
            }
        }
    }

    public static void fill(double[][][] aArray, double aValue) {
        int lenX = aArray.length;
        int lenY = aArray[0].length;
        int lenZ = aArray[0][0].length;
        for (int x = 0; x < lenX; ++x) {
            for (int y = 0; y < lenY; ++y) {
                for (int z = 0; z < lenZ; ++z) {
                    aArray[x][y][z] = aValue;
                }
            }
        }
    }

    public static void fill(double[][] aArray, double aValue) {
        int lenX = aArray.length;
        int lenY = aArray[0].length;
        for (int x = 0; x < lenX; ++x) {
            for (int y = 0; y < lenY; ++y) {
                aArray[x][y] = aValue;
            }
        }
    }

    public static class MinMax<T> {
        private final T min;
        private final T max;

        public MinMax(T aMin, T aMax) {
            this.min = aMin;
            this.max = aMax;
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }

        public String toString() {
            return "Min/Max: " + this.min + " / " + this.max;
        }
    }
}

