/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Array;
import java.util.Arrays;

public class Debug {
    public static void debugPrint(String aDebugMessage) {
        System.out.println(aDebugMessage);
    }

    public static void print(Object ... aObjects) {
        Debug.debugPrint(Debug.getString(aObjects) + "\n");
    }

    public static String getString(Object ... aObjects) {
        String str = "";
        for (Object o : aObjects) {
            if (o != null && o.getClass().isArray()) {
                Object[] arr = new Object[]{"Dim/Content", Debug.getArrayDims(o), o};
                str = str + Arrays.deepToString(arr);
                continue;
            }
            str = str + "[" + o + "] ";
        }
        return str;
    }

    public static String getJsonString(Object ... aObjects) {
        String str = "";
        for (Object obj : aObjects) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(obj);
            str = str + "[" + json + "] ";
        }
        return str;
    }

    public static String getArrayDims(Object aArray) {
        if (aArray == null) {
            return "null[]";
        }
        if (!aArray.getClass().isArray()) {
            return "Not an array!";
        }
        StringBuilder result = new StringBuilder();
        Debug.deepLength(aArray, result);
        return result.toString();
    }

    private static void deepLength(Object aArrayObj, StringBuilder aOutputBuffer) {
        Class<?> deepClass;
        int len = Array.getLength(aArrayObj);
        if (len == 0) {
            aOutputBuffer.append("[0] ...(possibly more dims)");
            return;
        }
        aOutputBuffer.append("[" + len + "]");
        Object deepElement = Array.get(aArrayObj, 0);
        if (deepElement != null && (deepClass = deepElement.getClass()).isArray()) {
            Debug.deepLength(deepElement, aOutputBuffer);
        }
    }

    public static String getStack(int aNumberOfEntries) {
        return Debug.getStack(aNumberOfEntries, 3);
    }

    public static String getStack(int aNumberOfEntries, int aSkipNumOfFirstLines) {
        StringBuilder result = new StringBuilder();
        int count = -aSkipNumOfFirstLines;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (count++ <= -1) continue;
            if (aNumberOfEntries != -1 && count > aNumberOfEntries) break;
            result.append(ste.toString() + "\n");
        }
        return result.toString();
    }

    public static void printStack() {
        Debug.debugPrint(Debug.getStack(-1, 3));
    }
}

