/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.io.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import mosaic.utils.io.serialize.DataFile;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class JsonDataFile<T>
implements DataFile<T> {
    private static final Logger logger = Logger.getLogger(JsonDataFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean SaveToFile(String aSerializedFileName, T aObject2Save) {
        logger.debug((Object)("SaveToFile [" + aSerializedFileName + "]"));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(aObject2Save);
        FileOutputStream fileOutput = null;
        try {
            fileOutput = new FileOutputStream(aSerializedFileName);
            fileOutput.write(json.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            logger.debug((Object)("File [" + aSerializedFileName + "] cannot be written!"));
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            logger.error((Object)("An error occured during writing json file [" + aSerializedFileName + "]"));
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                if (fileOutput != null) {
                    fileOutput.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    @Override
    public T LoadFromFile(String aSerializedFileName, Class<T> aClazz) {
        logger.debug((Object)("Loading from file [" + aSerializedFileName + "]"));
        Gson gson = new Gson();
        try {
            FileInputStream fileInput = new FileInputStream(aSerializedFileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileInput));
            StringBuilder json = new StringBuilder();
            String aDataRow = "";
            while ((aDataRow = reader.readLine()) != null) {
                json.append(aDataRow);
            }
            reader.close();
            Object obj = gson.fromJson(json.toString(), aClazz);
            return (T)obj;
        }
        catch (FileNotFoundException e) {
            logger.debug((Object)("File [" + aSerializedFileName + "] not found."));
            return null;
        }
        catch (Exception e) {
            logger.error((Object)("An error occured during reading json file [" + aSerializedFileName + "]"));
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    @Override
    public T LoadFromFile(String aSerializedFileName, Class<T> aClazz, T aDefaultValue) {
        T temp = this.LoadFromFile(aSerializedFileName, aClazz);
        if (temp != null) {
            return temp;
        }
        logger.debug((Object)"Returning default value.");
        return aDefaultValue;
    }
}

