/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.io.serialize;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import mosaic.utils.io.serialize.DataFile;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class SerializedDataFile<T extends Serializable>
implements DataFile<T> {
    private static final Logger logger = Logger.getLogger(SerializedDataFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean SaveToFile(String aSerializedFileName, T aObject2Save) {
        logger.debug((Object)("SaveToFile [" + aSerializedFileName + "]"));
        boolean ret = false;
        FileOutputStream fileOutput = null;
        ObjectOutputStream objectOutput = null;
        try {
            fileOutput = new FileOutputStream(aSerializedFileName);
            objectOutput = new ObjectOutputStream(fileOutput);
            objectOutput.writeObject(aObject2Save);
            ret = true;
            this.close(objectOutput);
            this.close(fileOutput);
        }
        catch (FileNotFoundException e) {
            logger.debug((Object)("File [" + aSerializedFileName + "] cannot be written!"));
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            this.close(objectOutput);
            this.close(fileOutput);
        }
        catch (IOException e2) {
            logger.error((Object)("An error occured during writing serialized file [" + aSerializedFileName + "]"));
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)e2));
            this.close(objectOutput);
            this.close(fileOutput);
            {
                catch (Throwable throwable) {
                    this.close(objectOutput);
                    this.close(fileOutput);
                    throw throwable;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public T LoadFromFile(String aSerializedFileName, Class<T> aClazz) {
        logger.debug((Object)("LoadFromFile [" + aSerializedFileName + "]"));
        Serializable ret = null;
        FileInputStream fileInput = null;
        ObjectInputStream objectInput = null;
        try {
            fileInput = new FileInputStream(aSerializedFileName);
            objectInput = new ObjectInputStream(fileInput);
            Object readObj = null;
            try {
                readObj = objectInput.readObject();
                ret = (Serializable)aClazz.cast(readObj);
            }
            catch (ClassCastException e) {
                String readObjName = readObj == null ? "null" : readObj.getClass().getName();
                logger.error((Object)("Different type of object read [" + readObjName + "] vs. [" + aClazz.getName() + "]"));
                logger.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
                ret = null;
            }
            this.close(objectInput);
            this.close(fileInput);
        }
        catch (FileNotFoundException e) {
            logger.debug((Object)("File [" + aSerializedFileName + "] not found."));
            this.close(objectInput);
            this.close(fileInput);
        }
        catch (Exception e2) {
            logger.error((Object)("An error occured during reading serialized file [" + aSerializedFileName + "]"));
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)e2));
            this.close(objectInput);
            this.close(fileInput);
            {
                catch (Throwable throwable) {
                    this.close(objectInput);
                    this.close(fileInput);
                    throw throwable;
                }
            }
        }
        return (T)ret;
    }

    @Override
    public T LoadFromFile(String aSerializedFileName, Class<T> aClazz, T aDefaultValue) {
        Object temp = this.LoadFromFile(aSerializedFileName, (Class)aClazz);
        if (temp != null) {
            return (T)temp;
        }
        return aDefaultValue;
    }

    private void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                logger.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }
}

