/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

import java.util.Arrays;
import mosaic.utils.math.Polynomial;

public class CubicSmoothingSpline {
    private final Polynomial[] iSplines;
    private final double[] iX;
    private double[] iY;
    private final double[] iWeights;
    private double iSmoothingParameter;

    public CubicSmoothingSpline(double[] aXvalues, double[] aYvalues, FittingStrategy aStrategy, double aMaxErrorValue) {
        this(aXvalues, aYvalues, aXvalues.length == 2 ? 1.0E-52 : 0.5, null);
        if (aXvalues.length == 2) {
            return;
        }
        int step = 1;
        double direction = 1.0;
        if (aStrategy == FittingStrategy.AverageValue) {
            aMaxErrorValue *= (double)aXvalues.length;
        }
        while (step <= 52) {
            double currentError = 0.0;
            for (int i = 0; i < aXvalues.length; ++i) {
                double diff = Math.abs(this.getValue(aXvalues[i]) - aYvalues[i]);
                if (aStrategy == FittingStrategy.MaxSinglePointValue) {
                    if (currentError < diff) {
                        currentError = diff;
                    }
                    if (!(currentError > aMaxErrorValue)) continue;
                    break;
                }
                if (aStrategy != FittingStrategy.AverageValue) continue;
                currentError += diff;
            }
            if (currentError > 0.99 * aMaxErrorValue && currentError <= aMaxErrorValue) break;
            direction = currentError <= aMaxErrorValue ? -1.0 : 1.0;
            this.iSmoothingParameter += direction * Math.pow(2.0, -(++step));
            this.resolve(this.iX, this.iY, this.iSplines, this.iSmoothingParameter, this.iWeights);
        }
    }

    public CubicSmoothingSpline(double[] aXvalues, double[] aYvalues, FittingStrategy aStrategy, double aMaxErrorValue, double aMaxTolerance) {
        this(aXvalues, aYvalues, aStrategy, aMaxErrorValue);
        this.iY = (double[])aYvalues.clone();
        double[] deltaY = new double[this.iY.length];
        int iter = 0;
        do {
            int i;
            double currentError = 0.0;
            for (i = 0; i < aXvalues.length; ++i) {
                deltaY[i] = aYvalues[i] - this.getValue(aXvalues[i]);
                if (!(Math.abs(deltaY[i]) > currentError)) continue;
                currentError = Math.abs(deltaY[i]);
            }
            if (currentError < aMaxTolerance) break;
            for (i = 0; i < aXvalues.length; ++i) {
                int n = i;
                this.iY[n] = this.iY[n] + 2.0 * deltaY[i];
            }
            this.resolve(this.iX, this.iY, this.iSplines, this.iSmoothingParameter, this.iWeights);
        } while (++iter < 100000);
    }

    public CubicSmoothingSpline(double[] aXvalues, double[] aYvalues, double aSmoothingParameter) {
        this(aXvalues, aYvalues, aSmoothingParameter, null);
    }

    public CubicSmoothingSpline(double[] aXvalues, double[] aYvalues, double aSmoothingParameter, double[] aWeights) {
        if (aWeights == null) {
            this.iWeights = new double[aXvalues.length];
            for (int i = 0; i < this.iWeights.length; ++i) {
                this.iWeights[i] = 1.0;
            }
        } else {
            this.iWeights = aWeights;
        }
        this.iX = aXvalues;
        this.iY = aYvalues;
        this.iSplines = new Polynomial[this.iX.length - 1];
        this.iSmoothingParameter = aSmoothingParameter;
        this.resolve(this.iX, this.iY, this.iSplines, this.iSmoothingParameter, this.iWeights);
    }

    public double getValue(double aX) {
        int idx = this.findSplineIndex(aX);
        return this.iSplines[idx].getValue(aX - this.iX[idx]);
    }

    public Spline getSplineForValue(double aX) {
        int idx = this.findSplineIndex(aX);
        return new Spline(this.iSplines[idx], this.iX[idx]);
    }

    private int findSplineIndex(double aX) {
        int idx = Arrays.binarySearch(this.iX, aX);
        if (idx < 0) {
            idx = -(idx + 1) - 1;
        }
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= this.iX.length - 1) {
            --idx;
        }
        return idx;
    }

    public double getSmoothingParameter() {
        return this.iSmoothingParameter;
    }

    public int getNumberOfKNots() {
        return this.iX.length;
    }

    public double[] getKnots() {
        return this.iX;
    }

    public double[] getValues() {
        return this.iY;
    }

    public double[] getWeights() {
        return this.iWeights;
    }

    public double getKnot(int aIdx) {
        return this.iX[aIdx];
    }

    public double[][] getCoefficients() {
        double[][] l = new double[this.iSplines.length][4];
        for (int i = 0; i < this.iSplines.length; ++i) {
            l[i] = this.iSplines[i].getCoefficients();
        }
        return l;
    }

    public String toString() {
        String result = "--------------- Cubic smoothing splines ----------------------\n";
        result = result + "Knots: (" + this.iX.length + ")\n";
        result = result + Arrays.toString(this.iX);
        result = result + "\n\nValues: (" + this.iY.length + ")\n";
        result = result + Arrays.toString(this.iY);
        result = result + "\n\nWeights: (" + this.iWeights.length + ")\n";
        result = result + Arrays.toString(this.iWeights);
        result = result + "\n\nPolynomials: \n";
        int count = 1;
        for (Polynomial p : this.iSplines) {
            result = result + count++;
            result = result + ": ";
            result = result + p;
            result = result + "\n";
        }
        result = result + "--------------------------------------------------------------\n";
        return result;
    }

    private void Quincunx(double[] u, double[] v, double[] w, double[] q) {
        int j;
        int n = u.length;
        u[0] = 0.0;
        v[1] = v[1] / u[1];
        w[1] = w[1] / u[1];
        for (j = 2; j < n - 1; ++j) {
            u[j] = u[j] - u[j - 2] * Math.pow(w[j - 2], 2.0) - u[j - 1] * Math.pow(v[j - 1], 2.0);
            v[j] = (v[j] - u[j - 1] * v[j - 1] * w[j - 1]) / u[j];
            w[j] = w[j] / u[j];
        }
        q[1] = q[1] - v[0] * q[0];
        for (j = 2; j < n - 1; ++j) {
            q[j] = q[j] - v[j - 1] * q[j - 1] - w[j - 2] * q[j - 2];
        }
        for (j = 1; j < n - 1; ++j) {
            q[j] = q[j] / u[j];
        }
        q[n] = 0.0;
        for (j = n - 2; j >= 1; --j) {
            q[j] = q[j] - v[j] * q[j + 1] - w[j] * q[j + 2];
        }
    }

    private void resolve(double[] aX, double[] aY, Polynomial[] aSplines, double aLambda, double[] aWeights) {
        int i;
        int n = aX.length;
        double[] h = new double[n];
        double[] r = new double[n];
        double[] f = new double[n];
        double[] p = new double[n];
        double[] u = new double[n];
        double[] v = new double[n];
        double[] w = new double[n];
        double[] q = new double[n + 1];
        double[] sigma = new double[n];
        for (i = 0; i < n; ++i) {
            sigma[i] = 1.0 / aWeights[i];
        }
        --n;
        double mu = 2.0 * (1.0 - aLambda) / (3.0 * aLambda);
        h[0] = aX[1] - aX[0];
        r[0] = 3.0 / h[0];
        for (i = 1; i <= n - 1; ++i) {
            h[i] = aX[i + 1] - aX[i];
            r[i] = 3.0 / h[i];
            f[i] = -(r[i - 1] + r[i]);
            p[i] = 2.0 * (aX[i + 1] - aX[i - 1]);
            q[i] = 3.0 * (aY[i + 1] - aY[i]) / h[i] - 3.0 * (aY[i] - aY[i - 1]) / h[i - 1];
        }
        for (i = 1; i <= n - 1; ++i) {
            u[i] = Math.pow(r[i - 1], 2.0) * sigma[i - 1] + Math.pow(f[i], 2.0) * sigma[i] + Math.pow(r[i], 2.0) * sigma[i + 1];
            u[i] = mu * u[i] + p[i];
            v[i] = f[i] * r[i] * sigma[i] + r[i] * f[i + 1] * sigma[i + 1];
            v[i] = mu * v[i] + h[i];
            w[i] = mu * r[i] * r[i + 1] * sigma[i + 1];
        }
        this.Quincunx(u, v, w, q);
        double d = aY[0] - mu * r[0] * q[1] * sigma[0];
        double nextD = aY[1] - mu * (f[1] * q[1] + r[1] * q[2]) * sigma[1];
        double a = q[1] / (3.0 * h[0]);
        double b = 0.0;
        double c = (nextD - d) / h[0] - q[1] * h[0] / 3.0;
        aSplines[0] = new Polynomial(a, b, c, d);
        r[0] = 0.0;
        double previousC = c;
        for (int j = 1; j <= n - 1; ++j) {
            a = (q[j + 1] - q[j]) / (3.0 * h[j]);
            b = q[j];
            c = (q[j] + q[j - 1]) * h[j - 1] + previousC;
            d = r[j - 1] * q[j - 1] + f[j] * q[j] + r[j] * q[j + 1];
            d = aY[j] - mu * d * sigma[j];
            previousC = c;
            aSplines[j] = new Polynomial(a, b, c, d);
        }
    }

    public static class Spline {
        public Polynomial equation;
        public double shift;

        Spline(Polynomial aPolynomial, double aShift) {
            this.equation = aPolynomial;
            this.shift = aShift;
        }
    }

    public static enum FittingStrategy {
        MaxSinglePointValue,
        AverageValue;

    }
}

