/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

import java.util.Arrays;
import mosaic.utils.math.StatisticsUtils;
import org.apache.commons.math3.random.RandomGenerator;

public class IndexedDiscreteDistribution {
    protected final RandomGenerator iRng;
    private final double[] iCdf;

    public IndexedDiscreteDistribution(RandomGenerator rng, double[] pmf) {
        this.iRng = rng;
        this.iCdf = StatisticsUtils.calculateCdfFromPmf(pmf, true);
    }

    public int sample() {
        double val = this.iRng.nextDouble();
        int idx = Arrays.binarySearch(this.iCdf, val);
        if (idx < 0) {
            idx = -idx - 1;
        }
        return idx;
    }
}

