/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

import mosaic.utils.math.Matlab;

public class Interpolation {
    private static final double cubicKernel(double x) {
        double u = 0.0;
        double s = Math.abs(x);
        double s2 = Math.pow(x, 2.0);
        double s3 = s * s2;
        if (s <= 1.0) {
            u = 1.5 * s3 - 2.5 * s2 + 1.0;
        } else if (s <= 2.0) {
            u = -0.5 * s3 + 2.5 * s2 - 4.0 * s + 2.0;
        }
        return u;
    }

    private static final double triangleKernel(double x) {
        double u = 0.0;
        if (x > -1.0 && x < 0.0) {
            u = x + 1.0;
        } else if (x >= 0.0 && x < 1.0) {
            u = 1.0 - x;
        }
        return u;
    }

    private static final double nearestNeighbourKernel(double x) {
        double u = 0.0;
        if (x >= -0.5 && x < 0.5) {
            u = 1.0;
        }
        return u;
    }

    private static double nearestNeighbourInterpolation(double aX, double aY, double[][] aSrc) {
        int srcWidth = aSrc.length;
        int srcHeight = aSrc[0].length;
        int x = (int)Math.floor(aX);
        int y = (int)Math.floor(aY);
        double value = 0.0;
        for (int j = 0; j <= 1; ++j) {
            int v = y + j;
            double p = 0.0;
            for (int i = 0; i <= 1; ++i) {
                int u;
                int us = u = x + i;
                int vs = v;
                if (u < 0) {
                    us = 0;
                }
                if (v < 0) {
                    vs = 0;
                }
                if (u >= srcWidth) {
                    us = srcWidth - 1;
                }
                if (v >= srcHeight) {
                    vs = srcHeight - 1;
                }
                p += aSrc[us][vs] * Interpolation.nearestNeighbourKernel(aX - (double)u);
            }
            value += p * Interpolation.nearestNeighbourKernel(aY - (double)v);
        }
        return value;
    }

    private static double bilinearInterpolation(double aX, double aY, double[][] aSrc) {
        int srcWidth = aSrc.length;
        int srcHeight = aSrc[0].length;
        int x = (int)Math.floor(aX);
        int y = (int)Math.floor(aY);
        double value = 0.0;
        for (int j = 0; j <= 1; ++j) {
            int v = y + j;
            double p = 0.0;
            for (int i = 0; i <= 1; ++i) {
                int u;
                int us = u = x + i;
                int vs = v;
                if (u < 0) {
                    us = 0;
                }
                if (v < 0) {
                    vs = 0;
                }
                if (u >= srcWidth) {
                    us = srcWidth - 1;
                }
                if (v >= srcHeight) {
                    vs = srcHeight - 1;
                }
                p += aSrc[us][vs] * Interpolation.triangleKernel(aX - (double)u);
            }
            value += p * Interpolation.triangleKernel(aY - (double)v);
        }
        return value;
    }

    public static double bicubicInterpolation(double aX, double aY, double[][] aSrc, InterpolationMode aMode) {
        int srcWidth = aSrc.length;
        int srcHeight = aSrc[0].length;
        int x = (int)Math.floor(aX);
        int y = (int)Math.floor(aY);
        if (aMode == InterpolationMode.SMART && (x <= 0 || x >= srcWidth - 2 || y <= 0 || y >= srcHeight - 2)) {
            return Interpolation.bilinearInterpolation(aX, aY, aSrc);
        }
        double value = 0.0;
        for (int j = 0; j <= 3; ++j) {
            int v = y - 1 + j;
            double p = 0.0;
            for (int i = 0; i <= 3; ++i) {
                int u;
                int us = u = x - 1 + i;
                int vs = v;
                if (u < 0) {
                    us = 0;
                }
                if (v < 0) {
                    vs = 0;
                }
                if (u >= srcWidth) {
                    us = srcWidth - 1;
                }
                if (v >= srcHeight) {
                    vs = srcHeight - 1;
                }
                p += aSrc[us][vs] * Interpolation.cubicKernel(aX - (double)u);
            }
            value += p * Interpolation.cubicKernel(aY - (double)v);
        }
        return value;
    }

    private static double[] generateCoordinates(int aDstLen, int aSrcLen, InterpolationMode aMode) {
        double startIdx = 1.0;
        double stopIdx = aSrcLen;
        if (aMode == InterpolationMode.MATLAB) {
            double scale = (double)aDstLen / (double)aSrcLen;
            double constant = 0.5 * (1.0 - 1.0 / scale);
            startIdx = 1.0 / scale + constant;
            stopIdx = (double)aDstLen / scale + constant;
        }
        double[] mapping = aDstLen != 1 ? Matlab.linspaceArray(startIdx, stopIdx, aDstLen) : new double[]{((double)aSrcLen - 1.0) / 2.0 + 1.0};
        return mapping;
    }

    public static double[][] resize(double[][] aSrcImage, int aHeight, int aWidth, InterpolationType aType, InterpolationMode aMode) {
        double[][] resultImg = new double[aHeight][aWidth];
        int srcWidth = aSrcImage.length;
        int srcHeight = aSrcImage[0].length;
        double[] newY = Interpolation.generateCoordinates(aHeight, srcWidth, aMode);
        double[] newX = Interpolation.generateCoordinates(aWidth, srcHeight, aMode);
        for (int x = 0; x <= aWidth - 1; ++x) {
            double ys = newX[x] - 1.0;
            block5: for (int y = 0; y <= aHeight - 1; ++y) {
                double xs = newY[y] - 1.0;
                switch (aType) {
                    case BILINEAR: {
                        resultImg[y][x] = Interpolation.bilinearInterpolation(xs, ys, aSrcImage);
                        continue block5;
                    }
                    case NEAREST: {
                        resultImg[y][x] = Interpolation.nearestNeighbourInterpolation(xs, ys, aSrcImage);
                        continue block5;
                    }
                    default: {
                        resultImg[y][x] = Interpolation.bicubicInterpolation(xs, ys, aSrcImage, aMode);
                    }
                }
            }
        }
        return resultImg;
    }

    public static enum InterpolationMode {
        NONE,
        SMART,
        MATLAB;

    }

    public static enum InterpolationType {
        BILINEAR,
        BICUBIC,
        NEAREST;

    }
}

