/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

public class MathOps {
    public static int factorial(int aN) {
        int factorial = 1;
        for (int i = 2; i <= aN; ++i) {
            factorial *= i;
        }
        return factorial;
    }

    public static double bessel0(double aX) throws ArithmeticException {
        double d;
        double ax = Math.abs(aX);
        if (d < 8.0) {
            double y = aX * aX;
            double ans1 = 5.7568490574E10 + y * (-1.3362590354E10 + y * (6.516196407E8 + y * (-1.121442418E7 + y * (77392.33017 + y * -184.9052456))));
            double ans2 = 5.7568490411E10 + y * (1.029532985E9 + y * (9494680.718 + y * (59272.64853 + y * (267.8532712 + y * 1.0))));
            return ans1 / ans2;
        }
        double z = 8.0 / ax;
        double y = z * z;
        double xx = ax - 0.785398164;
        double ans1 = 1.0 + y * (-0.001098628627 + y * (2.734510407E-5 + y * (-2.073370639E-6 + y * 2.093887211E-7)));
        double ans2 = -0.01562499995 + y * (1.430488765E-4 + y * (-6.911147651E-6 + y * (7.621095161E-7 - y * 9.34935152E-8)));
        return Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
    }

    public static double bessel1(double aX) throws ArithmeticException {
        double d;
        double ax = Math.abs(aX);
        if (d < 8.0) {
            double y = aX * aX;
            double ans1 = aX * (7.2362614232E10 + y * (-7.895059235E9 + y * (2.423968531E8 + y * (-2972611.439 + y * (15704.4826 + y * -30.16036606)))));
            double ans2 = 1.44725228442E11 + y * (2.300535178E9 + y * (1.858330474E7 + y * (99447.43394 + y * (376.9991397 + y * 1.0))));
            return ans1 / ans2;
        }
        double z = 8.0 / ax;
        double xx = ax - 2.356194491;
        double y = z * z;
        double ans1 = 1.0 + y * (0.00183105 + y * (-3.516396496E-5 + y * (2.457520174E-6 + y * -2.40337019E-7)));
        double ans2 = 0.04687499995 + y * (-2.002690873E-4 + y * (8.449199096E-6 + y * (-8.8228987E-7 + y * 1.05787412E-7)));
        double ans = Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
        if (aX < 0.0) {
            ans = -ans;
        }
        return ans;
    }
}

