/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

import mosaic.utils.ConvertArray;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.ReshapeMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;

public class Matrix {
    private DenseMatrix64F iMatrix;

    private Matrix(DenseMatrix64F aDM) {
        this.iMatrix = aDM;
    }

    public Matrix(int aRows, int aCols) {
        this.iMatrix = new DenseMatrix64F(aRows, aCols);
    }

    public Matrix(Matrix aM) {
        this.iMatrix = new DenseMatrix64F(aM.iMatrix);
    }

    public Matrix(int aNumOfRows, int aNumOfCols, double ... aValues) {
        this.iMatrix = new DenseMatrix64F(aNumOfRows, aNumOfCols, true, aValues);
    }

    public Matrix(double[][] aArray) {
        this.iMatrix = new DenseMatrix64F(aArray);
    }

    public Matrix(float[][] aArray) {
        this.iMatrix = new DenseMatrix64F(ConvertArray.toDouble(aArray));
    }

    public Matrix(double[][] aArray, boolean aIsXYmatrix) {
        this(aArray);
        if (aIsXYmatrix) {
            this.transpose();
        }
    }

    public Matrix(float[][] aArray, boolean aIsXYmatrix) {
        this(aArray);
        if (aIsXYmatrix) {
            this.transpose();
        }
    }

    public static Matrix mkRowVector(double[][][] aInputArray) {
        int zl = aInputArray.length;
        int yl = aInputArray[0].length;
        int xl = aInputArray[0][0].length;
        Matrix result = new Matrix(1, xl * yl * zl);
        double[] array = result.getData();
        int idx = 0;
        for (int z = 0; z < zl; ++z) {
            for (int y = 0; y < yl; ++y) {
                for (int x = 0; x < xl; ++x) {
                    array[idx++] = aInputArray[z][y][x];
                }
            }
        }
        return result;
    }

    public static Matrix mkRowVector(double[][] aInputArray) {
        int yl = aInputArray.length;
        int xl = aInputArray[0].length;
        Matrix result = new Matrix(1, xl * yl);
        double[] array = result.getData();
        int idx = 0;
        for (int y = 0; y < yl; ++y) {
            for (int x = 0; x < xl; ++x) {
                array[idx++] = aInputArray[y][x];
            }
        }
        return result;
    }

    public static Matrix mkRowVector(double ... aInput) {
        DenseMatrix64F result = new DenseMatrix64F(1, aInput.length);
        result.setData(aInput);
        return new Matrix(result);
    }

    public static Matrix mkColVector(double ... aInput) {
        DenseMatrix64F result = new DenseMatrix64F(aInput.length, 1);
        result.setData(aInput);
        return new Matrix(result);
    }

    public Matrix copy() {
        return new Matrix(this);
    }

    public Matrix newSameSize() {
        return new Matrix(this.numRows(), this.numCols());
    }

    public int numRows() {
        return this.iMatrix.numRows;
    }

    public int numCols() {
        return this.iMatrix.numCols;
    }

    public int size() {
        return this.numRows() * this.numCols();
    }

    public boolean isRowVector() {
        return this.size() > 0 && this.iMatrix.numRows == 1;
    }

    public boolean isColVector() {
        return this.size() > 0 && this.iMatrix.numCols == 1;
    }

    public static double[][] getArrayYX(Matrix aMatrix) {
        int r = aMatrix.iMatrix.numRows;
        int c = aMatrix.iMatrix.numCols;
        double[][] result = new double[r][c];
        for (int ry = 0; ry < r; ++ry) {
            for (int cx = 0; cx < c; ++cx) {
                result[ry][cx] = aMatrix.get(ry, cx);
            }
        }
        return result;
    }

    public static double[][] getArrayXY(Matrix aMatrix) {
        int r = aMatrix.iMatrix.numRows;
        int c = aMatrix.iMatrix.numCols;
        double[][] result = new double[c][r];
        for (int ry = 0; ry < r; ++ry) {
            for (int cx = 0; cx < c; ++cx) {
                result[cx][ry] = aMatrix.get(ry, cx);
            }
        }
        return result;
    }

    public static float[][] getArrayYXasFloats(Matrix aMatrix) {
        int r = aMatrix.iMatrix.numRows;
        int c = aMatrix.iMatrix.numCols;
        float[][] result = new float[r][c];
        for (int ry = 0; ry < r; ++ry) {
            for (int cx = 0; cx < c; ++cx) {
                result[ry][cx] = (float)aMatrix.get(ry, cx);
            }
        }
        return result;
    }

    public static float[][] getArrayXYasFloats(Matrix aMatrix) {
        int r = aMatrix.iMatrix.numRows;
        int c = aMatrix.iMatrix.numCols;
        float[][] result = new float[c][r];
        for (int ry = 0; ry < r; ++ry) {
            for (int cx = 0; cx < c; ++cx) {
                result[cx][ry] = (float)aMatrix.get(ry, cx);
            }
        }
        return result;
    }

    public double[][] getArrayYX() {
        return Matrix.getArrayYX(this);
    }

    public double[][] getArrayXY() {
        return Matrix.getArrayXY(this);
    }

    public float[][] getArrayYXasFloats() {
        return Matrix.getArrayYXasFloats(this);
    }

    public float[][] getArrayXYasFloats() {
        return Matrix.getArrayXYasFloats(this);
    }

    public double[] getArrayColumn(int aColumn) {
        double[] column = new double[this.numRows()];
        for (int i = 0; i < this.numRows(); ++i) {
            column[i] = this.get(i, aColumn);
        }
        return column;
    }

    public double[] getArrayRow(int aRow) {
        double[] row = new double[this.numCols()];
        for (int i = 0; i < this.numCols(); ++i) {
            row[i] = this.get(aRow, i);
        }
        return row;
    }

    public Matrix getColumn(int aColumn) {
        return Matrix.mkColVector(this.getArrayColumn(aColumn));
    }

    public Matrix getRow(int aRow) {
        return Matrix.mkRowVector(this.getArrayRow(aRow));
    }

    public double[] getData() {
        return this.iMatrix.data;
    }

    public Matrix process(MFunc aMf) {
        int len = this.iMatrix.data.length;
        for (int i = 0; i < len; ++i) {
            this.iMatrix.data[i] = aMf.f(this.iMatrix.data[i], i / this.iMatrix.numCols, i % this.iMatrix.numCols);
        }
        return this;
    }

    public Matrix processNoSet(MFunc aMf) {
        int len = this.iMatrix.data.length;
        for (int i = 0; i < len; ++i) {
            aMf.f(this.iMatrix.data[i], i / this.iMatrix.numCols, i % this.iMatrix.numCols);
        }
        return this;
    }

    public Matrix elementMult(Matrix aM) {
        CommonOps.elementMult((D1Matrix64F)this.iMatrix, (D1Matrix64F)aM.iMatrix);
        return this;
    }

    public Matrix mult(Matrix aM) {
        Matrix result = new Matrix(this.numRows(), aM.numCols());
        CommonOps.mult((RowD1Matrix64F)this.iMatrix, (RowD1Matrix64F)aM.iMatrix, (RowD1Matrix64F)result.iMatrix);
        this.iMatrix = result.iMatrix;
        return this;
    }

    public Matrix elementDiv(Matrix aM) {
        CommonOps.elementDiv((D1Matrix64F)this.iMatrix, (D1Matrix64F)aM.iMatrix);
        return this;
    }

    public Matrix add(Matrix aM) {
        CommonOps.add((D1Matrix64F)this.iMatrix, (D1Matrix64F)aM.iMatrix, (D1Matrix64F)this.iMatrix);
        return this;
    }

    public Matrix add(double aVal) {
        CommonOps.add((D1Matrix64F)this.iMatrix, (double)aVal);
        return this;
    }

    public Matrix sub(Matrix aM) {
        CommonOps.sub((D1Matrix64F)this.iMatrix, (D1Matrix64F)aM.iMatrix, (D1Matrix64F)this.iMatrix);
        return this;
    }

    public Matrix sub(double aVal) {
        CommonOps.add((D1Matrix64F)this.iMatrix, (double)(-aVal));
        return this;
    }

    public Matrix scale(double aVal) {
        CommonOps.scale((double)aVal, (D1Matrix64F)this.iMatrix);
        return this;
    }

    public double get(int aRow, int aCol) {
        return this.iMatrix.get(aRow, aCol);
    }

    public Matrix set(int aRow, int aCol, double aVal) {
        this.iMatrix.set(aRow, aCol, aVal);
        return this;
    }

    public double get(int aIdx) {
        return this.iMatrix.get(aIdx % this.iMatrix.numRows, aIdx / this.iMatrix.numRows);
    }

    public Matrix set(int idx, double aVal) {
        this.iMatrix.set(idx % this.iMatrix.numRows, idx / this.iMatrix.numRows, aVal);
        return this;
    }

    public Matrix transpose() {
        CommonOps.transpose((DenseMatrix64F)this.iMatrix);
        return this;
    }

    public Matrix fill(double aVal) {
        int len = this.iMatrix.data.length;
        for (int i = 0; i < len; ++i) {
            this.iMatrix.data[i] = aVal;
        }
        return this;
    }

    public Matrix ones() {
        this.fill(1.0);
        return this;
    }

    public Matrix zeros() {
        this.fill(0.0);
        return this;
    }

    public Matrix pow2() {
        return this.pow(2);
    }

    public Matrix pow(int aPower) {
        int len = this.iMatrix.data.length;
        for (int i = 0; i < len; ++i) {
            this.iMatrix.data[i] = Math.pow(this.iMatrix.data[i], aPower);
        }
        return this;
    }

    public Matrix sqrt() {
        int len = this.iMatrix.data.length;
        for (int i = 0; i < len; ++i) {
            this.iMatrix.data[i] = Math.sqrt(this.iMatrix.data[i]);
        }
        return this;
    }

    public Matrix log() {
        int len = this.iMatrix.data.length;
        for (int i = 0; i < len; ++i) {
            this.iMatrix.data[i] = Math.log(this.iMatrix.data[i]);
        }
        return this;
    }

    public Matrix inv() {
        int len = this.iMatrix.data.length;
        for (int i = 0; i < len; ++i) {
            this.iMatrix.data[i] = 1.0 / this.iMatrix.data[i];
        }
        return this;
    }

    public Matrix negative() {
        int len = this.iMatrix.data.length;
        for (int i = 0; i < len; ++i) {
            this.iMatrix.data[i] = -this.iMatrix.data[i];
        }
        return this;
    }

    public double sum() {
        return CommonOps.elementSum((D1Matrix64F)this.iMatrix);
    }

    public Matrix normalize() {
        int i;
        int len = this.iMatrix.data.length;
        double max = 0.0;
        for (i = 0; i < len; ++i) {
            double absValue = Math.abs(this.iMatrix.data[i]);
            if (!(max < absValue)) continue;
            max = absValue;
        }
        if (max > 0.0) {
            for (i = 0; i < len; ++i) {
                this.iMatrix.data[i] = this.iMatrix.data[i] / max;
            }
        }
        return this;
    }

    public Matrix normalizeInRange0to1() {
        int i;
        int len = this.iMatrix.data.length;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (i = 0; i < len; ++i) {
            double val = this.iMatrix.data[i];
            if (max < val) {
                max = val;
            }
            if (!(min > val)) continue;
            min = val;
        }
        if (max != min) {
            for (i = 0; i < len; ++i) {
                this.iMatrix.data[i] = (this.iMatrix.data[i] - min) / (max - min);
            }
        }
        return this;
    }

    public Matrix insert(Matrix aMatrix, int aRow, int aCol) {
        CommonOps.insert((ReshapeMatrix64F)aMatrix.iMatrix, (ReshapeMatrix64F)this.iMatrix, (int)aRow, (int)aCol);
        return this;
    }

    public Matrix resize(int aStartRow, int aStartCol, int aStepRow, int aStepCol) {
        if (aStartRow == 0 && aStartCol == 0 && aStepRow <= 1 && aStepCol <= 1) {
            return this;
        }
        int cols = this.iMatrix.numCols;
        int rows = this.iMatrix.numRows;
        int newCols = (cols + 1 - aStartCol) / aStepCol;
        int newRows = (rows + 1 - aStartRow) / aStepRow;
        DenseMatrix64F result = new DenseMatrix64F(newRows, newCols);
        int r = aStartRow;
        int rn = 0;
        while (r < rows) {
            int c = aStartCol;
            int cn = 0;
            while (c < cols) {
                result.set(rn, cn, this.iMatrix.get(r, c));
                c += aStepCol;
                ++cn;
            }
            r += aStepRow;
            ++rn;
        }
        this.iMatrix = result;
        return this;
    }

    public Matrix insertRow(Matrix aRowMatrix, int aRowNum) {
        if (aRowMatrix.numCols() != this.iMatrix.numCols) {
            throw new IllegalArgumentException("Dimensions of row vector must match matrix");
        }
        CommonOps.insert((ReshapeMatrix64F)aRowMatrix.iMatrix, (ReshapeMatrix64F)this.iMatrix, (int)aRowNum, (int)0);
        return this;
    }

    public Matrix insertCol(Matrix aColMatrix, int aColNum) {
        if (aColMatrix.numRows() != this.iMatrix.numRows) {
            throw new IllegalArgumentException("Dimensions of row vector must match matrix");
        }
        CommonOps.insert((ReshapeMatrix64F)aColMatrix.iMatrix, (ReshapeMatrix64F)this.iMatrix, (int)0, (int)aColNum);
        return this;
    }

    public boolean compare(Matrix aMatrix, double aEpsilon) {
        int len = this.iMatrix.data.length;
        for (int i = 0; i < len; ++i) {
            double diff = Math.abs(this.iMatrix.data[i] - aMatrix.iMatrix.data[i]);
            if (diff != Double.NaN && !(diff > aEpsilon)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.iMatrix.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Matrix cmp = (Matrix)obj;
        if (cmp.numCols() != this.numCols() || cmp.numRows() != this.numRows()) {
            return false;
        }
        return this.compare(cmp, 0.0);
    }

    public int hashCode() {
        return this.iMatrix.hashCode();
    }

    public static interface MFunc {
        public double f(double var1, int var3, int var4);
    }
}

