/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

import java.util.Arrays;

public class Polynomial {
    private double[] iCoeffs;
    private int iDegree;

    public Polynomial(double ... aCoefficients) {
        this.setCoefficients(aCoefficients);
    }

    public Polynomial copy() {
        return new Polynomial(this.iCoeffs);
    }

    public double getValue(double aX) {
        double result = this.iCoeffs[0];
        for (int n = 1; n <= this.iDegree; ++n) {
            result = aX * result + this.iCoeffs[n];
        }
        return result;
    }

    public int getDegree() {
        return this.iDegree;
    }

    public double getCoefficient(int aDegree) {
        if (aDegree < 0 || aDegree > this.iDegree) {
            return 0.0;
        }
        return this.iCoeffs[this.iDegree - aDegree];
    }

    public double[] getCoefficients() {
        return this.iCoeffs;
    }

    public Polynomial getDerivative(int aOrder) {
        if (aOrder < 0) {
            throw new IllegalArgumentException("Order derivative < 0");
        }
        if (aOrder > this.iDegree) {
            return new Polynomial(0.0);
        }
        int noOfCoefs = this.iDegree - aOrder + 1;
        double[] newCoeffs = new double[noOfCoefs];
        for (int n = 0; n < noOfCoefs; ++n) {
            double coeff = this.iCoeffs[n];
            for (int i = 0; i < aOrder; ++i) {
                coeff *= (double)(this.iDegree - i - n);
            }
            newCoeffs[n] = coeff;
        }
        return new Polynomial(newCoeffs);
    }

    public Polynomial getIntegral(double aConstant) {
        int noOfCoefs = this.iDegree + 1 + 1;
        double[] newCoeffs = new double[noOfCoefs];
        for (int n = 0; n < noOfCoefs - 1; ++n) {
            double coeff = this.iCoeffs[n];
            newCoeffs[n] = coeff /= (double)(this.iDegree - n + 1);
        }
        newCoeffs[noOfCoefs - 1] = aConstant;
        return new Polynomial(newCoeffs);
    }

    private void setCoefficients(double[] aCoefficients) {
        int idx = 0;
        for (double c : aCoefficients) {
            if (c != 0.0) break;
            ++idx;
        }
        if (idx == aCoefficients.length) {
            --idx;
        }
        this.iCoeffs = Arrays.copyOfRange(aCoefficients, idx, aCoefficients.length);
        this.iDegree = this.iCoeffs.length - 1;
    }

    public String toString() {
        String str = "f(x) = ";
        boolean firstCoefficient = true;
        for (int n = 0; n <= this.iDegree; ++n) {
            if (!firstCoefficient || this.iCoeffs[n] < 0.0) {
                str = str + " " + (this.iCoeffs[n] >= 0.0 ? "+ " : "- ");
            }
            firstCoefficient = false;
            str = str + String.format("%g", Math.abs(this.iCoeffs[n]));
            if (this.iDegree - n == 0) continue;
            str = str + "*x^" + (this.iDegree - n);
        }
        return str;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Polynomial cmp = (Polynomial)obj;
        if (cmp.iDegree != this.iDegree) {
            return false;
        }
        return Arrays.equals(cmp.iCoeffs, this.iCoeffs);
    }

    public int hashCode() {
        return Arrays.hashCode(this.iCoeffs) + this.iDegree * 31;
    }
}

