/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

import mosaic.utils.math.Matrix;
import mosaic.utils.math.generalizedLinearModel.Glm;

public class RegionStatisticsSolver {
    private final Matrix iImage;
    private final Matrix iMask;
    private final Matrix iMu;
    private final Glm iGlm;
    private final int iNumOfIterations;
    private double iBetaMLEout = 0.0;
    private double iBetaMLEin = 0.0;
    private Matrix iModelImage;

    public RegionStatisticsSolver(Matrix aImage, Matrix aMask, Glm aGlm, Matrix aMuInit, int aNumOfIterations) {
        this.iImage = aImage;
        this.iMask = aMask;
        this.iMu = aMuInit;
        this.iGlm = aGlm;
        this.iNumOfIterations = aNumOfIterations;
    }

    public RegionStatisticsSolver calculate() {
        Matrix ones = new Matrix(this.iMask.numRows(), this.iMask.numCols()).ones();
        Matrix maskSubFrom1 = ones.sub(this.iMask);
        Matrix maskPow2 = this.iMask.copy().pow2();
        Matrix maskMul1SubMask = maskSubFrom1.copy().elementMult(this.iMask);
        Matrix pow2Of1SubMask = maskSubFrom1.copy().pow2();
        Matrix mu = this.iMu;
        Matrix Z = this.calcualteZ(mu);
        Matrix W = this.calculateW(mu);
        double tempBetaMLEout = 0.0;
        double tempBetaMLEin = 0.0;
        boolean isThatFirstIteration = true;
        for (int i = 0; i < this.iNumOfIterations; ++i) {
            double K11 = W.copy().elementMult(pow2Of1SubMask).sum();
            double K12 = W.copy().elementMult(maskMul1SubMask).sum();
            double K22 = W.copy().elementMult(maskPow2).sum();
            double U1 = W.copy().elementMult(Z).elementMult(maskSubFrom1).sum();
            double U2 = W.elementMult(Z).elementMult(this.iMask).sum();
            double detK = K11 * K22 - Math.pow(K12, 2.0);
            this.iBetaMLEout = (K22 * U1 - K12 * U2) / detK;
            this.iBetaMLEin = (-K12 * U1 + K11 * U2) / detK;
            if (!isThatFirstIteration && tempBetaMLEout == this.iBetaMLEout && tempBetaMLEin == this.iBetaMLEin) break;
            isThatFirstIteration = false;
            tempBetaMLEout = this.iBetaMLEout;
            tempBetaMLEin = this.iBetaMLEin;
            mu = this.calculateModelImage();
            Z = this.calcualteZ(mu);
            W = this.calculateW(mu);
        }
        if (this.iBetaMLEout > this.iBetaMLEin) {
            double temp = this.iBetaMLEout;
            this.iBetaMLEout = this.iBetaMLEin;
            this.iBetaMLEin = temp;
        }
        this.iModelImage = mu = this.calculateModelImage();
        return this;
    }

    public double getBetaMLEout() {
        return this.iBetaMLEout;
    }

    public double getBetaMLEin() {
        return this.iBetaMLEin;
    }

    public Matrix getModelImage() {
        return this.iModelImage;
    }

    private Matrix calculateW(Matrix mu) {
        return this.iGlm.priorWeights(this.iImage).elementDiv(this.iGlm.varFunction(mu).scale(Math.pow(this.iGlm.linkDerivative(mu), 2.0)).add(Math.ulp(1.0)));
    }

    private Matrix calcualteZ(Matrix mu) {
        return this.iImage.copy().sub(mu).scale(this.iGlm.linkDerivative(mu)).add(this.iGlm.link(mu));
    }

    private Matrix calculateModelImage() {
        Matrix linearPredictor = this.iMask.copy().scale(this.iBetaMLEin - this.iBetaMLEout).add(this.iBetaMLEout);
        return this.iGlm.linkInverse(linearPredictor);
    }
}

