/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

import edu.mines.jtk.util.ArrayMath;
import java.util.Arrays;

public class StatisticsUtils {
    public static MinMaxMean getMinMaxMean(double[] aValues) {
        if (aValues == null || aValues.length == 0) {
            return null;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double mean = 0.0;
        for (double value : aValues) {
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            mean += value;
        }
        return new MinMaxMean(min, max, mean /= (double)aValues.length);
    }

    public static double[] calculateCdfFromPmf(double[] aPmf, boolean aNormalize) {
        double[] cdf = new double[aPmf.length];
        double sum = 0.0;
        for (int i = 0; i < aPmf.length; ++i) {
            cdf[i] = sum += aPmf[i];
        }
        if (aNormalize) {
            StatisticsUtils.normalizeDiscreteCdf(cdf, false);
        }
        return cdf;
    }

    public static double[] normalizeDiscreteCdf(double[] aCdf, boolean aGenerateNewContainer) {
        double[] result = aGenerateNewContainer ? new double[aCdf.length] : aCdf;
        double maximumValue = aCdf[aCdf.length - 1];
        for (int i = 0; i < aCdf.length; ++i) {
            result[i] = aCdf[i] / maximumValue;
        }
        return result;
    }

    public static double[] normalizePmf(double[] aPmf, boolean aGenerateNewContainer) {
        double[] result = aGenerateNewContainer ? new double[aPmf.length] : aPmf;
        double sum = 0.0;
        for (double value : aPmf) {
            sum += value;
        }
        for (int i = 0; i < aPmf.length; ++i) {
            result[i] = aPmf[i] / sum;
        }
        return result;
    }

    private static double linearInterpolation(double aXmin, double aXmax, double aYmin, double aYmax, double aXpoint) {
        double a = (aYmin - aYmax) / (aXmin - aXmax);
        double b = aYmin - a * aXmin;
        return a * aXpoint + b;
    }

    public static double calculateCdfAtPoint(double aX, double[] aPdf, double[] aGridValues) {
        double sum = 0.0;
        if (aX > aGridValues[0]) {
            for (int i = 0; i < aGridValues.length - 1; ++i) {
                if (aX < aGridValues[i + 1]) {
                    double pdfAtX = StatisticsUtils.linearInterpolation(aGridValues[i], aGridValues[i + 1], aPdf[i], aPdf[i + 1], aX);
                    sum += (aPdf[i] + pdfAtX) / 2.0 * (aX - aGridValues[i]);
                    break;
                }
                sum += (aPdf[i] + aPdf[i + 1]) / 2.0 * (aGridValues[i + 1] - aGridValues[i]);
            }
        }
        return sum;
    }

    public static double[] normalizePdf(double[] aPdf, double[] aGridValues, boolean aGenerateNewContainer) {
        double[] result = aGenerateNewContainer ? new double[aPdf.length] : aPdf;
        double sum = StatisticsUtils.calculateCdfAtPoint(aGridValues[aGridValues.length - 1], aPdf, aGridValues);
        for (int i = 0; i < result.length; ++i) {
            result[i] = aPdf[i] / sum;
        }
        return result;
    }

    public static double[] calculateCdfFromPdf(double[] aPdf, double[] grid) {
        int i;
        double[] cdf = new double[aPdf.length];
        cdf[0] = 0.0;
        for (i = 0; i < aPdf.length - 1; ++i) {
            cdf[i + 1] = (aPdf[i] + aPdf[i + 1]) / 2.0 * (grid[i + 1] - grid[i]) + cdf[i];
        }
        i = 0;
        while (i < cdf.length) {
            int n = i++;
            cdf[n] = cdf[n] / cdf[cdf.length - 1];
        }
        return cdf;
    }

    public static double calcSampleVariance(double[] aValues) {
        double mean = StatisticsUtils.getMinMaxMean((double[])aValues).mean;
        double sum = 0.0;
        for (double a : aValues) {
            sum += Math.pow(mean - a, 2.0);
        }
        return sum / (double)(aValues.length - 1);
    }

    public static double calcStandardDev(double[] aValues) {
        return Math.sqrt(StatisticsUtils.calcSampleVariance(aValues));
    }

    public static final double getPercentile(double[] aValues, double aPercentile) {
        int size = aValues.length;
        if (aPercentile > 1.0 || aPercentile < 0.0) {
            throw new IllegalArgumentException("Invalid quantile value: " + aPercentile);
        }
        if (size == 0) {
            return Double.NaN;
        }
        if (size == 1) {
            return aValues[0];
        }
        double realPos = aPercentile * (double)(size - 1);
        int intPos = (int)realPos;
        double[] sorted = (double[])aValues.clone();
        Arrays.sort(sorted);
        if (intPos == size - 1) {
            return sorted[size - 1];
        }
        double diff = realPos - (double)intPos;
        double lower = sorted[intPos];
        double upper = sorted[intPos + 1];
        return lower + diff * (upper - lower);
    }

    public static double samplePearsonCorrelationCoefficient(double[] aX, double[] aY) {
        double xMean = ArrayMath.sum((double[])aX) / (double)aX.length;
        double yMean = ArrayMath.sum((double[])aY) / (double)aY.length;
        double numerator = 0.0;
        double denA = 0.0;
        double denB = 0.0;
        for (int j = 0; j < aX.length; ++j) {
            numerator += (aX[j] - xMean) * (aY[j] - yMean);
            denA += Math.pow(aX[j] - xMean, 2.0);
            denB += Math.pow(aY[j] - yMean, 2.0);
        }
        return numerator / Math.sqrt(denA * denB);
    }

    public static class MinMaxMean {
        public double min;
        public double max;
        public double mean;

        public MinMaxMean(double aMin, double aMax, double aMean) {
            this.min = aMin;
            this.max = aMax;
            this.mean = aMean;
        }
    }
}

