/*
 * Decompiled with CFR 0.152.
 */
package mosaic.variationalCurvatureFilters;

import mosaic.variationalCurvatureFilters.CurvatureFilter3D;
import mosaic.variationalCurvatureFilters.FilterKernel3D;

public class NoSplitFilter3D
implements CurvatureFilter3D {
    private final FilterKernel3D iFk3D;

    public NoSplitFilter3D(FilterKernel3D aFilterKernel) {
        this.iFk3D = aFilterKernel;
    }

    @Override
    public void runFilter(float[][][] aImg, int aNumOfIterations) {
        int Z = aImg.length - 1;
        int Y = aImg[0].length - 1;
        int X = aImg[0][0].length - 1;
        int[] sequence = new int[]{273, 545, 530, 290, 289, 529, 274, 546};
        for (int it = 0; it < aNumOfIterations; ++it) {
            for (int seq = 0; seq <= 7; ++seq) {
                int seqCode = sequence[seq];
                int dep = seqCode & 0xF;
                int row = (seqCode & 0xF0) >> 4;
                int col = (seqCode & 0xF00) >> 8;
                for (int z = dep; z < Z; z += 2) {
                    for (int y = row; y < Y; y += 2) {
                        for (int x = col; x < X; x += 2) {
                            float[] fArray = aImg[z][y];
                            int n = x;
                            fArray[n] = fArray[n] + this.iFk3D.filterKernel(aImg, x, y, z);
                        }
                    }
                }
            }
        }
    }
}

