/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodUnsafe;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class Downsample {
    public static <T extends RealType<T>> void downsample(RandomAccessible<T> input, RandomAccessibleInterval<T> output, int[] factor) {
        assert (input.numDimensions() == output.numDimensions());
        assert (input.numDimensions() == factor.length);
        int n = input.numDimensions();
        RectangleNeighborhoodFactory f = RectangleNeighborhoodUnsafe.factory();
        long[] dim = new long[n];
        for (int d = 0; d < n; ++d) {
            dim[d] = factor[d];
        }
        FinalInterval spanInterval = new FinalInterval(dim);
        long[] minRequiredInput = new long[n];
        long[] maxRequiredInput = new long[n];
        output.min(minRequiredInput);
        output.max(maxRequiredInput);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            minRequiredInput[n2] = minRequiredInput[n2] * (long)factor[d];
            int n3 = d;
            maxRequiredInput[n3] = maxRequiredInput[n3] * (long)factor[d];
            int n4 = d;
            maxRequiredInput[n4] = maxRequiredInput[n4] + (long)(factor[d] - 1);
        }
        IntervalView requiredInput = Views.interval(input, (Interval)new FinalInterval(minRequiredInput, maxRequiredInput));
        RectangleShape.NeighborhoodsAccessible neighborhoods = new RectangleShape.NeighborhoodsAccessible((RandomAccessible)requiredInput, (Interval)spanInterval, f);
        RandomAccess block = neighborhoods.randomAccess();
        long size = 1L;
        for (int d = 0; d < n; ++d) {
            size *= (long)factor[d];
        }
        double scale = 1.0 / (double)size;
        Cursor out = Views.iterable(output).localizingCursor();
        while (out.hasNext()) {
            RealType o = (RealType)out.next();
            for (int d = 0; d < n; ++d) {
                block.setPosition(out.getLongPosition(d) * (long)factor[d], d);
            }
            double sum = 0.0;
            for (RealType i : (Neighborhood)block.get()) {
                sum += i.getRealDouble();
            }
            o.setReal(sum * scale);
        }
    }
}

