/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.CopyBlock;
import bdv.export.DownsampleBlock;
import bdv.export.ExportMipmapInfo;
import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterNull;
import bdv.export.SubTaskProgressWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.SingleCellArrayImg;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class ExportScalePyramid {
    public static <T extends RealType<T> & NativeType<T>, D> void writeScalePyramid(RandomAccessibleInterval<T> img, T type, ExportMipmapInfo mipmapInfo, DatasetIO<D, T> io, ExecutorService executorService, int numThreads, LoopbackHeuristic loopbackHeuristic, AfterEachPlane afterEachPlane, ProgressWriter progressWriter) throws IOException {
        BlockCreator<NativeType<T>> blockCreator = BlockCreator.forType(type);
        if (progressWriter == null) {
            progressWriter = new ProgressWriterNull();
        }
        int numTasks = mipmapInfo.getNumLevels();
        int numCompletedTasks = 0;
        progressWriter.setProgress(0.0);
        int n = 3;
        long[] dimensions = new long[3];
        int[][] resolutions = mipmapInfo.getExportResolutions();
        int[][] subdivisions = mipmapInfo.getSubdivisions();
        int numLevels = mipmapInfo.getNumLevels();
        for (int level = 0; level < numLevels; ++level) {
            boolean fullResolution;
            int[] factor;
            RandomAccessibleInterval<T> sourceImg;
            progressWriter.out().println("writing level " + level);
            boolean useLoopBack = false;
            int[] factorsToPreviousLevel = null;
            RandomAccessibleInterval<T> loopbackImg = null;
            if (loopbackHeuristic != null) {
                int previousLevel = -1;
                block3: for (int l = level - 1; l >= 0; --l) {
                    int[] f = new int[3];
                    for (int d = 0; d < 3; ++d) {
                        f[d] = resolutions[level][d] / resolutions[l][d];
                        if (f[d] * resolutions[l][d] != resolutions[level][d]) continue block3;
                    }
                    factorsToPreviousLevel = f;
                    previousLevel = l;
                    break;
                }
                if (previousLevel >= 0) {
                    useLoopBack = loopbackHeuristic.decide(img, resolutions[level], previousLevel, factorsToPreviousLevel, subdivisions[level]);
                }
                if (useLoopBack) {
                    loopbackImg = io.getImage(previousLevel);
                }
                if (loopbackImg == null) {
                    useLoopBack = false;
                }
            }
            if (useLoopBack) {
                sourceImg = loopbackImg;
                factor = factorsToPreviousLevel;
            } else {
                sourceImg = img;
                factor = resolutions[level];
            }
            sourceImg.dimensions(dimensions);
            long size = Intervals.numElements((int[])factor);
            boolean bl = fullResolution = size == 1L;
            if (!fullResolution) {
                for (int d = 0; d < 3; ++d) {
                    dimensions[d] = Math.max(dimensions[d] / (long)factor[d], 1L);
                }
            }
            long[] minRequiredInput = new long[3];
            long[] maxRequiredInput = new long[3];
            sourceImg.min(minRequiredInput);
            for (int d = 0; d < 3; ++d) {
                maxRequiredInput[d] = minRequiredInput[d] + dimensions[d] * (long)factor[d] - 1L;
            }
            IntervalView extendedImg = Views.interval((RandomAccessible)Views.extendBorder(sourceImg), (Interval)new FinalInterval(minRequiredInput, maxRequiredInput));
            int[] cellDimensions = subdivisions[level];
            D dataset = io.createDataset(level, dimensions, cellDimensions);
            SubTaskProgressWriter subProgressWriter = new SubTaskProgressWriter(progressWriter, (double)numCompletedTasks / (double)numTasks, (double)(numCompletedTasks + 1) / (double)numTasks);
            CellGrid grid = new CellGrid(dimensions, cellDimensions);
            long[] numCells = grid.getGridDimensions();
            long numBlocksPerPlane = ExportScalePyramid.numElements(numCells, 0, 2);
            long numPlanes = ExportScalePyramid.numElements(numCells, 2, 3);
            int plane = 0;
            while ((long)plane < numPlanes) {
                long planeBaseIndex = numBlocksPerPlane * (long)plane;
                AtomicInteger nextCellInPlane = new AtomicInteger();
                ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
                for (int threadNum = 0; threadNum < numThreads; ++threadNum) {
                    tasks.add(() -> ExportScalePyramid.lambda$writeScalePyramid$0((RandomAccessibleInterval)extendedImg, type, fullResolution, cellDimensions, factor, nextCellInPlane, numBlocksPerPlane, planeBaseIndex, grid, blockCreator, io, dataset));
                }
                try {
                    List futures = executorService.invokeAll(tasks);
                    for (Future future : futures) {
                        future.get();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                    throw new IOException(e);
                }
                if (afterEachPlane != null) {
                    afterEachPlane.afterEachPlane(useLoopBack);
                }
                subProgressWriter.setProgress((double)plane / (double)numPlanes);
                ++plane;
            }
            io.flush(dataset);
            progressWriter.setProgress((double)(++numCompletedTasks) / (double)numTasks);
        }
    }

    private static long numElements(long[] size, int mind, int maxd) {
        long numElements = 1L;
        for (int d = mind; d < maxd; ++d) {
            numElements *= size[d];
        }
        return numElements;
    }

    private static /* synthetic */ Void lambda$writeScalePyramid$0(RandomAccessibleInterval extendedImg, RealType type, boolean fullResolution, int[] cellDimensions, int[] factor, AtomicInteger nextCellInPlane, long numBlocksPerPlane, long planeBaseIndex, CellGrid grid, BlockCreator blockCreator, DatasetIO io, Object dataset) throws Exception {
        long[] currentCellMin = new long[3];
        int[] currentCellDim = new int[3];
        long[] currentCellPos = new long[3];
        long[] blockMin = new long[3];
        RandomAccess in = extendedImg.randomAccess();
        Class<?> kl1 = type.getClass();
        Class<?> kl2 = in.getClass();
        CopyBlock copyBlock = fullResolution ? CopyBlock.create(3, kl1, kl2) : null;
        DownsampleBlock downsampleBlock = fullResolution ? null : DownsampleBlock.create(cellDimensions, factor, kl1, kl2);
        int i = nextCellInPlane.getAndIncrement();
        while ((long)i < numBlocksPerPlane) {
            long index = planeBaseIndex + (long)i;
            grid.getCellDimensions(index, currentCellMin, currentCellDim);
            grid.getCellGridPositionFlat(index, currentCellPos);
            Block block = blockCreator.create(currentCellDim, currentCellMin, currentCellPos);
            if (fullResolution) {
                RandomAccess out = block.getData().randomAccess();
                in.setPosition(currentCellMin);
                out.setPosition(currentCellMin);
                copyBlock.copyBlock(in, out, currentCellDim);
            } else {
                for (int d = 0; d < 3; ++d) {
                    blockMin[d] = currentCellMin[d] * (long)factor[d];
                }
                in.setPosition(blockMin);
                downsampleBlock.downsampleBlock(in, block.getData().cursor(), currentCellDim);
            }
            io.writeBlock(dataset, block);
            i = nextCellInPlane.getAndIncrement();
        }
        return null;
    }

    private static interface BlockCreator<T extends NativeType<T>> {
        public Block<T> create(int[] var1, long[] var2, long[] var3);

        public static <T extends NativeType<T> & RealType<T>, A extends ArrayDataAccess<A>> BlockCreator<T> forType(T type) {
            ArrayDataAccess accessFactory = (ArrayDataAccess)Cast.unchecked((Object)ArrayDataAccessFactory.get(type));
            NativeTypeFactory nativeTypeFactory = (NativeTypeFactory)Cast.unchecked((Object)type.getNativeTypeFactory());
            return (blockSize, blockMin, gridPosition) -> {
                ArrayDataAccess data = (ArrayDataAccess)accessFactory.createArray((int)Intervals.numElements((int[])blockSize));
                SingleCellArrayImg img = new SingleCellArrayImg(blockSize, blockMin, data, null);
                img.setLinkedType(nativeTypeFactory.createLinkedType((NativeImg)img));
                return new Block(img, blockSize, gridPosition);
            };
        }
    }

    public static interface DatasetIO<D, T extends NativeType<T>> {
        public D createDataset(int var1, long[] var2, int[] var3) throws IOException;

        public void writeBlock(D var1, Block<T> var2) throws IOException;

        public void flush(D var1) throws IOException;

        default public RandomAccessibleInterval<T> getImage(int level) throws IOException {
            return null;
        }
    }

    public static class Block<T extends NativeType<T>> {
        final SingleCellArrayImg<T, ?> data;
        final int[] size;
        final long[] position;

        Block(SingleCellArrayImg<T, ?> data, int[] size, long[] position) {
            this.data = data;
            this.size = size;
            this.position = position;
        }

        public SingleCellArrayImg<T, ?> getData() {
            return this.data;
        }

        public int[] getSize() {
            return this.size;
        }

        public long[] getGridPosition() {
            return this.position;
        }
    }

    public static interface AfterEachPlane {
        public void afterEachPlane(boolean var1);
    }

    public static class DefaultLoopbackHeuristic
    implements LoopbackHeuristic {
        @Override
        public boolean decide(RandomAccessibleInterval<?> originalImg, int[] factorsToOriginalImg, int previousLevel, int[] factorsToPreviousLevel, int[] chunkSize) {
            if (previousLevel < 0) {
                return false;
            }
            return Intervals.numElements((int[])factorsToOriginalImg) / Intervals.numElements((int[])factorsToPreviousLevel) >= 8L;
        }
    }

    public static interface LoopbackHeuristic {
        public boolean decide(RandomAccessibleInterval<?> var1, int[] var2, int var3, int[] var4, int[] var5);
    }
}

