/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.ExportMipmapInfo;
import bdv.export.IHDF5Access;
import bdv.img.hdf5.Util;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;

class HDF5Access
implements IHDF5Access {
    private final IHDF5Writer hdf5Writer;
    private final long[] reorderedDimensions = new long[3];
    private final long[] reorderedOffset = new long[3];
    private String datasetPath;

    public HDF5Access(IHDF5Writer hdf5Writer) {
        this.hdf5Writer = hdf5Writer;
    }

    @Override
    public void writeMipmapDescription(int setupIdPartition, ExportMipmapInfo mipmapInfo) {
        this.hdf5Writer.writeDoubleMatrix(Util.getResolutionsPath(setupIdPartition), mipmapInfo.getResolutions());
        this.hdf5Writer.writeIntMatrix(Util.getSubdivisionsPath(setupIdPartition), mipmapInfo.getSubdivisions());
    }

    @Override
    public void createAndOpenDataset(String path, long[] dimensions, int[] cellDimensions, HDF5IntStorageFeatures features) {
        this.hdf5Writer.int16().createMDArray(path, Util.reorder(dimensions), Util.reorder(cellDimensions), features);
        this.datasetPath = path;
    }

    @Override
    public void writeBlockWithOffset(short[] data, long[] blockDimensions, long[] offset) {
        Util.reorder(blockDimensions, this.reorderedDimensions);
        Util.reorder(offset, this.reorderedOffset);
        MDShortArray array = new MDShortArray(data, this.reorderedDimensions);
        this.hdf5Writer.int16().writeMDArrayBlockWithOffset(this.datasetPath, array, this.reorderedOffset);
    }

    @Override
    public void closeDataset() {
    }

    @Override
    public void close() {
        this.hdf5Writer.close();
    }

    @Override
    public IHDF5Writer getIHDF5Writer() {
        return this.hdf5Writer;
    }
}

