/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.ExportMipmapInfo;
import bdv.export.HDF5Access;
import bdv.export.HDF5AccessHack;
import bdv.export.IHDF5Access;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

class Hdf5BlockWriterThread
extends Thread
implements IHDF5Access {
    private final IHDF5Access hdf5Access;
    private final BlockingQueue<Hdf5Task> queue;
    private volatile boolean shutdown;
    private final Object emptyMonitor = new Object();

    public Hdf5BlockWriterThread(IHDF5Access hdf5Access, int queueLength) {
        this.hdf5Access = hdf5Access;
        this.queue = new ArrayBlockingQueue<Hdf5Task>(queueLength);
        this.shutdown = false;
        this.setName("HDF5BlockWriterQueue");
    }

    public Hdf5BlockWriterThread(File hdf5File, int queueLength) {
        IHDF5Access hdf5Access;
        IHDF5Writer hdf5Writer = HDF5Factory.open((File)hdf5File);
        try {
            hdf5Access = new HDF5AccessHack(hdf5Writer);
        }
        catch (Exception e) {
            e.printStackTrace();
            hdf5Access = new HDF5Access(hdf5Writer);
        }
        this.hdf5Access = hdf5Access;
        this.queue = new ArrayBlockingQueue<Hdf5Task>(queueLength);
        this.shutdown = false;
        this.setName("HDF5BlockWriterQueue");
    }

    public Hdf5BlockWriterThread(String hdf5FilePath, int queueLength) {
        this(new File(hdf5FilePath), queueLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown || !this.queue.isEmpty()) {
            try {
                Hdf5Task task = this.queue.poll(10L, TimeUnit.MILLISECONDS);
                if (task != null) {
                    task.run(this.hdf5Access);
                }
                if (!this.queue.isEmpty()) continue;
                Object object = this.emptyMonitor;
                synchronized (object) {
                    this.emptyMonitor.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmpty() {
        Object object = this.emptyMonitor;
        synchronized (object) {
            while (!this.queue.isEmpty()) {
                try {
                    this.emptyMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public void close() {
        this.shutdown = true;
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.hdf5Access.close();
    }

    @Override
    public IHDF5Writer getIHDF5Writer() {
        return this.hdf5Access.getIHDF5Writer();
    }

    @Override
    public void writeMipmapDescription(int setupIdPartition, ExportMipmapInfo mipmapInfo) {
        this.put(new WriteMipmapDescriptionTask(setupIdPartition, mipmapInfo));
    }

    @Override
    public void createAndOpenDataset(String path, long[] dimensions, int[] cellDimensions, HDF5IntStorageFeatures features) {
        this.put(new CreateAndOpenDatasetTask(path, dimensions, cellDimensions, features));
    }

    @Override
    public void writeBlockWithOffset(short[] data, long[] blockDimensions, long[] offset) {
        this.put(new WriteBlockWithOffsetTask(data, blockDimensions, offset));
    }

    @Override
    public void closeDataset() {
        this.put(new CloseDatasetTask());
        this.waitUntilEmpty();
    }

    private boolean put(Hdf5Task task) {
        try {
            this.queue.put(task);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private static class CloseDatasetTask
    implements Hdf5Task {
        private CloseDatasetTask() {
        }

        @Override
        public void run(IHDF5Access hdf5Access) {
            hdf5Access.closeDataset();
        }
    }

    private static class WriteBlockWithOffsetTask
    implements Hdf5Task {
        private final short[] data;
        private final long[] blockDimensions;
        private final long[] offset;

        public WriteBlockWithOffsetTask(short[] data, long[] blockDimensions, long[] offset) {
            this.data = data;
            this.blockDimensions = blockDimensions;
            this.offset = offset;
        }

        @Override
        public void run(IHDF5Access hdf5Access) {
            hdf5Access.writeBlockWithOffset(this.data, this.blockDimensions, this.offset);
        }
    }

    private static class CreateAndOpenDatasetTask
    implements Hdf5Task {
        private final String path;
        private final long[] dimensions;
        private final int[] cellDimensions;
        private final HDF5IntStorageFeatures features;

        public CreateAndOpenDatasetTask(String path, long[] dimensions, int[] cellDimensions, HDF5IntStorageFeatures features) {
            this.path = path;
            this.dimensions = dimensions;
            this.cellDimensions = cellDimensions;
            this.features = features;
        }

        @Override
        public void run(IHDF5Access hdf5Access) {
            hdf5Access.createAndOpenDataset(this.path, this.dimensions, this.cellDimensions, this.features);
        }
    }

    private static class WriteMipmapDescriptionTask
    implements Hdf5Task {
        private final int setupIdPartition;
        private final ExportMipmapInfo mipmapInfo;

        public WriteMipmapDescriptionTask(int setupIdPartition, ExportMipmapInfo mipmapInfo) {
            this.setupIdPartition = setupIdPartition;
            this.mipmapInfo = mipmapInfo;
        }

        @Override
        public void run(IHDF5Access hdf5Access) {
            hdf5Access.writeMipmapDescription(this.setupIdPartition, this.mipmapInfo);
        }
    }

    private static interface Hdf5Task {
        public void run(IHDF5Access var1);
    }
}

