/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.ExportMipmapInfo;
import bdv.export.ExportScalePyramid;
import bdv.export.Hdf5BlockWriterThread;
import bdv.export.IHDF5Access;
import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterConsole;
import bdv.export.SubTaskProgressWriter;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.img.hdf5.Util;
import bdv.spimdata.SequenceDescriptionMinimal;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.SingleCellArrayImg;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;

public class WriteSequenceToHdf5 {
    public static void writeHdf5File(AbstractSequenceDescription<?, ?, ?> seq, Map<Integer, ExportMipmapInfo> perSetupMipmapInfo, boolean deflate, File hdf5File, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, int numCellCreatorThreads, ProgressWriter progressWriter) {
        HashMap<Integer, Integer> timepointIdSequenceToPartition = new HashMap<Integer, Integer>();
        for (Object timepoint : seq.getTimePoints().getTimePointsOrdered()) {
            timepointIdSequenceToPartition.put(timepoint.getId(), timepoint.getId());
        }
        HashMap<Integer, Integer> setupIdSequenceToPartition = new HashMap<Integer, Integer>();
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            setupIdSequenceToPartition.put(setup.getId(), setup.getId());
        }
        Partition partition = new Partition(hdf5File.getPath(), timepointIdSequenceToPartition, setupIdSequenceToPartition);
        WriteSequenceToHdf5.writeHdf5PartitionFile(seq, perSetupMipmapInfo, deflate, partition, loopbackHeuristic, afterEachPlane, numCellCreatorThreads, progressWriter);
    }

    public static void writeHdf5File(AbstractSequenceDescription<?, ?, ?> seq, int[][] resolutions, int[][] subdivisions, boolean deflate, File hdf5File, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, int numCellCreatorThreads, ProgressWriter progressWriter) {
        HashMap<Integer, ExportMipmapInfo> perSetupMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        ExportMipmapInfo mipmapInfo = new ExportMipmapInfo(resolutions, subdivisions);
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            perSetupMipmapInfo.put(setup.getId(), mipmapInfo);
        }
        WriteSequenceToHdf5.writeHdf5File(seq, perSetupMipmapInfo, deflate, hdf5File, loopbackHeuristic, afterEachPlane, numCellCreatorThreads, progressWriter);
    }

    public static void writeHdf5PartitionLinkFile(AbstractSequenceDescription<?, ?, ?> seq, Map<Integer, ExportMipmapInfo> perSetupMipmapInfo) {
        if (!(seq.getImgLoader() instanceof Hdf5ImageLoader)) {
            throw new IllegalArgumentException("sequence has " + seq.getImgLoader().getClass() + " imgloader. Hdf5ImageLoader required.");
        }
        Hdf5ImageLoader loader = (Hdf5ImageLoader)seq.getImgLoader();
        WriteSequenceToHdf5.writeHdf5PartitionLinkFile(seq, perSetupMipmapInfo, loader.getPartitions(), loader.getHdf5File());
    }

    public static void writeHdf5PartitionLinkFile(AbstractSequenceDescription<?, ?, ?> seq, Map<Integer, ExportMipmapInfo> perSetupMipmapInfo, ArrayList<Partition> partitions, File hdf5File) {
        if (hdf5File.exists()) {
            hdf5File.delete();
        }
        IHDF5Writer hdf5Writer = HDF5Factory.open((File)hdf5File);
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            int setupId = setup.getId();
            ExportMipmapInfo mipmapInfo = perSetupMipmapInfo.get(setupId);
            hdf5Writer.writeDoubleMatrix(Util.getResolutionsPath(setupId), mipmapInfo.getResolutions());
            hdf5Writer.writeIntMatrix(Util.getSubdivisionsPath(setupId), mipmapInfo.getSubdivisions());
        }
        File basePath = hdf5File.getParentFile();
        for (Partition partition : partitions) {
            Map<Integer, Integer> timepointIdSequenceToPartition = partition.getTimepointIdSequenceToPartition();
            Map<Integer, Integer> setupIdSequenceToPartition = partition.getSetupIdSequenceToPartition();
            for (Map.Entry<Integer, Integer> tEntry : timepointIdSequenceToPartition.entrySet()) {
                int tSequence = tEntry.getKey();
                int tPartition = tEntry.getValue();
                for (Map.Entry<Integer, Integer> sEntry : setupIdSequenceToPartition.entrySet()) {
                    int sSequence = sEntry.getKey();
                    int sPartition = sEntry.getValue();
                    ViewId idSequence = new ViewId(tSequence, sSequence);
                    ViewId idPartition = new ViewId(tPartition, sPartition);
                    int numLevels = perSetupMipmapInfo.get(sSequence).getNumLevels();
                    for (int level = 0; level < numLevels; ++level) {
                        String relativePath = XmlHelpers.getRelativePath((File)new File(partition.getPath()), (File)basePath).getPath();
                        hdf5Writer.object().createOrUpdateExternalLink(relativePath, Util.getCellsPath(idPartition, level), Util.getCellsPath(idSequence, level));
                    }
                }
            }
        }
        hdf5Writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHdf5PartitionFile(AbstractSequenceDescription<?, ?, ?> seq, Map<Integer, ExportMipmapInfo> perSetupMipmapInfo, boolean deflate, Partition partition, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, int numCellCreatorThreads, ProgressWriter progressWriter) {
        int blockWriterQueueLength = 100;
        if (progressWriter == null) {
            progressWriter = new ProgressWriterConsole();
        }
        progressWriter.setProgress(0.0);
        ArrayList<Integer> timepointIdsSequence = new ArrayList<Integer>(partition.getTimepointIdSequenceToPartition().keySet());
        Collections.sort(timepointIdsSequence);
        int numTimepoints = timepointIdsSequence.size();
        ArrayList<Integer> setupIdsSequence = new ArrayList<Integer>(partition.getSetupIdSequenceToPartition().keySet());
        Collections.sort(setupIdsSequence);
        BasicImgLoader imgLoader = seq.getImgLoader();
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            Object type = imgLoader.getSetupImgLoader(setup.getId()).getImageType();
            if (type instanceof UnsignedShortType) continue;
            throw new IllegalArgumentException("Expected BasicImgLoader<UnsignedShortTyp> but your dataset has BasicImgLoader<" + type.getClass().getSimpleName() + ">.\nCurrently writing to HDF5 is only supported for UnsignedShortType.");
        }
        File hdf5File = new File(partition.getPath());
        if (hdf5File.exists()) {
            hdf5File.delete();
        }
        try (Hdf5BlockWriterThread writerQueue = new Hdf5BlockWriterThread(hdf5File, 100);){
            writerQueue.start();
            ExecutorService executorService = Executors.newFixedThreadPool(numCellCreatorThreads);
            try {
                int numTasks = 0;
                for (int timepointIdSequence : timepointIdsSequence) {
                    for (int setupIdSequence : setupIdsSequence) {
                        if (!((BasicViewDescription)seq.getViewDescriptions().get(new ViewId(timepointIdSequence, setupIdSequence))).isPresent()) continue;
                        ++numTasks;
                    }
                }
                int numCompletedTasks = 0;
                for (Map.Entry<Integer, Integer> entry : partition.getSetupIdSequenceToPartition().entrySet()) {
                    int setupIdSequence;
                    setupIdSequence = entry.getKey();
                    int setupIdPartition = entry.getValue();
                    ExportMipmapInfo mipmapInfo = perSetupMipmapInfo.get(setupIdSequence);
                    writerQueue.writeMipmapDescription(setupIdPartition, mipmapInfo);
                }
                progressWriter.setProgress(0.01);
                progressWriter = new SubTaskProgressWriter(progressWriter, 0.01, 1.0);
                int timepointIndex = 0;
                for (int timepointIdSequence : timepointIdsSequence) {
                    int timepointIdPartition = partition.getTimepointIdSequenceToPartition().get(timepointIdSequence);
                    progressWriter.out().printf("proccessing timepoint %d / %d\n", ++timepointIndex, numTimepoints);
                    ArrayList<Integer> setupsTimePoint = new ArrayList<Integer>();
                    for (int setupIdSequence : setupIdsSequence) {
                        if (!((BasicViewDescription)seq.getViewDescriptions().get(new ViewId(timepointIdSequence, setupIdSequence))).isPresent()) continue;
                        setupsTimePoint.add(setupIdSequence);
                    }
                    int numSetups = setupsTimePoint.size();
                    int setupIndex = 0;
                    Iterator iterator = setupsTimePoint.iterator();
                    while (iterator.hasNext()) {
                        int setupIdSequence = (Integer)iterator.next();
                        int setupIdPartition = partition.getSetupIdSequenceToPartition().get(setupIdSequence);
                        progressWriter.out().printf("proccessing setup %d / %d\n", ++setupIndex, numSetups);
                        RandomAccessibleInterval img = imgLoader.getSetupImgLoader(setupIdSequence).getImage(timepointIdSequence, new ImgLoaderHint[0]);
                        ExportMipmapInfo mipmapInfo = perSetupMipmapInfo.get(setupIdSequence);
                        double startCompletionRatio = (double)numCompletedTasks++ / (double)numTasks;
                        double endCompletionRatio = (double)numCompletedTasks / (double)numTasks;
                        SubTaskProgressWriter subProgressWriter = new SubTaskProgressWriter(progressWriter, startCompletionRatio, endCompletionRatio);
                        WriteSequenceToHdf5.writeViewToHdf5PartitionFile((RandomAccessibleInterval<UnsignedShortType>)img, timepointIdPartition, setupIdPartition, mipmapInfo, false, deflate, writerQueue, executorService, numCellCreatorThreads, loopbackHeuristic, afterEachPlane, subProgressWriter);
                    }
                }
            }
            finally {
                executorService.shutdown();
            }
        }
        progressWriter.setProgress(1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeViewToHdf5PartitionFile(RandomAccessibleInterval<UnsignedShortType> img, Partition partition, int timepointIdPartition, int setupIdPartition, ExportMipmapInfo mipmapInfo, boolean writeMipmapInfo, boolean deflate, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, int numCellCreatorThreads, ProgressWriter progressWriter) {
        int blockWriterQueueLength = 100;
        try (Hdf5BlockWriterThread writerQueue = new Hdf5BlockWriterThread(partition.getPath(), 100);){
            writerQueue.start();
            ExecutorService executorService = Executors.newFixedThreadPool(numCellCreatorThreads);
            try {
                WriteSequenceToHdf5.writeViewToHdf5PartitionFile(img, timepointIdPartition, setupIdPartition, mipmapInfo, writeMipmapInfo, deflate, writerQueue, executorService, numCellCreatorThreads, loopbackHeuristic, afterEachPlane, progressWriter);
            }
            finally {
                executorService.shutdown();
            }
        }
    }

    public static void writeViewToHdf5PartitionFile(RandomAccessibleInterval<UnsignedShortType> img, int timepointIdPartition, int setupIdPartition, ExportMipmapInfo mipmapInfo, boolean writeMipmapInfo, boolean deflate, IHDF5Access writerQueue, ExecutorService executorService, int numThreads, ExportScalePyramid.LoopbackHeuristic loopbackHeuristic, ExportScalePyramid.AfterEachPlane afterEachPlane, ProgressWriter progressWriter) {
        if (writeMipmapInfo) {
            writerQueue.writeMipmapDescription(setupIdPartition, mipmapInfo);
        }
        LoopBackImageLoader loopback = loopbackHeuristic == null ? null : LoopBackImageLoader.create((IHDF5Reader)writerQueue.getIHDF5Writer(), timepointIdPartition, setupIdPartition, img);
        HDF5DatasetIO io = new HDF5DatasetIO(writerQueue, new ViewId(timepointIdPartition, setupIdPartition), deflate ? HDF5IntStorageFeatures.INT_AUTO_SCALING_DEFLATE : HDF5IntStorageFeatures.INT_AUTO_SCALING, loopback);
        try {
            ExportScalePyramid.writeScalePyramid(img, new UnsignedShortType(), mipmapInfo, io, executorService, numThreads, loopbackHeuristic, afterEachPlane, progressWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (loopback != null) {
            loopback.close();
        }
    }

    static class HDF5DatasetIO
    implements ExportScalePyramid.DatasetIO<Object, UnsignedShortType> {
        private final IHDF5Access writerQueue;
        private final ViewId viewIdPartition;
        private final HDF5IntStorageFeatures storage;
        private final LoopBackImageLoader loopback;

        public HDF5DatasetIO(IHDF5Access writerQueue, ViewId viewIdPartition, HDF5IntStorageFeatures storage, LoopBackImageLoader loopback) {
            this.writerQueue = writerQueue;
            this.viewIdPartition = viewIdPartition;
            this.storage = storage;
            this.loopback = loopback;
        }

        @Override
        public Object createDataset(int level, long[] dimensions, int[] blockSize) {
            String path = Util.getCellsPath(this.viewIdPartition, level);
            this.writerQueue.createAndOpenDataset(path, (long[])dimensions.clone(), (int[])blockSize.clone(), this.storage);
            return null;
        }

        @Override
        public void writeBlock(Object dataset, ExportScalePyramid.Block<UnsignedShortType> dataBlock) {
            SingleCellArrayImg<UnsignedShortType, ?> img = dataBlock.getData();
            long[] blockDimensions = Intervals.dimensionsAsLongArray(img);
            long[] offset = Intervals.minAsLongArray(img);
            this.writerQueue.writeBlockWithOffset((short[])Cast.unchecked((Object)img.getStorageArray()), blockDimensions, offset);
        }

        @Override
        public void flush(Object dataset) {
            this.writerQueue.closeDataset();
        }

        @Override
        public RandomAccessibleInterval<UnsignedShortType> getImage(int level) {
            return this.loopback.getSetupImgLoader(this.viewIdPartition.getViewSetupId()).getImage(this.viewIdPartition.getTimePointId(), level, new ImgLoaderHint[0]);
        }
    }

    static class LoopBackImageLoader
    extends Hdf5ImageLoader {
        private LoopBackImageLoader(IHDF5Reader existingHdf5Reader, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
            super(null, existingHdf5Reader, null, sequenceDescription, false);
        }

        static LoopBackImageLoader create(IHDF5Reader existingHdf5Reader, int timepointIdPartition, int setupIdPartition, Dimensions imageDimensions) {
            HashMap<Integer, TimePoint> timepoints = new HashMap<Integer, TimePoint>();
            timepoints.put(timepointIdPartition, new TimePoint(timepointIdPartition));
            HashMap<Integer, BasicViewSetup> setups = new HashMap<Integer, BasicViewSetup>();
            setups.put(setupIdPartition, new BasicViewSetup(setupIdPartition, null, imageDimensions, null));
            SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepoints), setups, null, null);
            return new LoopBackImageLoader(existingHdf5Reader, seq);
        }
    }
}

