/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.catmaid;

import bdv.img.cache.CacheArrayLoader;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;

public class CatmaidVolatileIntArrayLoader
implements CacheArrayLoader<VolatileIntArray> {
    private final String urlFormat;
    private final int tileWidth;
    private final int tileHeight;
    private final int[] zScales;

    public CatmaidVolatileIntArrayLoader(String urlFormat, int tileWidth, int tileHeight, int[] zScales) {
        this.urlFormat = urlFormat;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.zScales = zScales;
    }

    @Override
    public int getBytesPerElement() {
        return 4;
    }

    private final void loadSliceArray(int[] slice, int level, double scale, long c0, long r0, long x0, long y0, long z, long xm, long ym, long[] min, int w, int h) throws InterruptedException {
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D g2d = image.createGraphics();
        long c = c0;
        for (long x = x0; x < xm; x += (long)this.tileWidth) {
            long r = r0;
            for (long y = y0; y < ym; y += (long)this.tileHeight) {
                try {
                    String urlString = String.format(this.urlFormat, level, scale, x, y, z, this.tileWidth, this.tileHeight, r, c);
                    URL url = new URL(urlString);
                    BufferedImage tile = ImageIO.read(url);
                    g2d.drawImage((Image)tile, (int)(x - min[0]), (int)(y - min[1]), null);
                }
                catch (IOException e) {
                    System.out.println("failed loading r=" + r + " c=" + c);
                }
                ++r;
            }
            ++c;
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, slice, 0, w);
        pg.grabPixels();
    }

    private final void averageSlice(int[] slice, int level, double scale, long c0, long r0, long x0, long y0, long xm, long ym, long[] min, int w, int h) throws InterruptedException {
        long[] rs = new long[slice.length];
        long[] gs = new long[slice.length];
        long[] bs = new long[slice.length];
        int z = (int)min[2] * this.zScales[level];
        for (int dz = 0; dz < this.zScales[level]; ++dz) {
            this.loadSliceArray(slice, level, scale, c0, r0, x0, y0, z + dz, xm, ym, min, w, h);
            for (int i = 0; i < slice.length; ++i) {
                int n = i;
                rs[n] = rs[n] + (long)(slice[i] >> 16 & 0xFF);
                int n2 = i;
                gs[n2] = gs[n2] + (long)(slice[i] >> 8 & 0xFF);
                int n3 = i;
                bs[n3] = bs[n3] + (long)(slice[i] & 0xFF);
            }
        }
        for (int i = 0; i < slice.length; ++i) {
            int red = (int)(rs[i] / (long)this.zScales[level]);
            int green = (int)(gs[i] / (long)this.zScales[level]);
            int blue = (int)(bs[i] / (long)this.zScales[level]);
            slice[i] = (red << 8 | green) << 8 | blue | 0xFF000000;
        }
    }

    @Override
    public VolatileIntArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        int[] data;
        int w = dimensions[0];
        int h = dimensions[1];
        long xm = min[0] + (long)w;
        long ym = min[1] + (long)h;
        double scale = 1.0 / Math.pow(2.0, level);
        int[] slice = new int[w * h];
        long c0 = min[0] / (long)this.tileWidth;
        long r0 = min[1] / (long)this.tileHeight;
        long x0 = c0 * (long)this.tileWidth;
        long y0 = r0 * (long)this.tileHeight;
        if (dimensions[2] > 1) {
            data = new int[w * h * dimensions[2]];
            long[] zMin = (long[])min.clone();
            for (int z = 0; z < dimensions[2]; ++z) {
                zMin[2] = min[2] + (long)z;
                if (this.zScales[level] > 1) {
                    this.averageSlice(slice, level, scale, c0, r0, x0, y0, xm, ym, zMin, w, h);
                } else {
                    this.loadSliceArray(slice, level, scale, c0, r0, x0, y0, zMin[2], xm, ym, zMin, w, h);
                }
                System.arraycopy(slice, 0, data, z * slice.length, slice.length);
            }
        } else {
            data = slice;
            if (this.zScales[level] > 1) {
                this.averageSlice(slice, level, scale, c0, r0, x0, y0, xm, ym, min, w, h);
            } else {
                this.loadSliceArray(slice, level, scale, c0, r0, x0, y0, min[2], xm, ym, min, w, h);
            }
        }
        return new VolatileIntArray(data, true);
    }
}

