/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.hdf5;

import bdv.img.hdf5.DimsAndExistence;
import bdv.img.hdf5.HDF5Access;
import bdv.img.hdf5.IHDF5Access;
import bdv.img.hdf5.Util;
import bdv.img.hdf5.ViewLevelId;
import ch.systemsx.cisd.hdf5.IHDF5FileLevelReadOnlyHandler;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFHelper;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

class HDF5AccessHack
implements IHDF5Access {
    private final IHDF5Reader hdf5Reader;
    private final long fileId;
    private final long numericConversionXferPropertyListID;
    private final long[] reorderedDimensions = new long[3];
    private final long[] reorderedMin = new long[3];
    private static final int MAX_OPEN_DATASETS = 48;
    private final OpenDataSetCache openDataSetCache;

    public HDF5AccessHack(IHDF5Reader hdf5Reader) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        this.hdf5Reader = hdf5Reader;
        long fileAccessPropertyListId = HDF5Constants.H5P_DEFAULT;
        IHDF5FileLevelReadOnlyHandler fileHandler = hdf5Reader.file();
        boolean performNumericConversions = fileHandler.isPerformNumericConversions();
        File file = fileHandler.getFile();
        H5.H5open();
        this.numericConversionXferPropertyListID = performNumericConversions ? HDFHelper.H5Pcreate_xfer_abort_overflow() : HDFHelper.H5Pcreate_xfer_abort();
        this.fileId = H5.H5Fopen((String)file.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (long)fileAccessPropertyListId);
        this.openDataSetCache = new OpenDataSetCache();
    }

    @Override
    public synchronized DimsAndExistence getDimsAndExistence(ViewLevelId id) {
        long[] realDimensions = new long[3];
        boolean exists = false;
        try {
            OpenDataSet dataset = this.openDataSetCache.getDataSet(id);
            long[] dimensions = new long[HDF5Constants.H5S_MAX_RANK];
            long[] maxDimensions = new long[HDF5Constants.H5S_MAX_RANK];
            int rank = H5.H5Sget_simple_extent_dims((long)dataset.fileSpaceId, (long[])dimensions, (long[])maxDimensions);
            System.arraycopy(dimensions, 0, realDimensions, 0, rank);
            exists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exists) {
            return new DimsAndExistence(Util.reorder(realDimensions), true);
        }
        return new DimsAndExistence(new long[]{1L, 1L, 1L}, false);
    }

    @Override
    public synchronized short[] readShortMDArrayBlockWithOffset(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        short[] dataBlock = new short[dimensions[0] * dimensions[1] * dimensions[2]];
        this.readShortMDArrayBlockWithOffset(timepoint, setup, level, dimensions, min, dataBlock);
        return dataBlock;
    }

    @Override
    public synchronized short[] readShortMDArrayBlockWithOffset(int timepoint, int setup, int level, int[] dimensions, long[] min, short[] dataBlock) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Util.reorder(dimensions, this.reorderedDimensions);
        Util.reorder(min, this.reorderedMin);
        OpenDataSet dataset = this.openDataSetCache.getDataSet(new ViewLevelId(timepoint, setup, level));
        long memorySpaceId = H5.H5Screate_simple((int)this.reorderedDimensions.length, (long[])this.reorderedDimensions, null);
        H5.H5Sselect_hyperslab((long)dataset.fileSpaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])this.reorderedMin, null, (long[])this.reorderedDimensions, null);
        H5.H5Dread((long)dataset.dataSetId, (long)HDF5Constants.H5T_NATIVE_INT16, (long)memorySpaceId, (long)dataset.fileSpaceId, (long)this.numericConversionXferPropertyListID, (Object)dataBlock);
        H5.H5Sclose((long)memorySpaceId);
        return dataBlock;
    }

    @Override
    public float[] readShortMDArrayBlockWithOffsetAsFloat(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        float[] dataBlock = new float[dimensions[0] * dimensions[1] * dimensions[2]];
        this.readShortMDArrayBlockWithOffsetAsFloat(timepoint, setup, level, dimensions, min, dataBlock);
        return dataBlock;
    }

    @Override
    public float[] readShortMDArrayBlockWithOffsetAsFloat(int timepoint, int setup, int level, int[] dimensions, long[] min, float[] dataBlock) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Util.reorder(dimensions, this.reorderedDimensions);
        Util.reorder(min, this.reorderedMin);
        OpenDataSet dataset = this.openDataSetCache.getDataSet(new ViewLevelId(timepoint, setup, level));
        long memorySpaceId = H5.H5Screate_simple((int)this.reorderedDimensions.length, (long[])this.reorderedDimensions, null);
        H5.H5Sselect_hyperslab((long)dataset.fileSpaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])this.reorderedMin, null, (long[])this.reorderedDimensions, null);
        H5.H5Dread((long)dataset.dataSetId, (long)HDF5Constants.H5T_NATIVE_FLOAT, (long)memorySpaceId, (long)dataset.fileSpaceId, (long)this.numericConversionXferPropertyListID, (Object)dataBlock);
        H5.H5Sclose((long)memorySpaceId);
        HDF5Access.unsignedShort(dataBlock);
        return dataBlock;
    }

    @Override
    public void closeAllDataSets() {
        for (OpenDataSet dataset : this.openDataSetCache.values()) {
            dataset.close();
        }
        this.openDataSetCache.clear();
    }

    @Override
    public void close() {
        this.closeAllDataSets();
        int status = 0;
        status = H5.H5Pclose((long)this.numericConversionXferPropertyListID);
        if (status < 0) {
            System.err.println("HDF5AccessHack: Error closing property list");
        }
        if ((status = H5.H5Fclose((long)this.fileId)) < 0) {
            System.err.println("HDF5AccessHack: Error closing file");
        }
        this.hdf5Reader.close();
    }

    private class OpenDataSetCache
    extends LinkedHashMap<ViewLevelId, OpenDataSet> {
        private static final long serialVersionUID = 1L;

        public OpenDataSetCache() {
            super(48, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<ViewLevelId, OpenDataSet> eldest) {
            if (this.size() > 48) {
                eldest.getValue().close();
                return true;
            }
            return false;
        }

        public OpenDataSet getDataSet(ViewLevelId id) {
            OpenDataSet openDataSet = (OpenDataSet)super.get(id);
            if (openDataSet == null) {
                openDataSet = new OpenDataSet(Util.getCellsPath(id));
                this.put(id, openDataSet);
            }
            return openDataSet;
        }
    }

    private class OpenDataSet {
        final long dataSetId;
        final long fileSpaceId;

        public OpenDataSet(String cellsPath) {
            this.dataSetId = H5.H5Dopen((long)HDF5AccessHack.this.fileId, (String)cellsPath, (long)HDF5Constants.H5P_DEFAULT);
            this.fileSpaceId = H5.H5Dget_space((long)this.dataSetId);
        }

        public void close() {
            H5.H5Sclose((long)this.fileSpaceId);
            H5.H5Dclose((long)this.dataSetId);
        }
    }
}

