/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.imaris;

import bdv.AbstractViewerSetupImgLoader;
import bdv.ViewerImgLoader;
import bdv.cache.CacheControl;
import bdv.img.cache.CacheArrayLoader;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.hdf5.MipmapInfo;
import bdv.img.hdf5.Util;
import bdv.img.hdf5.ViewLevelId;
import bdv.img.imaris.DataTypes;
import bdv.img.imaris.HDF5AccessHack;
import bdv.img.imaris.IHDF5Access;
import bdv.util.MipmapTransforms;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.basictypeaccess.volatiles.VolatileAccess;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;

public class ImarisImageLoader<T extends NativeType<T>, V extends Volatile<T>, A extends VolatileAccess>
implements ViewerImgLoader {
    private IHDF5Access hdf5Access;
    private final File hdf5File;
    private final AbstractSequenceDescription<?, ?, ?> sequenceDescription;
    private DataTypes.DataType<T, V, A> dataType;
    private MipmapInfo mipmapInfo;
    private long[][] mipmapDimensions;
    private VolatileGlobalCellCache cache;
    private CacheArrayLoader<A> loader;
    private final HashMap<Integer, SetupImgLoader> setupImgLoaders;
    private boolean isOpen = false;

    public ImarisImageLoader(File hdf5File, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this.hdf5File = hdf5File;
        this.sequenceDescription = sequenceDescription;
        this.setupImgLoaders = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void open() {
        if (!this.isOpen) {
            ImarisImageLoader imarisImageLoader = this;
            synchronized (imarisImageLoader) {
                if (this.isOpen) {
                    return;
                }
                this.isOpen = true;
                IHDF5Reader hdf5Reader = HDF5Factory.openForReading((File)this.hdf5File);
                try {
                    this.hdf5Access = new HDF5AccessHack(hdf5Reader);
                    this.openDimensions(hdf5Reader);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                List setups = this.sequenceDescription.getViewSetupsOrdered();
                int maxNumLevels = this.mipmapInfo.getNumLevels();
                this.loader = this.dataType.createArrayLoader(this.hdf5Access);
                this.cache = new VolatileGlobalCellCache(maxNumLevels, 1);
                for (BasicViewSetup setup : setups) {
                    int setupId = setup.getId();
                    this.setupImgLoaders.put(setupId, new SetupImgLoader(setupId));
                }
            }
        }
    }

    private void openDimensions(IHDF5Reader reader) throws IOException {
        String fn = this.hdf5File.getAbsolutePath();
        HashMap<Integer, double[]> levelToResolution = new HashMap<Integer, double[]>();
        HashMap<Integer, int[]> levelToSubdivision = new HashMap<Integer, int[]>();
        HashMap<Integer, long[]> levelToDimensions = new HashMap<Integer, long[]>();
        String path = "DataSetInfo/Image";
        int[] imageSize = new int[]{Integer.parseInt(this.hdf5Access.readImarisAttributeString(path, "X")), Integer.parseInt(this.hdf5Access.readImarisAttributeString(path, "Y")), Integer.parseInt(this.hdf5Access.readImarisAttributeString(path, "Z"))};
        this.dataType = null;
        List resolutionNames = reader.getGroupMembers("DataSet");
        for (String resolutionName : resolutionNames) {
            int[] blockDims;
            long[] dims;
            double[] resolution;
            int level;
            block14: {
                HDF5DataSetInformation info;
                String channelName;
                String timepointName;
                block15: {
                    HDF5DataTypeInformation ti;
                    block16: {
                        if (!resolutionName.startsWith("ResolutionLevel ")) {
                            throw new IOException("unexpected content '" + resolutionName + "' while reading " + fn);
                        }
                        level = Integer.parseInt(resolutionName.substring("ResolutionLevel ".length()));
                        List timepointNames = reader.getGroupMembers("DataSet/" + resolutionName);
                        if (timepointNames.isEmpty()) {
                            throw new IOException("could not find any TimePoint in " + fn);
                        }
                        timepointName = (String)timepointNames.get(0);
                        List channelNames = reader.getGroupMembers("DataSet/" + resolutionName + "/" + timepointName);
                        if (channelNames.isEmpty()) {
                            throw new IOException("could not find any Channel in " + fn);
                        }
                        channelName = (String)channelNames.get(0);
                        info = reader.getDataSetInformation("DataSet/" + resolutionName + "/" + timepointName + "/" + channelName + "/Data");
                        if (this.dataType != null) break block15;
                        ti = info.getTypeInformation();
                        if (!ti.getDataClass().equals((Object)HDF5DataClass.INTEGER)) break block16;
                        switch (ti.getElementSize()) {
                            case 1: {
                                this.dataType = DataTypes.UnsignedByte;
                                break block15;
                            }
                            case 2: {
                                this.dataType = DataTypes.UnsignedShort;
                                break block15;
                            }
                            default: {
                                throw new IOException("expected datatype" + ti);
                            }
                        }
                    }
                    if (ti.getDataClass().equals((Object)HDF5DataClass.FLOAT)) {
                        if (ti.getElementSize() == 4) {
                            this.dataType = DataTypes.Float;
                        } else {
                            throw new IOException("expected datatype" + ti);
                        }
                    }
                }
                if ((resolution = (double[])levelToResolution.get(level)) != null) continue;
                path = "DataSet/" + resolutionName + "/" + timepointName + "/" + channelName;
                dims = new long[]{Integer.parseInt(this.hdf5Access.readImarisAttributeString(path, "ImageSizeX")), Integer.parseInt(this.hdf5Access.readImarisAttributeString(path, "ImageSizeY")), Integer.parseInt(this.hdf5Access.readImarisAttributeString(path, "ImageSizeZ"))};
                blockDims = new int[]{16, 16, 16};
                try {
                    blockDims[0] = Integer.parseInt(this.hdf5Access.readImarisAttributeString(path, "ImageBlockSizeX"));
                    blockDims[1] = Integer.parseInt(this.hdf5Access.readImarisAttributeString(path, "ImageBlockSizeY"));
                    blockDims[2] = Integer.parseInt(this.hdf5Access.readImarisAttributeString(path, "ImageBlockSizeZ"));
                }
                catch (NumberFormatException e) {
                    int[] chunkSizes = info.tryGetChunkSizes();
                    if (chunkSizes == null) break block14;
                    chunkSizes = Util.reorder(chunkSizes);
                    System.arraycopy(chunkSizes, 0, blockDims, 0, 3);
                }
            }
            resolution = new double[]{(long)imageSize[0] / dims[0], (long)imageSize[1] / dims[1], (long)imageSize[2] / dims[2]};
            levelToDimensions.put(level, dims);
            levelToResolution.put(level, resolution);
            levelToSubdivision.put(level, blockDims);
        }
        int numLevels = levelToResolution.size();
        this.mipmapDimensions = new long[numLevels][];
        double[][] resolutions = new double[numLevels][];
        int[][] subdivisions = new int[numLevels][];
        AffineTransform3D[] transforms = new AffineTransform3D[numLevels];
        for (int level = 0; level < numLevels; ++level) {
            this.mipmapDimensions[level] = (long[])levelToDimensions.get(level);
            resolutions[level] = (double[])levelToResolution.get(level);
            subdivisions[level] = (int[])levelToSubdivision.get(level);
            transforms[level] = MipmapTransforms.getMipmapTransformDefault(resolutions[level]);
        }
        this.mipmapInfo = new MipmapInfo(resolutions, transforms, subdivisions);
    }

    protected <T extends NativeType<T>> AbstractCellImg<T, A, ?, ?> prepareCachedImage(ViewLevelId id, LoadingStrategy loadingStrategy, T type) {
        this.open();
        int timepointId = id.getTimePointId();
        int setupId = id.getViewSetupId();
        int level = id.getLevel();
        long[] dimensions = this.mipmapDimensions[level];
        int[] cellDimensions = this.mipmapInfo.getSubdivisions()[level];
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        int priority = this.mipmapInfo.getMaxLevel() - level;
        CacheHints cacheHints = new CacheHints(loadingStrategy, priority, false);
        return this.cache.createImg(grid, timepointId, setupId, level, cacheHints, this.loader, type);
    }

    public File getImsFile() {
        return this.hdf5File;
    }

    @Override
    public CacheControl getCacheControl() {
        this.open();
        return this.cache;
    }

    @Override
    public SetupImgLoader getSetupImgLoader(int setupId) {
        this.open();
        return this.setupImgLoaders.get(setupId);
    }

    public class SetupImgLoader
    extends AbstractViewerSetupImgLoader<T, V> {
        private final int setupId;

        protected SetupImgLoader(int setupId) {
            super(ImarisImageLoader.this.dataType.getType(), ImarisImageLoader.this.dataType.getVolatileType());
            this.setupId = setupId;
        }

        public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
            ViewLevelId id = new ViewLevelId(timepointId, this.setupId, level);
            return ImarisImageLoader.this.prepareCachedImage(id, LoadingStrategy.BLOCKING, ImarisImageLoader.this.dataType.getType());
        }

        @Override
        public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
            ViewLevelId id = new ViewLevelId(timepointId, this.setupId, level);
            return ImarisImageLoader.this.prepareCachedImage(id, LoadingStrategy.BUDGETED, (NativeType)ImarisImageLoader.this.dataType.getVolatileType());
        }

        public double[][] getMipmapResolutions() {
            return ImarisImageLoader.this.mipmapInfo.getResolutions();
        }

        public AffineTransform3D[] getMipmapTransforms() {
            return ImarisImageLoader.this.mipmapInfo.getTransforms();
        }

        public int numMipmapLevels() {
            return ImarisImageLoader.this.mipmapInfo.getNumLevels();
        }
    }
}

